/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.view;

import br.com.ctecinf.Daruma;
import br.com.ctecinf.Database;
import br.com.ctecinf.Empresa;
import br.com.ctecinf.model.Cliente;
import br.com.ctecinf.model.Fornecedor;
import br.com.ctecinf.model.Grupo;
import br.com.ctecinf.model.Ncm;
import br.com.ctecinf.model.Produto;
import br.com.ctecinf.model.SubGrupo;
import br.com.ctecinf.model.Usuario;
import br.com.ctecinf.nfe.view.MenuNFCe;
import br.com.ctecinf.orm.swing.FormPanelController;
import br.com.ctecinf.orm.swing.TablePanelController;
import br.com.ctecinf.swing.Image;
import br.com.ctecinf.swing.OptionPane;
import br.com.ctecinf.swing.PleaseWaitDialog;
import br.com.ctecinf.swing.RelatorioPanel;
import br.com.ctecinf.swing.TabbedPane;
import br.com.ctecinf.view.ClienteForm;
import br.com.ctecinf.view.CrediarioForm;
import br.com.ctecinf.view.EstoquePanel;
import br.com.ctecinf.view.FornecedorForm;
import br.com.ctecinf.view.LenteForm;
import br.com.ctecinf.view.ProdutoForm;
import br.com.ctecinf.view.ReceitaForm;
import br.com.ctecinf.view.SimuladorJurosPanel;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MenuBar
extends JMenuBar {
    private final TabbedPane pane;

    public MenuBar(TabbedPane pane) {
        this.pane = pane;
        this.initUI();
    }

    private void initUI() {
        this.add(new MenuNFCe(this.pane));
        JMenu menu = new JMenu("Cadastro");
        menu.setIcon(Image.parse("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", 32));
        for (JMenuItem item : this.itemsCadastro()) {
            menu.add(item);
        }
        this.add(menu);
        menu = new JMenu("Relat\u00f3rio");
        menu.setIcon(Image.parse("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"));
        for (JMenuItem item : this.itemsRelatorio()) {
            menu.add(item);
        }
        this.add(menu);
        menu = new JMenu("Ferramentas");
        menu.setIcon(Image.parse("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", 32));
        for (JMenuItem item : this.itemsFerramenta()) {
            menu.add(item);
        }
        this.add(menu);
    }

    private List<JMenuItem> itemsRelatorio() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        JMenuItem item = new JMenuItem("Clientes no SPC");
        item.addActionListener(e -> {
            String query = "SELECT nome AS \"Nome\", cpf AS \"CPF\", spc AS \"Data Cadastro SPC\" FROM cliente WHERE spc IS NOT NULL";
            this.pane.add("Clientes no SPC", new RelatorioPanel(query));
        });
        items.add(item);
        item = new JMenuItem("Credi\u00e1rio Atrasado");
        item.addActionListener(e -> {
            Calendar dt = Calendar.getInstance(new Locale("pt", "BR"));
            dt.add(5, -10);
            dt.add(1, -5);
            Date ini = new Date(dt.getTimeInMillis());
            dt.add(1, 5);
            Date end = new Date(dt.getTimeInMillis());
            String query = "SELECT c.id AS \"C\u00f3digo\", cli.nome AS \"Cliente\", c.data_venda AS \"Data Venda\", c.valor_total AS \"Total da Venda\", (c.numero_parcelas + 1) AS \"Num. de Parcelas\", COUNT(p.id) AS \"Qtde. Parcelas Atrasadas\", SUM(p.valor) AS \"Total Atrasado\"FROM crediario c JOIN cliente cli ON c.cliente_id = cli.id JOIN parcela p ON p.crediario_id = c.id WHERE p.data_vencimento BETWEEN '" + String.valueOf(ini) + "' AND '" + String.valueOf(end) + "' AND p.data_pagamento IS NULL GROUP BY c.id, cli.nome, c.data_venda, c.valor_total, c.numero_parcelas ORDER BY c.data_venda DESC";
            this.pane.add("Clientes Atrasados", new RelatorioPanel(query));
        });
        items.add(item);
        return items;
    }

    private List<JMenuItem> itemsCadastro() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        JMenuItem item = new JMenuItem("Cliente");
        item.addActionListener(l -> new PleaseWaitDialog<TablePanelController<Cliente>>(){

            @Override
            public TablePanelController<Cliente> exec() throws Exception {
                return new TablePanelController<Cliente>(){

                    @Override
                    protected FormPanelController<Cliente> getForm(Cliente controller) {
                        return new ClienteForm(controller);
                    }
                };
            }

            @Override
            public void end(TablePanelController<Cliente> result) {
                MenuBar.this.pane.add("Cadastro de cliente", result);
                result.getFilter().requestFocus();
            }
        }.start());
        items.add(item);
        item = new JMenuItem("Fornecedor");
        item.addActionListener(l -> new PleaseWaitDialog<TablePanelController<Fornecedor>>(){

            @Override
            public TablePanelController<Fornecedor> exec() throws Exception {
                return new TablePanelController<Fornecedor>(){

                    @Override
                    protected FormPanelController<Fornecedor> getForm(Fornecedor controller) {
                        return new FornecedorForm(controller);
                    }
                };
            }

            @Override
            public void end(TablePanelController<Fornecedor> result) {
                MenuBar.this.pane.add("Cadastro de fornecedor", result);
                result.getFilter().requestFocus();
            }
        }.start());
        items.add(item);
        item = new JMenuItem("NCM");
        item.addActionListener(l -> this.pane.add("Cadastro de NCM", new TablePanelController<Ncm>(){

            @Override
            protected FormPanelController<Ncm> getForm(Ncm controller) {
                return new FormPanelController<Ncm>(controller).getDefaultForm("Cadastro NCM");
            }
        }));
        items.add(item);
        item = new JMenuItem("Grupo");
        item.addActionListener(l -> this.pane.add("Cadastro de Grupo", new TablePanelController<Grupo>(){

            @Override
            protected FormPanelController<Grupo> getForm(Grupo controller) {
                return new FormPanelController<Grupo>(controller).getDefaultForm("Cadastro Grupo");
            }
        }));
        items.add(item);
        item = new JMenuItem("Sub-Grupo");
        item.addActionListener(l -> this.pane.add("Cadastro de Sub-Grupo", new TablePanelController<SubGrupo>(){

            @Override
            protected FormPanelController<SubGrupo> getForm(SubGrupo controller) {
                return new FormPanelController<SubGrupo>(controller).getDefaultForm("Cadastro Sub-Grupo");
            }
        }));
        items.add(item);
        item = new JMenuItem("Usu\u00e1rio Tablet");
        item.addActionListener(l -> this.pane.add("Cadastro de Usu\u00e1rio Tablet", new TablePanelController<Usuario>(){

            @Override
            protected FormPanelController<Usuario> getForm(Usuario controller) {
                return new FormPanelController<Usuario>(controller).getDefaultForm("Cadastro Usu\u00e1rio");
            }
        }));
        items.add(item);
        item = new JMenuItem("Produto");
        item.addActionListener(l -> new PleaseWaitDialog<TablePanelController<Produto>>(){

            @Override
            public TablePanelController<Produto> exec() throws Exception {
                return new TablePanelController<Produto>(){

                    @Override
                    protected FormPanelController<Produto> create(Produto produto) {
                        Produto p = new Produto();
                        if (this.getTable().getSelectedRow() > -1) {
                            Fornecedor f = ((Produto)this.getTable().getModel().getData().get(this.getTable().getRowSorter().convertRowIndexToModel(this.getTable().getSelectedRow()))).getFornecedor();
                            p.setFornecedor(f);
                        }
                        return new ProdutoForm(p);
                    }

                    @Override
                    protected FormPanelController<Produto> getForm(Produto controller) {
                        return new ProdutoForm(controller);
                    }
                };
            }

            @Override
            public void end(TablePanelController<Produto> result) {
                MenuBar.this.pane.add("Cadastro de Produto", result);
                result.getFilter().requestFocus();
            }
        }.start());
        items.add(item);
        item = new JMenuItem("Estoque");
        item.addActionListener(l -> new PleaseWaitDialog<EstoquePanel>(){

            @Override
            public EstoquePanel exec() throws Exception {
                return new EstoquePanel();
            }

            @Override
            public void end(EstoquePanel result) {
                MenuBar.this.pane.add("Estoque", result);
                result.getFilter().requestFocus();
            }
        }.start());
        items.add(item);
        item = new JMenuItem("Novo Credi\u00e1rio");
        item.addActionListener(l -> new PleaseWaitDialog<CrediarioForm>(){

            @Override
            public CrediarioForm exec() throws Exception {
                return new CrediarioForm(null);
            }

            @Override
            public void end(CrediarioForm result) {
                result.getFrame().setVisible(true);
            }
        }.start());
        items.add(item);
        item = new JMenuItem("Novo Tal\u00e3o");
        item.addActionListener(l -> new PleaseWaitDialog<ReceitaForm>(){

            @Override
            public ReceitaForm exec() throws Exception {
                return new ReceitaForm(null);
            }

            @Override
            public void end(ReceitaForm result) {
                result.getFrame().setVisible(true);
            }
        }.start());
        items.add(item);
        item = new JMenuItem("Nova Lente");
        item.addActionListener(l -> new PleaseWaitDialog<LenteForm>(){

            @Override
            public LenteForm exec() throws Exception {
                return new LenteForm(null);
            }

            @Override
            public void end(LenteForm result) {
                result.getFrame().setVisible(true);
            }
        }.start());
        items.add(item);
        return items;
    }

    private List<JMenuItem> itemsFerramenta() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        JMenuItem item = new JMenuItem("Emitir Recibo Avulso");
        item.addActionListener(l -> {
            try {
                Daruma.recibo();
            }
            catch (IOException ex) {
                OptionPane.error(ex);
            }
        });
        items.add(item);
        item = new JMenuItem("Consultar SPC");
        item.addActionListener(l -> {
            try {
                Desktop.getDesktop().browse(URI.create("https://webnet.scpcrs.org.br/Login.aspx"));
            }
            catch (IOException ex) {
                OptionPane.error(ex);
            }
        });
        items.add(item);
        if ("CTecInf Sistemas Gerenciais - ctecinf.com.br (PENDRIVE)".contains("PENDRIVE")) {
            // empty if block
        }
        item = new JMenuItem("Backup Banco de Dados");
        item.addActionListener(l -> {
            final File file = OptionPane.chooseFile(new FileNameExtensionFilter("Arquivo SQL", "sql"));
            new PleaseWaitDialog<File>(this){
                final /* synthetic */ MenuBar this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public File exec() throws Exception {
                    Database.restore(file);
                    return file;
                }

                @Override
                public void end(File result) throws Exception {
                    if (OptionPane.confirm("Backup conclu\u00eddo, deseja visualizar arquivo?")) {
                        Desktop.getDesktop().open(result);
                    }
                }
            }.start();
        });
        items.add(item);
        item = new JMenuItem("Simulador de Juros");
        item.addActionListener(l -> this.pane.add("Simulador de Juros", new SimuladorJurosPanel()));
        items.add(item);
        item = new JMenuItem("Validar XML");
        item.addActionListener(l -> {
            try {
                Desktop.getDesktop().browse(URI.create("https://www.sefaz.rs.gov.br/nfe/nfe-val.aspx"));
            }
            catch (IOException ex) {
                OptionPane.error(ex);
            }
        });
        items.add(item);
        item = new JMenuItem("Sistema SEFAZ (e-CAC)");
        item.addActionListener(l -> {
            try {
                Desktop.getDesktop().browse(URI.create("https://www.sefaz.rs.gov.br/Receita/PortaleCAC.aspx"));
            }
            catch (IOException ex) {
                OptionPane.error(ex);
            }
        });
        items.add(item);
        item = new JMenuItem("Avisos");
        item.addActionListener(l -> {
            if (Empresa.getMensagem() != null) {
                OptionPane.info(Empresa.getMensagem());
            } else {
                OptionPane.info("Voc\u00ea n\u00e3o possui nenhum aviso!");
            }
        });
        items.add(item);
        return items;
    }
}

