/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.view;

import br.com.ctecinf.Daruma;
import br.com.ctecinf.model.Crediario;
import br.com.ctecinf.model.Parcela;
import br.com.ctecinf.orm.swing.FormPanelController;
import br.com.ctecinf.orm.swing.TablePanelController;
import br.com.ctecinf.swing.Image;
import br.com.ctecinf.swing.OptionPane;
import br.com.ctecinf.table.Table;
import br.com.ctecinf.table.TableModel;
import br.com.ctecinf.view.ParcelaForm;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import javax.swing.JFormattedTextField;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class CrediarioForm
extends FormPanelController<Crediario>
implements FocusListener {
    private static final String TITLE = "Cadastro de Crediario";
    private TableModel modelParcelas;

    @Override
    protected boolean print() throws Exception {
        try {
            Daruma.carnet((Crediario)this.getController());
            return true;
        }
        catch (Exception ex) {
            OptionPane.error(ex);
            return false;
        }
    }

    @Override
    protected boolean save(Map params) throws Exception {
        ((Crediario)this.getController()).setValues(params);
        ((Crediario)this.getController()).save();
        for (Object obj : this.modelParcelas.getData()) {
            Parcela parcela = (Parcela)obj;
            parcela.setCrediario((Crediario)this.getController());
            parcela.save();
        }
        this.getFrame().dispose();
        return true;
    }

    public CrediarioForm(Crediario controller) {
        super(controller == null ? new Crediario() : controller, 2);
        this.init();
    }

    private void init() {
        Table parcelaTable = null;
        try {
            this.modelParcelas = ((Crediario)this.getController()).getTableModel(Parcela.class);
            parcelaTable = new TablePanelController<Parcela>(this.modelParcelas){

                @Override
                protected FormPanelController<Parcela> getForm(Parcela controller) {
                    return new ParcelaForm(controller);
                }
            }.getTable();
        }
        catch (Exception ex) {
            OptionPane.error(ex);
        }
        this.addRequiredFieldLabel();
        this.addLine("cliente");
        this.addBreakLine();
        this.addColumn("dataVenda", "notaFiscal");
        this.addColumn("valorTotal", "numeroParcelas");
        JScrollPane scroll = new JScrollPane(parcelaTable);
        scroll.setPreferredSize(new Dimension(0, 160));
        this.addLine(scroll);
        this.addBreakLine();
        this.addColumn("dataAviso1", "dataAviso2");
        this.addLine("observacao");
        this.addAction("Fechar", Image.parse("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"), e -> this.getFrame().dispose());
        this.setFieldsValues();
        ((Component)this.getComponent("dataVenda")).addFocusListener(this);
        ((Component)this.getComponent("numeroParcelas")).addFocusListener(this);
        ((Component)this.getComponent("valorTotal")).addFocusListener(this);
        this.createFrame(TITLE);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        SwingUtilities.invokeLater(() -> {
            JFormattedTextField dataVenda = (JFormattedTextField)this.getFields().getComponent("dataVenda");
            JFormattedTextField numeroParcelas = (JFormattedTextField)this.getFields().getComponent("numeroParcelas");
            Number numParc = (Number)numeroParcelas.getValue();
            Number vl = (Number)((JFormattedTextField)this.getFields().getComponent("valorTotal")).getValue();
            if (vl != null && numParc != null && dataVenda.getValue() != null) {
                BigDecimal prest = BigDecimal.valueOf(vl.doubleValue() / (double)numParc.intValue());
                Calendar cal = Calendar.getInstance(new Locale("pt", "BR"));
                cal.setTimeInMillis(((Date)dataVenda.getValue()).getTime());
                this.modelParcelas.removeAllRows();
                for (int i = 0; i < numParc.intValue(); ++i) {
                    Parcela parcela = new Parcela();
                    parcela.setNumeroParcela(i + 1);
                    parcela.setDataVencimento(new Date(cal.getTimeInMillis()));
                    parcela.setValor(prest);
                    parcela.setDataPagamento(null);
                    parcela.setValorPago(null);
                    this.modelParcelas.addRow(parcela);
                    cal.add(5, 30);
                }
            }
        });
    }
}

