/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.view;

import br.com.ctecinf.autocomplete.AutoCompleteField;
import br.com.ctecinf.autocomplete.AutoCompleteModel;
import br.com.ctecinf.model.Cliente;
import br.com.ctecinf.model.Crediario;
import br.com.ctecinf.model.Municipio;
import br.com.ctecinf.model.Receita;
import br.com.ctecinf.orm.swing.FormPanelController;
import br.com.ctecinf.orm.swing.TablePanelController;
import br.com.ctecinf.swing.Image;
import br.com.ctecinf.swing.OptionPane;
import br.com.ctecinf.view.CrediarioForm;
import br.com.ctecinf.view.ReceitaForm;
import java.sql.Date;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ClienteForm
extends FormPanelController<Cliente> {
    private static final String TITLE = "Cadastro de Cliente";

    public ClienteForm(Cliente controller) {
        super("Cliente", controller == null ? new Cliente() : controller, 3);
        this.init();
    }

    @Override
    protected boolean save(Map params) throws Exception {
        if (super.save(params)) {
            Receita receita = new Receita();
            receita.setCliente((Cliente)this.getController());
            new ReceitaForm(receita).setVisible(true);
            return true;
        }
        return false;
    }

    private void init() {
        if (((Cliente)this.getController()).getId() == null) {
            ((Cliente)this.getController()).setDataCadastro(new Date(System.currentTimeMillis()));
        }
        AutoCompleteModel municipios = new Municipio().getAutoCompleteModel();
        this.addRequiredFieldLabel();
        this.addLine(new AutoCompleteField("nome", ((Cliente)this.getController()).getAutoCompleteModel()));
        this.addColumn("sexo", "estadoCivil", "dataCadastro");
        this.addColumn("dataNascimento", "cpf", "rg");
        this.addColumn(new AutoCompleteField("naturalidade", municipios), "salario", "carteiraTrabalho");
        this.addLine("nomePai");
        this.addLine("nomeMae");
        this.addLine("endereco");
        this.addColumn((Object)"bairro", this.getColumn(), 2);
        this.addColumn("cep");
        this.addLine(new AutoCompleteField("municipio", municipios));
        this.addColumn((Object)"fone", 0);
        this.addColumn((Object)"celular", 1);
        this.addTab("Contatos", 3);
        this.addLine("email");
        this.addTitle("Empresa");
        this.addColumn("empresa");
        this.addColumn((Object)"enderecoEmpresa", this.getColumn(), 2);
        this.addTitle("Conjuge");
        this.addColumn((Object)"conjuge", this.getColumn(), 2);
        this.addColumn("dataNascimentoConjuge");
        this.addColumn("rgConjuge", "foneConjuge", "celularConjuge");
        this.addTitle("Conhecido");
        this.addColumn((Object)"conhecido", this.getColumn(), 2);
        this.addColumn("foneConhecido");
        this.addColumn("spc");
        this.newRow();
        this.addTitle("Observacao");
        this.addLine("observacao");
        this.setFieldsValues();
        JTabbedPane tab = (JTabbedPane)this.getForm();
        JScrollPane receita = null;
        try {
            receita = new JScrollPane(new TablePanelController<Receita>(((Cliente)this.getController()).getTableModel(Receita.class)){

                @Override
                protected FormPanelController<Receita> getForm(Receita controller) {
                    return new ReceitaForm(controller);
                }
            }.getTable());
        }
        catch (Exception ex) {
            OptionPane.error(ex);
        }
        JScrollPane crediario = null;
        try {
            crediario = new JScrollPane(new TablePanelController<Crediario>(((Cliente)this.getController()).getTableModel(Crediario.class)){

                @Override
                protected FormPanelController<Crediario> getForm(Crediario controller) {
                    return new CrediarioForm(controller);
                }
            }.getTable());
        }
        catch (Exception ex) {
            OptionPane.error(ex);
        }
        if (receita != null) {
            tab.add("Receita", receita);
        }
        if (crediario != null) {
            tab.add("Crediario", crediario);
        }
        this.addAction("Fechar", Image.parse("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"), e -> this.getFrame().dispose());
        this.createFrame(TITLE);
    }
}

