/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.text;

import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class TimeFormatter
extends JFormattedTextField.AbstractFormatter {
    private int length = 4;
    private String mask = "##:##";
    private static final DateFormat DTF = DateFormat.getTimeInstance(3, new Locale("pt", "BR"));
    private final DocumentFilter df = new DocumentFilter(){

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (offset == TimeFormatter.this.mask.length() - 1) {
                TimeFormatter.this.getFormattedTextField().transferFocus();
            }
            if (offset >= TimeFormatter.this.mask.length()) {
                return;
            }
            if (!Character.isDigit(((String)text).charAt(length))) {
                return;
            }
            if (TimeFormatter.this.mask.charAt(offset) != '#') {
                text = String.valueOf(TimeFormatter.this.mask.charAt(offset)) + (String)text;
            }
            super.replace(fb, offset, length, (String)text, attrs);
        }
    };

    @Override
    public Object stringToValue(String text) throws ParseException {
        if (text.isEmpty() || text.length() < this.mask.length()) {
            this.getFormattedTextField().setValue(null);
            return null;
        }
        return new Time(DTF.parse(text).getTime());
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value instanceof String && value.toString().length() == this.length) {
            Object str = "";
            int index = 0;
            for (char c : this.mask.toCharArray()) {
                if (c == '#') {
                    str = (String)str + value.toString().charAt(index);
                    ++index;
                    continue;
                }
                str = (String)str + c;
            }
            return str;
        }
        return value == null ? "" : DTF.format(value);
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        return this.df;
    }

    public static DateFormat format() {
        return DTF;
    }
}

