/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.text;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class PasswordFormatter
extends JFormattedTextField.AbstractFormatter {
    private String password = "";
    private final DocumentFilter df = new DocumentFilter(){

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            PasswordFormatter.this.password = PasswordFormatter.this.password.substring(0, offset) + text;
            super.replace(fb, offset, length, "*", attrs);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            PasswordFormatter.this.password = PasswordFormatter.this.password.substring(0, offset);
            super.remove(fb, offset, length);
        }
    };

    private String md5(String value) {
        byte[] messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5").digest(value.getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println(ex);
        }
        return new BigInteger(1, messageDigest).toString(16);
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        return text.isEmpty() ? null : this.md5(this.password);
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value == null) {
            return null;
        }
        this.password = value.toString();
        Object pass = "";
        for (int i = 0; i < value.toString().length(); ++i) {
            pass = (String)pass + "*";
        }
        return pass;
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        return this.df;
    }
}

