/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.text;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JFormattedTextField;

public class NumberFormatter
extends JFormattedTextField.AbstractFormatter {
    private NumberFormat nf;

    public NumberFormatter(int fractionDigits) {
        this.setNumberFormat(fractionDigits);
    }

    private void setNumberFormat(int fractionDigits) {
        this.nf = DecimalFormat.getNumberInstance(new Locale("pt", "BR"));
        this.nf.setMinimumFractionDigits(fractionDigits);
        this.nf.setMaximumFractionDigits(fractionDigits);
        if (fractionDigits == 0) {
            this.nf.setGroupingUsed(false);
            this.nf.setParseIntegerOnly(true);
        }
    }

    @Override
    public Number stringToValue(String text) throws ParseException {
        return text == null || text.isEmpty() ? (Number)new Number(){

            @Override
            public int intValue() {
                return 0;
            }

            @Override
            public long longValue() {
                return 0L;
            }

            @Override
            public float floatValue() {
                return 0.0f;
            }

            @Override
            public double doubleValue() {
                return 0.0;
            }
        } : (Number)this.nf.parse(text);
    }

    @Override
    public String valueToString(final Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        Number num = value instanceof Number ? (Number)((Number)value) : (Number)new Number(this){
            final /* synthetic */ NumberFormatter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int intValue() {
                return Integer.parseInt(value.toString());
            }

            @Override
            public long longValue() {
                return Long.parseLong(value.toString());
            }

            @Override
            public float floatValue() {
                return Float.parseFloat(value.toString());
            }

            @Override
            public double doubleValue() {
                return Double.parseDouble(value.toString());
            }
        };
        return this.nf.format(num);
    }

    public static NumberFormat format() {
        return NumberFormatter.format(2);
    }

    public static NumberFormat format(int fractionDigits) {
        return NumberFormatter.format(fractionDigits, new Locale("pt", "BR"), fractionDigits == 0);
    }

    public static NumberFormat format(int fractionDigits, Locale locale, boolean grouping) {
        NumberFormat numberFormat = DecimalFormat.getNumberInstance(locale);
        numberFormat.setMinimumFractionDigits(fractionDigits);
        numberFormat.setMaximumFractionDigits(fractionDigits);
        numberFormat.setGroupingUsed(grouping);
        if (fractionDigits == 0) {
            numberFormat.setParseIntegerOnly(true);
        }
        return numberFormat;
    }

    public static String formatUS2Digits(Object value) {
        return NumberFormatter.formatUS(value, 2);
    }

    public static String formatUS4Digits(Object value) {
        return NumberFormatter.formatUS(value, 4);
    }

    public static String formatUS(Object value, int fractionDigits) {
        NumberFormat nf = NumberFormatter.get(fractionDigits, Locale.US);
        return nf.format(value);
    }

    public static double parseUS2Digits(String value) throws ParseException {
        return NumberFormatter.get(2, Locale.US).parse(value == null ? "0" : value).doubleValue();
    }

    private static NumberFormat get(int fractionDigits, Locale locale) {
        NumberFormat nf = DecimalFormat.getNumberInstance(locale);
        nf.setMinimumFractionDigits(fractionDigits);
        nf.setMaximumFractionDigits(fractionDigits);
        if (fractionDigits == 0) {
            nf.setGroupingUsed(false);
            nf.setParseIntegerOnly(true);
        }
        return nf;
    }
}

