/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.text;

import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class MaskFormatter
extends JFormattedTextField.AbstractFormatter {
    public static final String CPF = "###.###.###-##";
    public static final String CEP = "#####-###";
    public static final String CNPJ = "##.###.###/####-##";
    public static final String PHONE = "## #####-####";
    private static final String MASK_PHONE_8 = "## ####-####";
    private static final String MASK_PHONE_9 = "## #####-####";
    private String mask = "";
    private boolean isPhone = false;
    private final DocumentFilter df = new DocumentFilter(){

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (!Character.isDigit(((String)text).charAt(length))) {
                return;
            }
            if (MaskFormatter.this.isPhone) {
                if (offset == 1) {
                    text = (String)text + " ";
                }
                if (offset == 6) {
                    text = (String)text + "-";
                }
                if (offset == "## #####-####".length() - 1) {
                    super.remove(fb, 7, 1);
                    super.insertString(fb, 8, "-", attrs);
                    super.replace(fb, offset, length, (String)text, attrs);
                    MaskFormatter.this.getFormattedTextField().transferFocus();
                    return;
                }
                super.replace(fb, offset, length, (String)text, attrs);
            } else {
                if (offset == MaskFormatter.this.mask.length() - 1) {
                    MaskFormatter.this.getFormattedTextField().transferFocus();
                }
                if (offset >= MaskFormatter.this.mask.length()) {
                    return;
                }
                if (((String)text).length() < length || !Character.isDigit(((String)text).charAt(length))) {
                    return;
                }
                if (MaskFormatter.this.mask.charAt(offset) != '#') {
                    text = String.valueOf(MaskFormatter.this.mask.charAt(offset)) + (String)text;
                }
                super.replace(fb, offset, length, (String)text, attrs);
            }
        }
    };

    public MaskFormatter(String mask) {
        this.mask = mask;
        if (mask.equalsIgnoreCase(MASK_PHONE_8) || mask.equalsIgnoreCase("## #####-####")) {
            this.isPhone = true;
        }
    }

    private int length(String m) {
        int length = 0;
        for (char c : m.toCharArray()) {
            if (c != '#') continue;
            ++length;
        }
        return length;
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        if (this.isPhone) {
            if (text == null || text.isEmpty() || text.length() < "## #####-####".length() - 1) {
                this.getFormattedTextField().setValue(null);
                return null;
            }
            return text.replace(".", "").replace("-", "").replace("/", "").replace("(", "").replace(")", "").replace(" ", "").trim();
        }
        if (text.isEmpty() || text.length() < this.mask.length()) {
            this.getFormattedTextField().setValue(null);
            return null;
        }
        Object str = "";
        for (int i = 0; i < this.mask.toCharArray().length; ++i) {
            if (this.mask.charAt(i) != '#') continue;
            str = (String)str + text.charAt(i);
        }
        return ((String)str).isEmpty() ? null : str;
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value == null || !value.getClass().isAssignableFrom(String.class)) {
            return "";
        }
        String str = value.toString().replace(".", "").replace("-", "").replace("/", "").replace("(", "").replace(")", "").replace(" ", "").trim();
        if (this.isPhone) {
            String maskPhone = MASK_PHONE_8;
            if (str.length() == this.length("## #####-####")) {
                maskPhone = "## #####-####";
            }
            if (str.length() < this.length(MASK_PHONE_8)) {
                return "";
            }
            return MaskFormatter.format(str, maskPhone);
        }
        if (str.length() == this.length(this.mask)) {
            return MaskFormatter.format(str, this.mask);
        }
        return "";
    }

    public static String format(String value, String mask) {
        Object str = "";
        int index = 0;
        for (char c : mask.toCharArray()) {
            if (c == '#') {
                str = (String)str + value.charAt(index);
                ++index;
                continue;
            }
            str = (String)str + c;
        }
        return str;
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        return this.df;
    }
}

