/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.text;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class JavaDocument
extends DefaultStyledDocument {
    private final String MATCHES = "(\\W)*(abstract|assert|boolean|break|byte|case|catch|char|class|const|continue|default|do|double|else|enum|extends|false|final|finally|float|for|goto|if|implements|import|instanceof|int|interface|long|native|new|null|package|private|protected|public|return|short|static|strictfp|super|switch|synchronized|this|throw|throws|transient|true|try|void|volatile|while)";
    private final StyleContext STYLE_CONTEXT = StyleContext.getDefaultStyleContext();
    private final AttributeSet ATTR_COMMENT = this.STYLE_CONTEXT.addAttribute(this.STYLE_CONTEXT.getEmptySet(), StyleConstants.Foreground, Color.GRAY);
    private final AttributeSet ATTR_STRING = this.STYLE_CONTEXT.addAttribute(this.STYLE_CONTEXT.getEmptySet(), StyleConstants.Foreground, Color.RED);
    private final AttributeSet ATTR_RESERVED_WORD = this.STYLE_CONTEXT.addAttribute(this.STYLE_CONTEXT.getEmptySet(), StyleConstants.Foreground, Color.BLUE);
    private final AttributeSet ATTR_WORD = this.STYLE_CONTEXT.addAttribute(this.STYLE_CONTEXT.getEmptySet(), StyleConstants.Foreground, Color.BLACK);

    private int findLastNonWordChar(String text, int index) {
        while (--index >= 0 && !String.valueOf(text.charAt(index)).matches("\\W")) {
        }
        return index;
    }

    private int findFirstNonWordChar(String text, int index) {
        while (index < text.length() && !String.valueOf(text.charAt(index)).matches("\\W")) {
            ++index;
        }
        return index++;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offset, str, a);
        String text = this.getText(0, this.getLength());
        int before = this.findLastNonWordChar(text, offset);
        if (before < 0) {
            before = 0;
        }
        int after = this.findFirstNonWordChar(text, offset + str.length());
        int wordL = before;
        for (int wordR = before; wordR <= after; ++wordR) {
            if (wordR != after && !String.valueOf(text.charAt(wordR)).matches("\\W")) continue;
            if (text.substring(wordL, wordR).matches("(\\W)*(abstract|assert|boolean|break|byte|case|catch|char|class|const|continue|default|do|double|else|enum|extends|false|final|finally|float|for|goto|if|implements|import|instanceof|int|interface|long|native|new|null|package|private|protected|public|return|short|static|strictfp|super|switch|synchronized|this|throw|throws|transient|true|try|void|volatile|while)")) {
                this.setCharacterAttributes(wordL + 1, wordR - wordL, this.ATTR_RESERVED_WORD, false);
            } else {
                this.setCharacterAttributes(wordL, wordR - wordL, this.ATTR_WORD, false);
            }
            wordL = wordR;
        }
        Pattern p = Pattern.compile("\\\"(.*?)\\\"");
        Matcher m = p.matcher(text);
        while (m.find()) {
            this.setCharacterAttributes(m.start(), m.end() - m.start(), this.ATTR_STRING, false);
        }
        p = Pattern.compile("\\'(.*?)\\'");
        m = p.matcher(text);
        while (m.find()) {
            this.setCharacterAttributes(m.start(), m.end() - m.start(), this.ATTR_STRING, false);
        }
        p = Pattern.compile("\\/*(.*?)\\*/");
        m = p.matcher(text);
        while (m.find()) {
            int start = text.substring(0, m.start()).lastIndexOf("/*");
            this.setCharacterAttributes(start, m.end() - start, this.ATTR_COMMENT, false);
        }
        p = Pattern.compile("\\//(.*?)\\n");
        m = p.matcher(text);
        while (m.find()) {
            this.setCharacterAttributes(m.start(), m.end() - m.start(), this.ATTR_COMMENT, false);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        int after;
        super.remove(offs, len);
        String text = this.getText(0, this.getLength());
        int before = this.findLastNonWordChar(text, offs);
        if (before < 0) {
            before = 0;
        }
        if (text.substring(before, after = this.findFirstNonWordChar(text, offs)).matches("(\\W)*(abstract|assert|boolean|break|byte|case|catch|char|class|const|continue|default|do|double|else|enum|extends|false|final|finally|float|for|goto|if|implements|import|instanceof|int|interface|long|native|new|null|package|private|protected|public|return|short|static|strictfp|super|switch|synchronized|this|throw|throws|transient|true|try|void|volatile|while)")) {
            this.setCharacterAttributes(before + 1, after - before, this.ATTR_RESERVED_WORD, false);
        } else {
            this.setCharacterAttributes(before, after - before, this.ATTR_WORD, false);
        }
        Pattern p = Pattern.compile("\\\"(.*?)\\\"");
        Matcher m = p.matcher(text);
        while (m.find()) {
            this.setCharacterAttributes(m.start(), m.end() - m.start(), this.ATTR_STRING, false);
        }
        p = Pattern.compile("\\'(.*?)\\'");
        m = p.matcher(text);
        while (m.find()) {
            this.setCharacterAttributes(m.start(), m.end() - m.start(), this.ATTR_STRING, false);
        }
        p = Pattern.compile("\\//(.*?)\\n");
        m = p.matcher(text);
        while (m.find()) {
            this.setCharacterAttributes(m.start(), m.end() - m.start(), this.ATTR_COMMENT, false);
        }
    }
}

