/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.text;

import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class DateFormatter
extends JFormattedTextField.AbstractFormatter {
    private int length = 8;
    private String mask = "##/##/####";
    private static final DateFormat DTF = new SimpleDateFormat("dd/MM/yyyy");
    private final DocumentFilter df = new DocumentFilter(){

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (offset == DateFormatter.this.mask.length() - 1) {
                DateFormatter.this.getFormattedTextField().transferFocus();
            }
            if (offset >= DateFormatter.this.mask.length()) {
                return;
            }
            if (!Character.isDigit(((String)text).charAt(length))) {
                return;
            }
            if (DateFormatter.this.mask.charAt(offset) != '#') {
                text = String.valueOf(DateFormatter.this.mask.charAt(offset)) + (String)text;
            }
            super.replace(fb, offset, length, (String)text, attrs);
        }
    };

    @Override
    public Object stringToValue(String text) throws ParseException {
        if (text.isEmpty() || text.length() < this.mask.length()) {
            this.getFormattedTextField().setValue(null);
            return null;
        }
        return new Date(DTF.parse(text).getTime());
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value instanceof String && value.toString().length() == this.length) {
            Object str = "";
            int index = 0;
            for (char c : this.mask.toCharArray()) {
                if (c == '#') {
                    str = (String)str + value.toString().charAt(index);
                    ++index;
                    continue;
                }
                str = (String)str + c;
            }
            return str;
        }
        return value == null ? "" : DTF.format(value);
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        return this.df;
    }

    public static DateFormat format() {
        return DTF;
    }
}

