/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.table;

import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;

public class TablePopupMenu
extends JPopupMenu {
    private JTable table;

    public TablePopupMenu(JTable table) {
        if (table != null) {
            this.table = table;
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.checkPopup(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.checkPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.checkPopup(e);
                }

                private void checkPopup(MouseEvent e) {
                    int row = TablePopupMenu.this.table.rowAtPoint(e.getPoint());
                    if (row >= 0 && row < TablePopupMenu.this.table.getRowCount()) {
                        TablePopupMenu.this.table.setRowSelectionInterval(row, row);
                    } else {
                        TablePopupMenu.this.table.clearSelection();
                    }
                    int rowindex = TablePopupMenu.this.table.getSelectedRow();
                    if (rowindex < 0) {
                        return;
                    }
                    if (e.getButton() == 3) {
                        TablePopupMenu.this.show(TablePopupMenu.this.table, e.getX(), e.getY());
                    }
                }
            });
            super.setBorder(new BevelBorder(0));
        }
    }

    public JMenuItem addMenuItem(String label, Icon icon, ActionListener action) {
        JMenuItem item = new JMenuItem(label, icon);
        this.add(item);
        item.setHorizontalTextPosition(4);
        item.addActionListener(action);
        return item;
    }
}

