/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.table;

import br.com.ctecinf.orm.Column;
import br.com.ctecinf.orm.Model;
import br.com.ctecinf.table.TableColumn;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class TableModel<T>
extends AbstractTableModel {
    protected List<TableColumn> columns;
    protected List data;

    public TableModel() {
        this.data = Collections.synchronizedList(new ArrayList());
        this.columns = Collections.synchronizedList(new ArrayList());
    }

    public TableModel(List<TableColumn> columns) {
        this.data = Collections.synchronizedList(new ArrayList());
        this.columns = Collections.synchronizedList(new ArrayList<TableColumn>(columns));
    }

    public TableModel(List<TableColumn> columns, List<T> data) {
        this.data = Collections.synchronizedList(new ArrayList<T>(data));
        this.columns = Collections.synchronizedList(new ArrayList<TableColumn>(columns));
    }

    public List<TableColumn> getColumns() {
        if (this.columns == null) {
            this.columns = Collections.synchronizedList(new ArrayList());
        }
        return this.columns;
    }

    public void setColumns(List<TableColumn> columns) {
        this.columns = columns == null ? Collections.synchronizedList(new ArrayList()) : Collections.synchronizedList(new ArrayList<TableColumn>(columns));
        this.fireTableStructureChanged();
    }

    public List<T> getData() {
        if (this.data == null) {
            this.data = Collections.synchronizedList(new ArrayList());
        }
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data == null ? Collections.synchronizedList(new ArrayList()) : Collections.synchronizedList(new ArrayList<T>(data));
        this.fireTableDataChanged();
    }

    public void addColumn(String name) {
        int index = this.getColumnCount();
        this.getColumns().add(new TableColumn(index, name));
    }

    public void addColumn(String name, String label) {
        int index = this.getColumnCount();
        this.getColumns().add(new TableColumn(index, name, label));
    }

    public void addColumn(String name, Class<?> type) {
        int index = this.getColumnCount();
        this.getColumns().add(new TableColumn(index, name, name, type));
    }

    public void addColumn(String name, String label, Class<?> type) {
        int index = this.getColumnCount();
        this.getColumns().add(new TableColumn(index, name, label, type));
    }

    public void addColumn(String name, String label, Class<?> type, int width) {
        int index = this.getColumnCount();
        this.getColumns().add(new TableColumn(index, name, label, type, width));
    }

    public void addRow(T row) {
        int index = this.getRowCount();
        this.getData().add(row);
        if (row instanceof Object[]) {
            Object[] obj = (Object[])row;
            for (int i = 0; i < obj.length; ++i) {
                if (obj[i] == null || obj[i].toString().length() <= this.getColumns().get(i).getWidth()) continue;
                this.getColumns().get(i).setWidth(obj[i].toString().length());
            }
        } else if (row instanceof Model) {
            try {
                for (Field field : row.getClass().getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Column.class) || !field.getAnnotation(Column.class).tableDisplay()) continue;
                    field.setAccessible(true);
                    Object vl = field.get(row);
                    TableColumn tableColumn = null;
                    if (vl == null || tableColumn == null || vl.toString().length() <= tableColumn.getWidth()) continue;
                    tableColumn.setWidth(vl.toString().length());
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
                // empty catch block
            }
        }
        this.fireTableRowsInserted(index, index);
    }

    public void updateRow(int rowIndex, T row) {
        if (this.getRowCount() > 0 && rowIndex >= 0 && rowIndex < this.getRowCount()) {
            this.getData().set(rowIndex, row);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    public void removeRow(int rowIndex) {
        if (this.getRowCount() > 0 && rowIndex >= 0 && rowIndex < this.getRowCount() && this.getData().remove(this.getData().remove(rowIndex))) {
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    public void removeAllRows() {
        if (this.getRowCount() > 0) {
            int size = this.getRowCount() - 1;
            this.getData().clear();
            this.fireTableRowsDeleted(0, size);
        }
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns == null ? 0 : this.columns.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getColumns() == null ? Object.class : this.getColumns().get(columnIndex).getType();
    }

    @Override
    public String getColumnName(int column) {
        return this.getColumns() == null ? "" : this.getColumns().get(column).getLabel();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.getRowCount() > 0 && rowIndex >= 0 && rowIndex < this.getRowCount()) {
            T obj = this.getData().get(rowIndex);
            if (obj instanceof Object[]) {
                Object[] row = (Object[])obj;
                return row[columnIndex];
            }
            if (obj instanceof Model) {
                if (columnIndex == -1) {
                    return obj;
                }
                try {
                    Field field;
                    if (this.getColumns().get(columnIndex) != null && (field = columnIndex == 0 ? obj.getClass().getSuperclass().getDeclaredField(this.getColumns().get(columnIndex).getName()) : obj.getClass().getDeclaredField(this.getColumns().get(columnIndex).getName())) != null) {
                        field.setAccessible(true);
                        return field.get(obj);
                    }
                    return null;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.getRowCount() > 0 && rowIndex >= 0 && rowIndex < this.getRowCount()) {
            T obj = this.getData().get(rowIndex);
            if (obj == null) {
                return;
            }
            if (obj instanceof Object[]) {
                ((Object[])obj)[columnIndex] = aValue;
            } else if (obj instanceof Model) {
                try {
                    Field field = obj.getClass().getDeclaredField(this.getColumns().get(columnIndex).getName());
                    field.setAccessible(true);
                    field.set(obj, aValue);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                    // empty catch block
                }
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }
}

