/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.table;

import br.com.ctecinf.text.DateFormatter;
import br.com.ctecinf.text.NumberFormatter;
import br.com.ctecinf.text.TimeFormatter;
import br.com.ctecinf.text.TimestampFormatter;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultFormatterFactory;

public class TableCellRendererImpl
implements TableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JFormattedTextField c = new JFormattedTextField();
        if (row % 2 == 0) {
            c.setBackground(MetalLookAndFeel.getWhite());
        } else {
            c.setBackground(MetalLookAndFeel.getPrimaryControl());
        }
        if (isSelected) {
            c.setBackground(MetalLookAndFeel.getFocusColor());
        }
        c.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        if (value != null) {
            if (value.getClass().isAssignableFrom(Boolean.class)) {
                value = (Boolean)value != false ? "Sim" : "N\u00e3o";
            } else if (value.getClass().isAssignableFrom(Date.class) || value.getClass().isAssignableFrom(java.sql.Date.class)) {
                c.setFormatterFactory(new DefaultFormatterFactory(new DateFormatter()));
            } else if (value.getClass().isAssignableFrom(Time.class)) {
                c.setFormatterFactory(new DefaultFormatterFactory(new TimeFormatter()));
            } else if (value.getClass().isAssignableFrom(Timestamp.class)) {
                c.setFormatterFactory(new DefaultFormatterFactory(new TimestampFormatter()));
            } else if (value.getClass().isAssignableFrom(Long.class) || value.getClass().isAssignableFrom(Long.TYPE)) {
                c.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(0)));
            } else if (value.getClass().isAssignableFrom(Integer.class) || value.getClass().isAssignableFrom(Integer.TYPE)) {
                c.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(0)));
            } else if (value.getClass().isAssignableFrom(Double.class) || value.getClass().isAssignableFrom(Double.TYPE)) {
                c.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(2)));
            } else if (value.getClass().isAssignableFrom(BigDecimal.class)) {
                c.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(2)));
            } else if (value.getClass().isAssignableFrom(Float.class) || value.getClass().isAssignableFrom(Float.TYPE)) {
                c.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(2)));
            }
        }
        c.setValue(value);
        return c;
    }
}

