/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.table;

import br.com.ctecinf.table.TableCellRendererImpl;
import br.com.ctecinf.table.TableModel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class Table
extends JTable {
    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public TableModel getModel() {
        return (TableModel)super.getModel();
    }

    public Table() {
        super(new TableModel());
        this.setAutoResizeMode(0);
        this.setSelectionMode(0);
        this.setRowHeight(20);
    }

    public Table(TableModel tableModel) {
        super(new TableModel());
        this.setAutoResizeMode(0);
        this.setSelectionMode(0);
        this.setRowHeight(20);
        this.setModel(tableModel);
    }

    public final void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 1) {
                    for (int i = 0; i < Table.this.getColumnCount(); ++i) {
                        TableColumn tableColumn = Table.this.getColumn(Table.this.getModel().getColumnName(i));
                        tableColumn.setPreferredWidth(Table.this.getFontMetrics(Table.this.getFont()).stringWidth(((Object)Table.this.getModel().getColumns().get(i)).toString()));
                        if (tableColumn.getCellRenderer() instanceof TableCellRendererImpl) continue;
                        tableColumn.setCellRenderer(new TableCellRendererImpl());
                    }
                }
            }
        });
        this.setRowSorter(new TableRowSorter<TableModel>(this.getModel()));
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumn(this.getModel().getColumnName(i));
            tableColumn.setCellRenderer(new TableCellRendererImpl());
            tableColumn.setPreferredWidth(this.getFontMetrics(this.getFont()).stringWidth(((Object)this.getModel().getColumns().get(i)).toString()));
        }
    }

    public void addRow(Object row) {
        this.getModel().addRow(row);
    }

    public void updateRow(int rowIndex, Object row) {
        this.getModel().updateRow(rowIndex, row);
    }

    public void removeRow(int rowIndex) {
        this.getModel().removeRow(rowIndex);
    }

    public void removeAllRows() {
        this.getModel().removeAllRows();
    }

    public void removeSelectedRow() throws Exception {
        if (this.getSelectedRow() == -1) {
            throw new Exception("Nenhum registro selecionado.");
        }
        int index = this.getRowSorter().convertRowIndexToModel(this.getSelectedRow());
        this.removeRow(index);
    }

    public int getColumnWidth(int columnIndex) {
        return this.getModel().getColumns().get(columnIndex).getWidth();
    }
}

