/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.swing;

import br.com.ctecinf.event.SelectEvent;
import br.com.ctecinf.event.SelectListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeFile
extends JTree {
    private SelectListener listener;

    public TreeFile(String path) {
        this(new File(path));
    }

    public TreeFile(File root) {
        this.setModel(new Model(root));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && TreeFile.this.listener != null) {
                    TreeFile.this.listener.onSelected(new SelectEvent(TreeFile.this, e.getID(), TreeFile.this.getSelectedFile()));
                }
            }
        });
    }

    public void addSelectListener(SelectListener sl) {
        this.listener = sl;
    }

    protected File getSelectedFile() {
        return (File)this.getSelectionPath().getLastPathComponent();
    }

    public void expandAll() {
        this.expandAll(0, this.getRowCount());
    }

    private void expandAll(int startingIndex, int rowCount) {
        for (int i = startingIndex; i < rowCount; ++i) {
            this.expandRow(i);
        }
        if (this.getRowCount() != rowCount) {
            this.expandAll(rowCount, this.getRowCount());
        }
    }

    protected class Model
    implements TreeModel,
    Serializable {
        protected File root;

        public Model(String path) {
            this(new File(path));
        }

        public Model(File root) {
            this.root = root;
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public boolean isLeaf(Object node) {
            return ((File)node).isFile();
        }

        @Override
        public int getChildCount(Object parent) {
            String[] children = ((File)parent).list();
            if (children == null) {
                return 0;
            }
            return children.length;
        }

        @Override
        public Object getChild(Object parent, int index) {
            String[] children = ((File)parent).list();
            if (children == null || index >= children.length) {
                return null;
            }
            return new File((File)parent, children[index]){

                @Override
                public String toString() {
                    return this.getName();
                }
            };
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            String[] children = ((File)parent).list();
            if (children == null) {
                return -1;
            }
            String childname = ((File)child).getName();
            for (int i = 0; i < children.length; ++i) {
                if (!childname.equals(children[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newvalue) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener listener) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }
    }
}

