/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.swing;

import br.com.ctecinf.Database;
import br.com.ctecinf.PDF;
import br.com.ctecinf.swing.Image;
import br.com.ctecinf.swing.OptionPane;
import br.com.ctecinf.swing.PleaseWaitDialog;
import br.com.ctecinf.table.Table;
import br.com.ctecinf.table.TableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class RelatorioPanel
extends JPanel {
    private final String title;
    private Table table;
    private JToolBar panelButtons;

    public RelatorioPanel(String query) {
        this(null, query);
    }

    public RelatorioPanel(String title, String query) {
        this.title = title;
        this.initUI(query);
    }

    public Table getTable() {
        return this.table;
    }

    private void initUI(String query) {
        this.setLayout(new BorderLayout());
        TableModel<Object[]> model = new TableModel<Object[]>();
        try (Connection conn = Database.openConnection();
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery(query);){
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                model.addColumn(rs.getMetaData().getColumnLabel(i + 1).replace("_", " "), Database.type2Class(rs.getMetaData().getColumnType(i + 1)));
            }
            while (rs.next()) {
                Object[] row = new Object[rs.getMetaData().getColumnCount()];
                for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                    row[i] = rs.getObject(rs.getMetaData().getColumnLabel(i + 1));
                }
                model.addRow(row);
            }
        }
        catch (Exception ex) {
            OptionPane.error(ex);
        }
        this.table = new Table(model);
        this.panelButtons = new JToolBar();
        this.panelButtons.setFloatable(false);
        this.panelButtons.setLayout(new FlowLayout(2));
        this.addAction("Imprimir", Image.parse("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"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new PleaseWaitDialog<File>(){

                    @Override
                    public File exec() throws Exception {
                        PDF pdf = new PDF();
                        return pdf.parse(RelatorioPanel.this.title, RelatorioPanel.this.table);
                    }

                    @Override
                    public void end(File result) {
                        try {
                            Desktop.getDesktop().open(result);
                            result.deleteOnExit();
                        }
                        catch (Exception ex) {
                            OptionPane.error(ex);
                        }
                    }
                }.start();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)this.panelButtons, "North");
        this.add((Component)panel, "Center");
    }

    public void addAction(String label, ImageIcon icon, ActionListener action) {
        JButton button = new JButton(label, icon);
        button.addActionListener(action);
        this.panelButtons.add(button);
    }
}

