/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.swing;

import br.com.ctecinf.swing.OptionPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public abstract class PleaseWaitDialog<T>
extends JDialog {
    private JProgressBar progressBar;

    public PleaseWaitDialog() {
        this((Frame)null);
    }

    public PleaseWaitDialog(Frame owner) {
        super(owner);
        this.init();
    }

    private void init() {
        if (this.getOwner() != null && !this.getOwner().isVisible()) {
            this.getOwner().setVisible(true);
        }
        try {
            this.progressBar = new JProgressBar();
            this.progressBar.setPreferredSize(new Dimension(210, 20));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTitle("Aguarde...");
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.add((Component)new JPanel(), "North");
        panel.add((Component)new JPanel(), "South");
        panel.add((Component)new JPanel(), "East");
        panel.add((Component)new JPanel(), "West");
        panel.add((Component)this.progressBar, "Center");
        this.add(panel);
        this.pack();
        this.setAlwaysOnTop(true);
        this.setAutoRequestFocus(true);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void title(String title) {
        this.setTitle(title);
    }

    public void progress(int perc) {
        try {
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setStringPainted(true);
            }
            this.progressBar.setValue(perc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        new Thread(() -> {
            try {
                this.progressBar.setIndeterminate(true);
                T obj = this.exec();
                this.progress(100);
                this.dispose();
                this.end(obj);
            }
            catch (Exception ex) {
                this.progress(100);
                this.dispose();
                OptionPane.error(ex);
            }
        }).start();
    }

    public abstract T exec() throws Exception;

    public abstract void end(T var1) throws Exception;

    static {
        PleaseWaitDialog.setDefaultLookAndFeelDecorated(true);
    }
}

