/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.swing;

import br.com.ctecinf.Log;
import br.com.ctecinf.Utils;
import br.com.ctecinf.swing.Image;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.DefaultFormatterFactory;

public class OptionPane {
    public static boolean confirm(Object message) {
        return OptionPane.confirm(null, message, "Confirmar");
    }

    public static boolean confirm(Component parent, Object message) {
        return OptionPane.confirm(parent, message, "Confirmar");
    }

    public static boolean confirm(Component parent, Object message, String title) {
        Object[] buttons = new String[]{"Sim", "N\u00e3o"};
        return JOptionPane.showOptionDialog(parent, message, title, 0, -1, new ImageIcon(), buttons, buttons[0]) == 0;
    }

    public static void success(String message) {
        OptionPane.success(null, message, "Sucesso");
    }

    public static void success(Component parent, String message) {
        OptionPane.success(parent, message, "Sucesso");
    }

    public static void success(Component parent, String message, String title) {
        JOptionPane.showMessageDialog(parent, message, title, 3, Image.parse("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"));
    }

    public static void alert(String message) {
        OptionPane.alert(null, message, "Alerta");
    }

    public static void alert(Component component, String message) {
        OptionPane.alert(component, message, "Alerta");
    }

    public static void alert(Component component, String message, String title) {
        JOptionPane.showMessageDialog(component, message, title, 2);
    }

    public static void info(Object message) {
        OptionPane.info(null, message, "Informa\u00e7\u00e3o");
    }

    public static void info(Component component, Object message) {
        OptionPane.info(component, message, "Informa\u00e7\u00e3o");
    }

    public static void info(Component component, Object message, String title) {
        JOptionPane.showMessageDialog(component, message, title, 1);
    }

    public static void error(Object message) {
        OptionPane.error(null, message, "Erro");
    }

    public static void error(Component component, Object message) {
        OptionPane.error(component, message, "Erro");
    }

    public static void error(Component component, Object message, String title) {
        if (message instanceof Exception) {
            String msg = ((Exception)message).getLocalizedMessage() + "\n\n\n";
            for (StackTraceElement stack : ((Exception)message).getStackTrace()) {
                if (!stack.getClassName().contains("ctecinf") || stack.getClassName().contains("$")) continue;
                msg = msg + stack.getClassName() + " (" + stack.getLineNumber() + "): " + stack.getMethodName();
                break;
            }
            JOptionPane.showMessageDialog(component, msg, title, 0);
        } else {
            JOptionPane.showMessageDialog(component, message, title, 0);
        }
        Log.create(message);
    }

    public static void show(Component component) {
        OptionPane.show(component, 800, 600);
    }

    public static void show(Component component, int width, int height) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(width, height));
        panel.add(new JScrollPane(component));
        JOptionPane.showMessageDialog(null, panel, "", -1);
    }

    public static File chooseFile(FileNameExtensionFilter ... filter) {
        return OptionPane.chooseFile("Selecione um arquivo", filter);
    }

    public static File chooseFile(String title, FileNameExtensionFilter ... filter) {
        JFileChooser chooser = new JFileChooser(new File(System.getProperty("user.home")));
        chooser.setDialogTitle(title);
        chooser.setApproveButtonText("Selecionar");
        chooser.setFileSelectionMode(0);
        if (filter != null) {
            for (FileNameExtensionFilter f : filter) {
                chooser.setFileFilter(f);
            }
        }
        if (chooser.showOpenDialog(null) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static File chooseDirectory() {
        return OptionPane.chooseDirectory("Selecione um diret\u00f3rio");
    }

    public static File chooseDirectory(String title) {
        JFileChooser chooser = new JFileChooser(new File(System.getProperty("user.home")));
        chooser.setDialogTitle(title);
        chooser.setApproveButtonText("Selecionar");
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(null) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static void print(Printable printable) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(printable);
        if (pj.printDialog()) {
            try {
                pj.print();
            }
            catch (PrinterException ex) {
                OptionPane.error(ex);
            }
        }
    }

    public static final <T> T input(String title, T value, JFormattedTextField.AbstractFormatter formatter) {
        return OptionPane.input(null, title, value, formatter);
    }

    public static final <T> T input(Component parent, String title, T value, JFormattedTextField.AbstractFormatter formatter) {
        final JFormattedTextField input = new JFormattedTextField();
        input.setFont(input.getFont().deriveFont(18.0f));
        Object[] buttons = new String[]{"Confirmar", "Cancelar"};
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, title, 0, 0, input.getFont().deriveFont(1)), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        panel.add((Component)input, gbc);
        final JOptionPane pane = new JOptionPane(panel, -1, 0, null, buttons, buttons[0]);
        if (formatter != null) {
            input.setFormatterFactory(new DefaultFormatterFactory(formatter));
        }
        input.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        input.selectAll();
                    }
                });
            }
        });
        input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    pane.setValue("Confirmar");
                }
            }
        });
        input.setColumns(30);
        input.setValue(value);
        JDialog dialog = pane.createDialog(parent, "");
        dialog.setAlwaysOnTop(true);
        dialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                input.requestFocus();
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        dialog.dispose();
        if (pane.getValue() != null && pane.getValue().equals("Confirmar")) {
            return (T)(formatter != null ? input.getValue() : (input.getText().isEmpty() ? null : input.getText()));
        }
        return null;
    }

    public static final <T> T choice(String title, Object[] choices) {
        return OptionPane.choice(null, title, choices);
    }

    public static final <T> T choice(Component parent, String title, Object[] choices) {
        if (choices.length == 0) {
            return null;
        }
        final JList<Object> choice = new JList<Object>(choices);
        choice.setSelectionMode(0);
        choice.setVisibleRowCount(8);
        choice.setFont(choice.getFont().deriveFont(0, 18.0f));
        choice.setSelectedIndex(0);
        JLabel label = new JLabel(title);
        label.setFont(label.getFont().deriveFont(1, 18.0f));
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.add((Component)label, "North");
        panel.add((Component)new JScrollPane(choice), "Center");
        Object[] buttons = new String[]{"Confirmar", "Cancelar"};
        final JOptionPane pane = new JOptionPane(panel, -1, 0, null, buttons, buttons[0]);
        choice.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    pane.setValue("Confirmar");
                }
            }
        });
        JDialog dialog = pane.createDialog(parent, "");
        dialog.setAlwaysOnTop(true);
        dialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                choice.requestFocus();
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        dialog.dispose();
        if (pane.getValue() != null && pane.getValue().equals("Confirmar")) {
            return (T)(choice.getSelectedValue() == null ? null : choice.getSelectedValue());
        }
        return null;
    }

    public static Calendar choiceMonth(int yearInterval) {
        return OptionPane.choiceMonth(null, yearInterval);
    }

    public static Calendar choiceMonth(Component parent, int yearInterval) {
        int i;
        Calendar dt = Utils.dateFromServer();
        String[] months = new String[12];
        Locale locale = new Locale("pt", "BR");
        int mNow = dt.get(2);
        dt.set(5, 1);
        for (int i2 = 0; i2 < months.length; ++i2) {
            dt.set(2, i2);
            months[i2] = dt.getDisplayName(2, 2, locale);
        }
        final JComboBox<String> inMonths = new JComboBox<String>(months);
        inMonths.setSelectedIndex(mNow);
        Integer[] years = new Integer[yearInterval * 2];
        int year = dt.get(1);
        int index = 0;
        for (i = dt.get(1) - yearInterval; i < dt.get(1); ++i) {
            years[index] = i;
            ++index;
        }
        for (i = dt.get(1); i < dt.get(1) + yearInterval; ++i) {
            years[index] = i;
            ++index;
        }
        JComboBox<Integer> inYears = new JComboBox<Integer>(years);
        inYears.setSelectedItem(year);
        Object[] buttons = new String[]{"Confirmar", "Cancelar"};
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "Selecione o m\u00eas e ano", 0, 0, panel.getFont().deriveFont(1)), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        panel.add((Component)new JLabel("M\u00eas:"), gbc);
        gbc.gridx = 2;
        panel.add(inMonths, gbc);
        gbc.gridx = 3;
        panel.add((Component)new JLabel("Ano:"), gbc);
        gbc.gridx = 4;
        panel.add(inYears, gbc);
        JOptionPane pane = new JOptionPane(panel, -1, 0, null, buttons, buttons[0]);
        JDialog dialog = pane.createDialog(parent, "Selecione o m\u00eas");
        dialog.setAlwaysOnTop(true);
        dialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                inMonths.requestFocus();
            }
        });
        dialog.setVisible(true);
        dialog.dispose();
        if (pane.getValue() != null && pane.getValue().equals("Confirmar")) {
            dt.set(2, inMonths.getSelectedIndex());
            dt.set(1, (Integer)inYears.getSelectedItem());
            return dt;
        }
        return null;
    }
}

