/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.swing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;

public class ListModel<T>
extends AbstractListModel<T>
implements Serializable {
    protected List<T> data;

    public ListModel() {
        this.data = Collections.synchronizedList(new ArrayList());
    }

    public ListModel(T[] data) {
        this.data = Collections.synchronizedList(new ArrayList<T>(Arrays.asList(data)));
    }

    public ListModel(List<T> data) {
        this.data = Collections.synchronizedList(new ArrayList<T>(data));
    }

    public List<T> getData() {
        if (this.data == null) {
            this.data = Collections.synchronizedList(new ArrayList());
        }
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data == null ? Collections.synchronizedList(new ArrayList()) : Collections.synchronizedList(new ArrayList<T>(data));
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void add(T row) {
        if (this.getData().indexOf(row) == -1) {
            this.getData().add(row);
            this.fireIntervalAdded(this, this.getData().size() - 1, this.getData().size() - 1);
        }
    }

    public void update(int index, T row) {
        if (!this.getData().isEmpty() && index >= 0 && index < this.getData().size()) {
            this.getData().set(index, row);
            this.fireContentsChanged(this, index, index);
        }
    }

    public void remove(T obj) {
        int index = this.getData().indexOf(obj);
        if (index > -1) {
            this.getData().remove(obj);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public void remove(int index) {
        if (!this.getData().isEmpty() && index >= 0 && index < this.getData().size() && this.getData().remove(this.getData().remove(index))) {
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public void removeAll() {
        if (!this.getData().isEmpty()) {
            int size = this.getData().size() - 1;
            this.getData().clear();
            this.fireIntervalRemoved(this, 0, size);
        }
    }

    @Override
    public int getSize() {
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public T getElementAt(int index) {
        if (index > -1 && index < this.getSize()) {
            return this.data.get(index);
        }
        return null;
    }
}

