/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.swing;

import br.com.ctecinf.table.Table;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

public class GridPanel
extends JPanel {
    private int numColumns = 1;
    private int row = 1;

    public GridPanel() {
        this(1);
    }

    public GridPanel(int numColumns) {
        super(new GridBagLayout());
        this.numColumns = numColumns;
        this.row = 0;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int getRow() {
        return this.row;
    }

    public void newRow() {
        ++this.row;
    }

    public JPanel add(JComponent component, int column) {
        return this.add(component, column, 1, !component.getClass().isAssignableFrom(JComboBox.class) && !component.getClass().isAssignableFrom(JCheckBox.class));
    }

    public JPanel add(JComponent component, int column, boolean fill) {
        return this.add(component, column, 1, fill);
    }

    public JPanel add(JComponent component, int column, int colsNumOccupped) {
        return this.add(component, column, colsNumOccupped, !component.getClass().isAssignableFrom(JComboBox.class) && !component.getClass().isAssignableFrom(JCheckBox.class));
    }

    public JPanel add(JComponent component, int column, int colsNumOccupped, boolean fill) {
        return this.add(component, column, this.row, colsNumOccupped, 1.0 / (double)this.numColumns, fill);
    }

    public JPanel add(JComponent component, int gridx, int gridy, int gridwidth, double weightX, boolean fill) {
        return GridPanel.addComponent(this, component, gridx, gridy, gridwidth, weightX, fill);
    }

    public void end() {
        this.newRow();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.fill = 1;
        gbc.gridy = this.row;
        gbc.gridx = 1;
        gbc.gridwidth = this.numColumns;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)new JPanel(), gbc);
    }

    public void setEnterForward(boolean b) {
        if (b) {
            Set<AWTKeyStroke> forwardKeys = this.getFocusTraversalKeys(0);
            HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(forwardKeys);
            newForwardKeys.add(KeyStroke.getKeyStroke(10, 0));
            this.setFocusTraversalKeys(0, newForwardKeys);
        }
    }

    public static JPanel addComponent(JPanel panel, JComponent component, int gridx, int gridy, int gridwidth) {
        return GridPanel.addComponent(panel, component, gridx, gridy, gridwidth, 1.0, true);
    }

    public static final JPanel addComponent(JPanel panel, JComponent component, int gridx, int gridy, int gridwidth, boolean fill) {
        return GridPanel.addComponent(panel, component, gridx, gridy, gridwidth, 1.0, fill);
    }

    public static final JPanel addComponent(JPanel panel, JComponent component, int gridx, int gridy, int gridwidth, double weightX, boolean fill) {
        if (panel == null) {
            panel = new JPanel(new GridBagLayout());
        }
        if (component == null) {
            return panel;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.fill = fill ? 2 : 0;
        gbc.gridy = gridy;
        gbc.gridx = gridx;
        gbc.gridwidth = gridwidth;
        gbc.weightx = weightX;
        if (component.getClass().isAssignableFrom(Table.class) || component.getClass().isAssignableFrom(JTable.class) || component.getClass().isAssignableFrom(JList.class) || component.getClass().isAssignableFrom(JTextArea.class) || component.getClass().isAssignableFrom(JEditorPane.class) || component.getClass().isAssignableFrom(JTextPane.class)) {
            JScrollPane scroll = component.getClass().isAssignableFrom(Table.class) || component.getClass().isAssignableFrom(JTable.class) || component.getClass().isAssignableFrom(JList.class) ? new JScrollPane(component){
                private final Dimension d = new Dimension(300, 180);

                @Override
                public Dimension getPreferredSize() {
                    return this.d;
                }
            } : new JScrollPane(component);
            if (component.getBorder().getClass().isAssignableFrom(TitledBorder.class)) {
                scroll.setBorder(component.getBorder());
                component.setBorder(BorderFactory.createEtchedBorder());
            }
            panel.add((Component)scroll, gbc);
        } else {
            panel.add((Component)component, gbc);
        }
        return panel;
    }
}

