/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.swing;

import br.com.ctecinf.Database;
import br.com.ctecinf.Utils;
import br.com.ctecinf.autocomplete.AutoCompleteField;
import br.com.ctecinf.combobox.ComboBox;
import br.com.ctecinf.text.DateFormatter;
import br.com.ctecinf.text.MaskFormatter;
import br.com.ctecinf.text.NumberFormatter;
import br.com.ctecinf.text.PasswordFormatter;
import br.com.ctecinf.text.TimeFormatter;
import br.com.ctecinf.text.TimestampFormatter;
import br.com.ctecinf.text.UpperCaseFormatter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class Fields {
    private final Map<String, JComponent> components = new HashMap<String, JComponent>();

    public Map<String, JComponent> getComponents() {
        return this.components;
    }

    public JComponent put(JComponent component) {
        if (component.getName() != null && !component.getName().isEmpty()) {
            this.components.put(component.getName(), component);
        }
        return component;
    }

    public JFormattedTextField create(String name, Object value, String Mask) {
        JFormattedTextField field = new JFormattedTextField(new MaskFormatter(Mask));
        field.setValue(value);
        field.setName(name);
        this.components.put(name, field);
        return field;
    }

    public ComboBox create(String name, Object[] values) {
        return this.create(name, null, values);
    }

    public ComboBox create(String name, Object selected, Object[] values) {
        ComboBox<Object> combo = new ComboBox<Object>((T[])values);
        combo.setName(name);
        combo.setSelectedItem(selected);
        combo.setMaximumSize(new Dimension(300, 15));
        this.components.put(name, combo);
        return combo;
    }

    public JFormattedTextField create(String name) {
        return (JFormattedTextField)this.create(name, null, 12);
    }

    public <T extends JComponent> T create(String name, Object value) {
        return this.create(name, value, value == null ? 12 : Database.class2Type(value.getClass()));
    }

    public <T extends JComponent> T create(String name, Object value, Class type) {
        return this.create(name, value, Database.class2Type(type));
    }

    public <T extends JComponent> T create(String name, int sqlType) {
        return this.create(name, null, sqlType);
    }

    public <T extends JComponent> T create(String name, Object value, int sqlType) {
        JComponent field;
        if (name.toLowerCase().contains("fone") || name.toLowerCase().contains("celular")) {
            field = new JFormattedTextField(new MaskFormatter("## #####-####"));
            ((JFormattedTextField)field).setValue(value);
        } else if (name.toLowerCase().contains("senha")) {
            field = new JFormattedTextField(new PasswordFormatter());
            ((JFormattedTextField)field).setValue(value);
        } else if (name.toLowerCase().contains("email")) {
            field = new JFormattedTextField();
            ((JFormattedTextField)field).setValue(value);
        } else {
            switch (sqlType) {
                case -5: 
                case 4: {
                    field = new JFormattedTextField(new NumberFormatter(0));
                    ((JFormattedTextField)field).setValue(value);
                    break;
                }
                case 3: 
                case 6: 
                case 8: {
                    field = new JFormattedTextField(new NumberFormatter(2));
                    ((JFormattedTextField)field).setValue(value);
                    break;
                }
                case -1: 
                case 2004: {
                    field = new JTextArea();
                    ((JTextArea)field).setRows(5);
                    ((JTextArea)field).setText(value == null ? "" : value.toString());
                    break;
                }
                case -7: 
                case -6: 
                case 5: 
                case 16: {
                    field = new JCheckBox();
                    if (value == null) break;
                    if (value.toString().equalsIgnoreCase("1") || value.toString().equalsIgnoreCase("true") || value.toString().equalsIgnoreCase("yes") || value.toString().equalsIgnoreCase("sim") || value.toString().equalsIgnoreCase("s")) {
                        value = true;
                    }
                    ((JCheckBox)field).setSelected(Boolean.valueOf(value.toString()));
                    break;
                }
                case 91: {
                    field = new JFormattedTextField(new DateFormatter());
                    ((JFormattedTextField)field).setValue(value);
                    break;
                }
                case 92: {
                    field = new JFormattedTextField(new TimeFormatter());
                    ((JFormattedTextField)field).setValue(value);
                    break;
                }
                case 93: {
                    field = new JFormattedTextField(new TimestampFormatter());
                    ((JFormattedTextField)field).setValue(value);
                    break;
                }
                default: {
                    field = new JFormattedTextField(new UpperCaseFormatter());
                    ((JFormattedTextField)field).setValue(value);
                }
            }
        }
        field.setName(name);
        this.components.put(name, field);
        return (T)field;
    }

    public void setLabel(String fieldName, String label, boolean notNull) {
        Object c = this.getComponent(fieldName);
        if (c != null) {
            if (c instanceof JCheckBox) {
                ((JCheckBox)c).setText(label);
                if (notNull) {
                    ((JComponent)c).setForeground(Color.RED);
                }
            } else {
                ((JComponent)c).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, " " + (notNull ? "* " : "") + label + " ", 0, 0, ((Component)this.getComponent(fieldName)).getFont().deriveFont(1), notNull ? Color.RED : Color.BLACK), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
            }
        }
    }

    public <T extends JComponent> T getComponent(String name) {
        JComponent c = null;
        if (this.components.containsKey(name)) {
            c = this.components.get(name);
        } else if (this.components.containsKey(name.toUpperCase())) {
            c = this.components.get(name.toUpperCase());
        } else if (this.components.containsKey(name.toLowerCase())) {
            c = this.components.get(name.toLowerCase());
        }
        return (T)c;
    }

    public void setValue(String name, Object value) {
        Object c = this.getComponent(name);
        if (c != null) {
            if (c instanceof AutoCompleteField) {
                AutoCompleteField field = (AutoCompleteField)c;
                field.setValue(value);
            } else if (c instanceof ComboBox) {
                ComboBox field = (ComboBox)c;
                field.setSelectedItem(value);
            } else if (c instanceof JComboBox) {
                JComboBox field = (JComboBox)c;
                field.setSelectedItem(value);
            } else if (c instanceof JCheckBox) {
                JCheckBox field = (JCheckBox)c;
                field.setSelected(value == null ? false : (Boolean)value);
            } else if (c instanceof JTextArea) {
                JTextArea field = (JTextArea)c;
                field.setText(value == null ? "" : value.toString());
            } else if (c instanceof JTextPane) {
                JTextPane field = (JTextPane)c;
                field.setText(value == null ? "" : value.toString());
            } else if (c instanceof JEditorPane) {
                JEditorPane field = (JEditorPane)c;
                field.setText(value == null ? "" : value.toString());
            } else if (c instanceof JFormattedTextField) {
                JFormattedTextField field = (JFormattedTextField)c;
                if (field.getFormatter() == null) {
                    field.setValue(value);
                } else if (!field.getName().toLowerCase().contains("senha") && !field.getFormatter().getClass().isAssignableFrom(PasswordFormatter.class)) {
                    field.setValue(value);
                }
            } else if (c instanceof JTextField) {
                JTextField field = (JTextField)c;
                field.setText(value == null ? "" : value.toString());
            }
        }
    }

    public Object getValue(String name) {
        Object c = this.getComponent(name);
        if (c != null) {
            if (c instanceof AutoCompleteField) {
                AutoCompleteField field = (AutoCompleteField)c;
                return field.getValue();
            }
            if (c instanceof ComboBox) {
                ComboBox field = (ComboBox)c;
                return field.getSelectedItem();
            }
            if (c instanceof JComboBox) {
                JComboBox field = (JComboBox)c;
                return field.getSelectedItem();
            }
            if (c instanceof JCheckBox) {
                JCheckBox field = (JCheckBox)c;
                return field.isSelected();
            }
            if (c instanceof JTextArea) {
                JTextArea field = (JTextArea)c;
                return field.getText();
            }
            if (c instanceof JTextPane) {
                JTextPane field = (JTextPane)c;
                return field.getText();
            }
            if (c instanceof JEditorPane) {
                JEditorPane field = (JEditorPane)c;
                return field.getText();
            }
            if (c instanceof JFormattedTextField) {
                JFormattedTextField field = (JFormattedTextField)c;
                if (!field.getText().isEmpty() && (field.getName().toLowerCase().contains("senha") || field.getFormatter().getClass().isAssignableFrom(PasswordFormatter.class))) {
                    try {
                        return Utils.md5(field.getValue().toString());
                    }
                    catch (NoSuchAlgorithmException ex) {
                        return null;
                    }
                }
                return field.getValue();
            }
            if (c instanceof JPasswordField) {
                JPasswordField field = (JPasswordField)c;
                if (field.getPassword().length > 0) {
                    try {
                        return Utils.md5(new String(field.getPassword()));
                    }
                    catch (NoSuchAlgorithmException ex) {
                        return null;
                    }
                }
            } else if (c instanceof JTextField) {
                JTextField field = (JTextField)c;
                return field.getText();
            }
        }
        return null;
    }

    public Map<String, Object> getValues() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String name : this.components.keySet()) {
            values.put(name, this.getValue(name));
        }
        return values;
    }

    public void cleanValues() {
        for (String name : this.components.keySet()) {
            Object c = this.getComponent(name);
            if (c instanceof ComboBox) {
                ((ComboBox)c).setSelectedIndex(0);
                this.setValue(name, ((ComboBox)c).getSelectedItem());
                continue;
            }
            if (c instanceof JComboBox) {
                ((JComboBox)c).setSelectedIndex(0);
                this.setValue(name, ((JComboBox)c).getSelectedItem());
                continue;
            }
            this.setValue(name, null);
        }
    }
}

