/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.qrcode;

import br.com.ctecinf.qrcode.BarcodeFormat;
import br.com.ctecinf.qrcode.BitMatrix;
import br.com.ctecinf.qrcode.ByteMatrix;
import br.com.ctecinf.qrcode.EncodeHintType;
import br.com.ctecinf.qrcode.ErrorCorrectionLevel;
import br.com.ctecinf.qrcode.Mode;
import br.com.ctecinf.qrcode.QRCodeWriter;
import br.com.ctecinf.qrcode.Version;
import br.com.ctecinf.qrcode.WriterException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class QRCode {
    public static final int NUM_MASK_PATTERNS = 8;
    private Mode mode;
    private ErrorCorrectionLevel ecLevel;
    private Version version;
    private int maskPattern = -1;
    private ByteMatrix matrix;

    public Mode getMode() {
        return this.mode;
    }

    public ErrorCorrectionLevel getECLevel() {
        return this.ecLevel;
    }

    public Version getVersion() {
        return this.version;
    }

    public int getMaskPattern() {
        return this.maskPattern;
    }

    public ByteMatrix getMatrix() {
        return this.matrix;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(200);
        result.append("<<\n");
        result.append(" mode: ");
        result.append((Object)this.mode);
        result.append("\n ecLevel: ");
        result.append((Object)this.ecLevel);
        result.append("\n version: ");
        result.append(this.version);
        result.append("\n maskPattern: ");
        result.append(this.maskPattern);
        if (this.matrix == null) {
            result.append("\n matrix: null\n");
        } else {
            result.append("\n matrix:\n");
            result.append(this.matrix);
        }
        result.append(">>\n");
        return result.toString();
    }

    public void setMode(Mode value) {
        this.mode = value;
    }

    public void setECLevel(ErrorCorrectionLevel value) {
        this.ecLevel = value;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void setMaskPattern(int value) {
        this.maskPattern = value;
    }

    public void setMatrix(ByteMatrix value) {
        this.matrix = value;
    }

    public static boolean isValidMaskPattern(int maskPattern) {
        return maskPattern >= 0 && maskPattern < 8;
    }

    public static File create(String content) throws IOException, WriterException {
        return QRCode.create(content, 100);
    }

    public static File create(String content, int width) throws IOException, WriterException {
        File file = new File("qrcode", content.replace(File.separator, "_").replace(" ", "") + ".png");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        HashMap<EncodeHintType, ErrorCorrectionLevel> hintMap = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
        hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix byteMatrix = qrCodeWriter.encode(content, BarcodeFormat.QR_CODE, width, width, hintMap);
        int crunchifyWidth = byteMatrix.getWidth();
        BufferedImage image = new BufferedImage(crunchifyWidth, crunchifyWidth, 1);
        image.createGraphics();
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, crunchifyWidth, crunchifyWidth);
        graphics.setColor(Color.BLACK);
        for (int i = 0; i < crunchifyWidth; ++i) {
            for (int j = 0; j < crunchifyWidth; ++j) {
                if (!byteMatrix.get(i, j)) continue;
                graphics.fillRect(i, j, 1, 1);
            }
        }
        ImageIO.write((RenderedImage)image, "png", file);
        return file;
    }
}

