/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.orm.swing;

import br.com.ctecinf.Daruma;
import br.com.ctecinf.PDF;
import br.com.ctecinf.Utils;
import br.com.ctecinf.orm.Column;
import br.com.ctecinf.orm.Model;
import br.com.ctecinf.orm.swing.FormPanelController;
import br.com.ctecinf.swing.Image;
import br.com.ctecinf.swing.OptionPane;
import br.com.ctecinf.swing.PleaseWaitDialog;
import br.com.ctecinf.table.Table;
import br.com.ctecinf.table.TableModel;
import br.com.ctecinf.table.TablePopupMenu;
import br.com.ctecinf.text.UpperCaseFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.table.TableRowSorter;

public abstract class TablePanelController<T extends Model>
extends JPanel {
    private Class<T> controller;
    private Table table;
    private JToolBar buttonBar;
    private TablePopupMenu popup;
    private JFormattedTextField filter;
    private boolean reloadOnClose;

    protected abstract FormPanelController getForm(T var1);

    public TablePanelController() {
        this.controller = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.initUI(null);
    }

    public TablePanelController(Class<T> controller) {
        this.controller = controller;
        this.initUI(null);
    }

    public TablePanelController(TableModel tableModel) {
        this.controller = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.initUI(tableModel);
    }

    private void initUI(TableModel tableModel) {
        this.reloadOnClose = tableModel == null;
        this.setLayout(new BorderLayout());
        try {
            this.table = new Table(tableModel == null ? ((Model)this.controller.newInstance()).getTableModel() : tableModel);
        }
        catch (Exception ex) {
            OptionPane.error(ex);
        }
        this.filter = new JFormattedTextField(new UpperCaseFormatter());
        this.filter.setBorder(BorderFactory.createTitledBorder("Filtrar"));
        this.filter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String search = TablePanelController.this.filter.getText();
                    if (search.length() > 2) {
                        ((TableRowSorter)TablePanelController.this.table.getRowSorter()).setRowFilter(RowFilter.regexFilter(Pattern.compile(search, 2).pattern(), new int[0]));
                    } else {
                        ((TableRowSorter)TablePanelController.this.table.getRowSorter()).setRowFilter(null);
                    }
                } else if (e.getKeyCode() == 40) {
                    TablePanelController.this.table.requestFocus();
                    TablePanelController.this.table.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TablePanelController.this.viewEvent();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && TablePanelController.this.table.getSelectedRow() > -1) {
                    TablePanelController.this.viewEvent();
                }
                if (e.getKeyCode() == 38 && TablePanelController.this.table.getSelectedRow() == 0) {
                    SwingUtilities.invokeLater(() -> TablePanelController.this.table.clearSelection());
                    TablePanelController.this.filter.requestFocus();
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.filter, "North");
        panel.add((Component)new JScrollPane(this.table), "Center");
        this.buttonBar = new JToolBar(0);
        this.buttonBar.setFloatable(false);
        this.buttonBar.setLayout(new FlowLayout(2));
        this.popup = new TablePopupMenu(this.table);
        this.addAction("Atualizar", Image.parse("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"), e -> this.reload());
        this.addAction("Incluir", Image.parse("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"), e -> {
            try {
                this.createEvent((Model)this.controller.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                JOptionPane.showMessageDialog(null, ex, "Exception", 0);
            }
        });
        this.addAction("Visualizar", Image.parse("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"), e -> this.viewEvent());
        this.addAction("Apagar", Image.parse("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"), e -> this.deleteEvent());
        this.addAction("Imprimir", Image.parse("iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAAN1wAADdcBQiibeAAAAAd0SU1FB9wJGxctMtK0eoEAAAiKSURBVFjDpZdrbBzVFcd/M3NnZndnvV7Hz/i5dpzEVFUSRzWRSdQPBUWFIgFNaWlEQ0WVSHyI1A8gpAraSG2lqqhfqiipTFsgJSISar+AojxEUes8hMEmgTh+xDhxYsfxZne9Xq93Z+fZD7YHGygoyZXO7p3V3fv/n/8959wzEncxHn74z7H5+YWtiqJ+N5ezDn/88a9uc5dD+qYFzz77t7Js1u4Mh8V2IZQHSyV7vWFo+n331WvxeCT+1lsfXs5mhzr7+3vsuyEgVj48//wRw7ZFpyQpD6iq8qBp2htDIS3U1VWttm+oq2hbVy2trYsjyyDLoEgQDqutBw8WXwJ+c08KvPDCP7fattN///2JTEuiuqKhaY20prIc3wfPBx8WPySQpEVwRQZJ8nl455+up1IL6wcHD1h3SkBenrzyyq6BSET7z5atifimzlapvKKckgNFG4rWktlgWktmL5rtSjz5422Vtu3uuRsF5JUPuZy5+43Xzt5eML1VYMvzZSLL4KUl+/6jnUY4rO29ZwIHD/70ZrFov/HRh1edZeCi9Tl44PmKecmGsvIokiw3wgH5nggAZLPmH0+8M5AKgFYewUpgZ9HyCybDw0Ns3uyW79uXOrN///4j95yGv9j35rtPPfvID8qrKnBc8DzwlhbPZ2dI3xondfMzCrkZKiuiNDU1UVVVhWEYvPfee/7Q0NAmIO953mxPT8/cHRP44ZN/+cmO733n71se+HYkeWuC5NQYmelxBAs0N9XT3t5OIpFAVVXS6TS2bQd269Ytrly5gmEYmKZJMpmcTKVSRyVJOtTT03P9Gwns3bt3CyjPCxF5qq2tXmlra6W9vZ1169ZhGAa5XI5MJkOhUMCyLHzfB0BRFCRpcTvHcfA8L9gznU7T19dn3bhx43f19fW/P3DggPd/Cezbt+/Qnj17nuvs7CQSiQBgmiaZTIa5uTk8z0MIgaIoAajneTiOg2VZ2La9ClxRFHRdR9d1PvnkE06dOvVOKpV64u2333YBlC8S6OrqWmhubv55VVUVpmkyPT2NaZoIIYjFYsRiMVRVRdM0fN/HsixM06RYLOI4TqCIEIJwOIxhGBiGgRCChoYGysrKNk5MTEQHBgZOrVJg7969uwzD+GVjY+P2WCwm1dbWsm3bNqqrqwPPfN/Hdd1AEdM0vxQ/mqYFHquq+pWBd+zYMW9sbGz94cOHx5Ul8F+3tbUdfuihh5qbm5uleDyO53lcuHCBmZkZ1q9fD4DrujiOw/T0NLa9+u7RdT3wNhQKoSifiytJErquE4lEiEajJBIJ6eTJk+mLFy/+V+zfv1+PGMZLO3fuDM5xWcKamhoymQxHjhzhmWeewXEcCoUCrusuFhFZDrzVdR1Z/rysqKoa/C6EIJvNBhljWRau694PIAqFgtHU1KSWxWJYloW8AgAgEongeR5Hjx7l6aefJp/PYxgGmqYFthxsmqYF8SHLMrlcjqmpKSzLWvUfAN/3DUARiqKYtm0jhMDzPDRdx/M8PM/Dtu1Avvn5eXp7e+nu7kYIgaZpCCFQVRUhROC9ZVlcvXqVQqGApmlEo1FCodDqHmBxfQRQ5Z6enoLjOMiKghBi0ZbkWxlEoVCIsbExstkslZWVlJeXB17JsszU1BT9/f1cunQJIQSVlZWUlZUFtWHl8H0fVVVDgCKW8nxBEcLwfR/huqiqiuM4hEIhisVisImiKPT29rJr1y4A5ubmGB8fx7IsKioqqK+vD9Lwi8PzPPL5fKCooigaIAmAUqlkFQsFQw+FUIRYRUIIEQQmQCaT4cSJE0FNSCQSQfVzHOdLwIVCIagj4XA4UDUUCkUAsUwgn7x9uyI7O0s0GqWurg6hqqiOE6TTSim3bdtGWVlZAPrFlPR9n0wmg+u6RKNRMpkMAwMDOI7D7t27l9NWB2QBYNt2dv3GjU2+55FKJhkZGcF1HNbW139lMVmZJStHPp8nm80ihEDXdUZHR+nv7yedTgPQ0NDAEh6SJKkBAd/3iz4gC0FFVRVbYjGKxSKjIyOkUylcxyEcDq+6bFae7eTkJKVSiXA4jCzLXLlyhYmJCUzTRJIkotEopVKJUqnE2bNnOXfuXG5wcPCvwRFIkmQiSSiKgreUjrqus2HjRgqNjXx68SLJZDLIBtd1mZub4/r160iSRE1NDclkkomJCfL5PKZpUl5eTigUolQqoes68XictWvXkkwmicfjsZaWlid27979r+W2/PqV4WG+tWkTQgh838f3fYTnEQqHWbNmTRCMs7OzjI6O0tLSQkdHB67rks1mKZVKwaUDEA6HiUQi6LqO7/s4joPruliWhaZpSJJ0NR6PT4ulwvDca6++OlpTW/vio489ZrRv2IBQ1aAgVaxZQy6XQ5IkysrKSCQSNDU1BUfhui7pdDrwMhKJBPfG8ncymaSvr4/h4eG+wcHBN/r7+weBkgA4dOhQHvhtV1fX65+Njb2UaG392fcfeSTcvmEDqqZRWVPD1ORkEO2u667KClmWSSaT1NbWBv2Boij4vs+NGzc4f/48Q0NDH42MjBzp6+v7FLi+ZM6qfuDmzZu5y5cvv1syzWNXx8djw5cvdxjRqKiqrl5sWGdn8TyPxsZGKisrA4Xm5+fJ5XKUl5cjSRKSJDExMcHx48c5ffr0wPnz5/9w/PjxN6empvqBS0CaxTbz698Nu7u7O5qbm19ubGz8Uff27VqxUMAsFunu7qajo4NUKsXJkyc5c+bMZKlUSjU2Nm5OJBLS1NQU4+PjF0dHR1//4IMPLgCTSx5bd/xyulR4NrW2tr5cVVX1eF1dnejq6mJmZobe3t7Ja9eu/eP999//t+M4tzZv3hxvbm5+PJ1O3zx37tzHS8ATXwV8RwSW1+7YsWNrQ0PDi6qqJmZmZk4vAc8A14D8ij3jwMLXAS+P/wFbaEVOGZb8ywAAAABJRU5ErkJggg=="), ae -> this.printEvent());
        this.add((Component)this.buttonBar, "North");
        this.add((Component)panel, "Center");
        SwingUtilities.invokeLater(() -> this.filter.requestFocus());
    }

    public TablePanelController addAction(String label, ImageIcon icon, ActionListener action) {
        this.popup.addMenuItem(label, icon, action);
        JButton button = new JButton(label, icon);
        button.addActionListener(action);
        this.buttonBar.add(button);
        return this;
    }

    public Table getTable() {
        return this.table;
    }

    public JFormattedTextField getFilter() {
        return this.filter;
    }

    protected FormPanelController create(T obj) throws Exception {
        return this.getForm(obj);
    }

    protected FormPanelController view(T obj) throws Exception {
        return this.getForm(obj);
    }

    protected boolean delete(T obj) throws Exception {
        return ((Model)obj).delete();
    }

    protected File print(T obj) throws Exception {
        if (obj == null) {
            PDF pdf = new PDF();
            return pdf.parse(null, this.table);
        }
        Daruma p = new Daruma();
        p.head();
        p.linhaCorte();
        p.tamanhoFonte(2);
        p.negrito("Dados cadastro");
        p.novaLinha();
        p.novaLinha();
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            field.setAccessible(true);
            Object value = field.get(obj);
            p.leftLine(Daruma.bold(Utils.ascii(((Model)obj).getLabel(field.getName()), false)) + ": " + String.valueOf(value == null ? "" : value));
        }
        p.saltarLinhas(5);
        return null;
    }

    private void onFormPanelClosed(FormPanelController form) {
        if (form.getFrame() != null) {
            form.getFrame().setVisible(true);
            form.getFrame().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    if (TablePanelController.this.reloadOnClose) {
                        TablePanelController.this.reload();
                    }
                }
            });
        }
    }

    private void reload() {
        new PleaseWaitDialog<Boolean>(){

            @Override
            public Boolean exec() throws Exception {
                TablePanelController.this.table.removeAllRows();
                TablePanelController.this.table.setModel(((Model)TablePanelController.this.controller.newInstance()).getTableModel());
                return true;
            }

            @Override
            public void end(Boolean result) throws Exception {
            }
        }.start();
    }

    private T getSelectedObject() throws Exception {
        if (this.table.getSelectedRow() == -1) {
            throw new Exception("Nenhum registro selecionado.");
        }
        int index = this.table.getRowSorter().convertRowIndexToModel(this.table.getSelectedRow());
        return (T)((Model)this.table.getModel().getData().get(index));
    }

    private void deleteEvent() {
        T obj;
        try {
            obj = this.getSelectedObject();
        }
        catch (Exception ex) {
            OptionPane.error(ex);
            return;
        }
        if (OptionPane.confirm("Deseja realmente exclu\u00edr registro [" + String.valueOf(obj) + "]?")) {
            new PleaseWaitDialog<Boolean>(this){
                final /* synthetic */ TablePanelController this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Boolean exec() throws Exception {
                    return this.this$0.delete(obj);
                }

                @Override
                public void end(Boolean result) throws Exception {
                    if (result.booleanValue()) {
                        OptionPane.success("Registro exclu\u00eddo com sucesso.");
                        this.this$0.reload();
                    }
                }
            }.start();
        }
    }

    private void createEvent(final T obj) {
        new PleaseWaitDialog<FormPanelController>(this){
            final /* synthetic */ TablePanelController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public FormPanelController exec() throws Exception {
                return this.this$0.create(obj);
            }

            @Override
            public void end(FormPanelController result) {
                this.this$0.onFormPanelClosed(result);
            }
        }.start();
    }

    private void viewEvent() {
        T obj;
        try {
            obj = this.getSelectedObject();
        }
        catch (Exception ex) {
            OptionPane.error(ex);
            return;
        }
        new PleaseWaitDialog<FormPanelController>(this){
            final /* synthetic */ TablePanelController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public FormPanelController exec() throws Exception {
                return this.this$0.view(obj);
            }

            @Override
            public void end(FormPanelController result) {
                this.this$0.onFormPanelClosed(result);
            }
        }.start();
    }

    private void printEvent() {
        Model object = null;
        try {
            object = (Model)this.getSelectedObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        final Model obj = object;
        new PleaseWaitDialog<File>(this){
            final /* synthetic */ TablePanelController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public File exec() throws Exception {
                return this.this$0.print(obj);
            }

            @Override
            public void end(File result) {
                if (result != null) {
                    try {
                        Desktop.getDesktop().open(result);
                        result.deleteOnExit();
                    }
                    catch (Exception ex) {
                        OptionPane.error(ex);
                    }
                }
            }
        }.start();
    }
}

