/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.orm.swing;

import br.com.ctecinf.Config;
import br.com.ctecinf.Daruma;
import br.com.ctecinf.Database;
import br.com.ctecinf.Utils;
import br.com.ctecinf.autocomplete.AutoCompleteField;
import br.com.ctecinf.combobox.ComboBox;
import br.com.ctecinf.combobox.ComboBoxModel;
import br.com.ctecinf.orm.Column;
import br.com.ctecinf.orm.Model;
import br.com.ctecinf.orm.NullModel;
import br.com.ctecinf.swing.Fields;
import br.com.ctecinf.swing.GridPanel;
import br.com.ctecinf.swing.Image;
import br.com.ctecinf.swing.OptionPane;
import br.com.ctecinf.swing.PleaseWaitDialog;
import br.com.ctecinf.text.PasswordFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class FormPanelController<T extends Model>
extends JPanel
implements Serializable {
    private Fields fields;
    private JComponent pane;
    private GridPanel lastPanel;
    private T controller;
    private int row;
    private int colIndex;
    private JToolBar buttonBar;
    private JFrame frame;

    public FormPanelController(T controller) {
        this(null, controller, 1);
    }

    public FormPanelController(T controller, int numCols) {
        this(null, controller, numCols);
    }

    public FormPanelController(String title, T controller) {
        this(title, controller, 1);
    }

    public FormPanelController(String title, T controller, int numCols) {
        super(new BorderLayout());
        if (title == null) {
            this.pane = new GridPanel(numCols);
            this.lastPanel = (GridPanel)this.pane;
        } else {
            this.pane = new JTabbedPane();
            this.addTab(title, numCols);
        }
        this.fields = new Fields();
        this.controller = controller;
        this.initUI();
    }

    private void initUI() {
        this.colIndex = 0;
        this.buttonBar = new JToolBar();
        this.buttonBar.setFloatable(false);
        this.buttonBar.setLayout(new FlowLayout(2));
        this.addAction("Salvar", Image.parse("iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAATdEVYdFRpdGxlAE9wdGljYWwgRHJpdmU+Z7oMAAAEVklEQVRYhcWXz49TVRzFP9/77nsznR/tOAUxmggiMIg6atiIaFy4xJ0xunLBRoMLF2jCQmLYuHKF/gXujDtiDAsXJhiEoAQchyCJCTEROhkSpzrlvbb33q+L23amVGYmaQ3fpO3t+3XOveecb29FVXmQZR4oOmDXf3nzrTdOishJIL1bNFl6+O2RAbV/+ozgHSGElgZOLS4ufjpAQEQ+3rlrT1oul/n58hWOv/MyLgwPbg18Wfuaubl91Ov17Py57z8BBgkA2XS5zLdnz9Jqtbl6c4WWG94jmRVu1W5zq1bjlcOHAbIeuXsvVlUunDvHwRcPcezVClNT00MTWF39h7On4cqlixx+6RAhrC1rnwlVFVXloxMnhgYdLOGD4x+C6v0JhBDQEPjx4gVEZLTwAj+cP48qfQT6JAghgGoPvN5Yod5YGRUFjAigGxNQVYwIIlCZnKFSmRkaul5fQQREBNXNCBAvFOIqGDO6XhUJhM1WIEQJpHvTaAiIRAmiB9aifV8JQEbsARCzFQlUERMFqEzOsH37jqGBl5eXoqwisJkE3RR0UzhKDxgRdOMUKKrxwi6D0XlgyynQXgoajQa12p9DgzcaDURMR4JNG1FMwXgp4+i7x6CzYRn4SdK1o9p3bGCIAFlqOybcNIbRhKWxMUpjY+h6An3j+NYdaxdy3bi32dLeWVTBe78BAbRjllj79j7J/qfmUFW894QQCN7jQyD4gA+e4OOsuud98FxbvM716zdQoqfK5TITU1Mgm3iAsJYCVdi9exfPzD9NdXYbWZqRphmZjZ+JMTjvcM7jvANVrE0pipzPvzhNs+0QhGarydLtGpPT02jYogm72jVbLWZnZrn8y0Vu/bFMM28RQqBUGufI60fI85y8yMnzu2RpxsTEJHue2Eue5zjnQGGiVEKM2UoM44meBAJFUWCMIUks9b/qLCxcA2Bubg/NZhPn2rh2mxACSZKQJAmIkOdFfI7QOy4iiCq6USsO3UbU8VmRFxiTkNqUoih6BsuLAu8cznuc91ibxleSEkKgKIrOc5QkSbBJElNAfwwHNiTSbcUimHUrkKaRgOm01KIocN7jvcN7h7WWJLFYa1FVnHO99pvYhCTpSHDP/5ABAj54SuPjvZsjqCG1WW9WRoQiLyK48xgx2A54CKFPShHBJglJYjve+g8CEisV9OrCwq/NanUbpdL4GgFjSG1KmmaUSuNkWUqapijgOrO31mITi/cO1UhATCQbPbDWCTuYqYhI1wMCTN347ff3ms32V865R+fnn7Uihjt3lkGEA/vmmT91sAfSzb3zDpukPRLOueh+oDpbRTVQqcxQ3VZlenKav1f/BnDAQ8Ad0Wi6BHgE2G+tfW3nrsePAjtCCDz/wnNYO7B737RazRZnznzT5/jOzL0x5jvv/fvAzS4BA1SAx4ADwPS9/hhheWAJuMS6FRBiJMeA8f8RvFttYBVwsj4WMuo/AxuUdoD/BeaOg3cw+7FtAAAAAElFTkSuQmCC"), ae -> new PleaseWaitDialog<Boolean>(){

            @Override
            public Boolean exec() throws Exception {
                return FormPanelController.this.save(FormPanelController.this.fields.getValues());
            }

            @Override
            public void end(Boolean result) {
                if (result.booleanValue()) {
                    OptionPane.success(FormPanelController.this.controller.getClass().getSimpleName() + "[" + String.valueOf(FormPanelController.this.controller) + "] salvo com sucesso.");
                }
            }
        }.start());
        this.addAction("Apagar", Image.parse("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"), ae -> {
            if (OptionPane.confirm("Deseja realmente exclu\u00edr registro?")) {
                new PleaseWaitDialog<Boolean>(){

                    @Override
                    public Boolean exec() throws Exception {
                        return FormPanelController.this.delete();
                    }

                    @Override
                    public void end(Boolean result) {
                        if (result.booleanValue()) {
                            if (FormPanelController.this.frame != null) {
                                FormPanelController.this.frame.dispose();
                            }
                            OptionPane.success(FormPanelController.this.controller.getClass().getSimpleName() + "[" + String.valueOf(FormPanelController.this.controller) + "] apagado com sucesso.");
                        }
                    }
                }.start();
            }
        });
        this.addAction("Imprimir", Image.parse("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"), ae -> new PleaseWaitDialog<Boolean>(){

            @Override
            public Boolean exec() throws Exception {
                return FormPanelController.this.print();
            }

            @Override
            public void end(Boolean result) {
                if (result.booleanValue()) {
                    OptionPane.success("Impress\u00e3o conclu\u00edda.");
                }
            }
        }.start());
        this.add((Component)this.buttonBar, "North");
        if (this.pane instanceof JTabbedPane) {
            this.add((Component)this.pane, "Center");
        } else {
            this.add((Component)new JScrollPane(this.pane), "Center");
        }
    }

    public void setFieldsValues() {
        for (Field field : this.controller.getClass().getDeclaredFields()) {
            String name = null;
            if (this.fields.getComponents().containsKey(field.getName())) {
                name = field.getName();
            }
            if (name == null) continue;
            field.setAccessible(true);
            try {
                this.setValue(name, field.get(this.controller));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                System.err.println(ex);
            }
        }
    }

    public JComponent getForm() {
        return this.pane;
    }

    public Fields getFields() {
        return this.fields;
    }

    public <T extends JComponent> T getComponent(String name) {
        return this.fields.getComponent(name);
    }

    public void setValue(String name, Object value) {
        this.fields.setValue(name, value);
    }

    public Object getValue(String name) {
        return this.fields.getValue(name);
    }

    public Map<String, Object> getValues() {
        return this.fields.getValues();
    }

    public void cleanFields() {
        this.fields.cleanValues();
    }

    public T getController() {
        return this.controller;
    }

    public final void addTab(String title, int numColumns) {
        if (this.pane instanceof JTabbedPane) {
            GridPanel panel = new GridPanel(numColumns);
            panel.setEnterForward(this.isEnterForward());
            this.lastPanel = panel;
            ((JTabbedPane)this.pane).add(title, new JScrollPane(panel));
            this.row = 1;
            this.colIndex = 0;
        }
    }

    public void newRow() {
        ++this.row;
        this.colIndex = 0;
    }

    public void addLine(Object field) {
        GridPanel panel = this.lastPanel;
        this.addColumn(field, 0, panel.getNumColumns());
    }

    public void addColumn(Object ... field) {
        for (Object obj : field) {
            this.addColumn(obj, this.colIndex, 1);
        }
    }

    public void addColumn(Object field, int col) {
        this.addColumn(field, col, 1);
    }

    public void addColumn(Object field, int col, int numColsOcupped) {
        this.addColumn(field, col, numColsOcupped, true);
    }

    public void addColumn(Object field, int col, int numColsOcupped, boolean fill) {
        Field classField = null;
        JComponent component = field instanceof JComponent ? (AutoCompleteField)field : null;
        try {
            if (component != null) {
                if (component.getName() != null) {
                    classField = this.controller.getClass().getDeclaredField(component.getName());
                }
                this.fields.put(component);
            } else if (field instanceof String) {
                classField = this.controller.getClass().getDeclaredField(field.toString());
            }
        }
        catch (NoSuchFieldException | SecurityException ex) {
            System.err.println(ex);
        }
        if (classField != null) {
            String label = Database.java2Database(classField.getName()).replace("_", " ").toUpperCase();
            boolean notNull = false;
            if (classField.isAnnotationPresent(Column.class)) {
                Column column = classField.getAnnotation(Column.class);
                if (!column.label().isEmpty()) {
                    label = column.label();
                }
                notNull = column.isNotNull();
                if (component == null) {
                    if (!column.join().isAssignableFrom(NullModel.class)) {
                        if (column.isAutoComplete()) {
                            try {
                                component = new AutoCompleteField(classField.getName(), ((Model)classField.getType().newInstance()).getAutoCompleteModel());
                            }
                            catch (IllegalAccessException | InstantiationException ex) {
                                System.err.println(ex);
                            }
                        } else {
                            try {
                                ComboBoxModel model = ((Model)classField.getType().newInstance()).getComboBoxModel();
                                component = new ComboBox(model);
                                component.setName(classField.getName());
                            }
                            catch (IllegalAccessException | InstantiationException ex) {
                                System.err.println(ex);
                            }
                        }
                        if (component != null) {
                            this.fields.put(component);
                        }
                    } else if (column.isCrypt()) {
                        JFormattedTextField c = new JFormattedTextField(new PasswordFormatter());
                        c.setName(classField.getName());
                        this.fields.put(c);
                    } else if (!column.mask().isEmpty()) {
                        this.fields.create(classField.getName(), null, column.mask());
                    } else if (column.defaultValues().length > 0) {
                        this.fields.create(classField.getName(), column.defaultValues());
                    } else {
                        this.fields.create(classField.getName(), column.type());
                    }
                    component = this.fields.getComponent(field.toString());
                }
            }
            if (component != null) {
                this.fields.setLabel(component.getName(), label, notNull);
            }
        }
        this.add(component, this.row, col, numColsOcupped, fill);
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.colIndex;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void addRequiredFieldLabel() {
        JLabel labelMsg = new JLabel("* Campo(s) obrigat\u00f3rio(s).");
        labelMsg.setForeground(Color.RED);
        this.addTitle(labelMsg);
    }

    public void addBreakLine() {
        this.addTitle("");
    }

    public void addTitle(String title) {
        JLabel label = new JLabel(title, 0);
        label.setOpaque(true);
        label.setBackground(MetalLookAndFeel.getPrimaryControl());
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, MetalLookAndFeel.getFocusColor(), MetalLookAndFeel.getControlDarkShadow()), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.addTitle(label);
    }

    private void addTitle(JLabel label) {
        GridPanel panel = this.lastPanel;
        this.add(label, this.row, 0, panel.getNumColumns(), true);
        ++this.row;
        this.colIndex = 0;
    }

    public FormPanelController addAction(String label, ImageIcon icon, ActionListener action) {
        JButton button = new JButton(label, icon);
        button.addActionListener(action);
        this.buttonBar.add(button);
        return this;
    }

    public FormPanelController<T> getDefaultForm() {
        return this.getDefaultForm(null);
    }

    public FormPanelController<T> getDefaultForm(String title) {
        this.addRequiredFieldLabel();
        for (Field field : this.getController().getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            this.addColumn(field.getName());
        }
        if (title != null) {
            this.createFrame(title);
            this.addAction("Fechar", Image.parse("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"), e -> this.getFrame().dispose());
        }
        this.setFieldsValues();
        return this;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    protected void setLabel(String fieldName, String label) {
        this.setLabel(fieldName, label, false);
    }

    protected void setLabel(String fieldName, String label, boolean notNull) {
        this.fields.setLabel(fieldName, label, notNull);
    }

    protected Object[] initValues(String columnName) {
        Object[] values = new Object[]{};
        return values;
    }

    protected String getMask(String columnName) {
        return "";
    }

    protected boolean isEnterForward() {
        return false;
    }

    protected JFrame createFrame() {
        return this.createFrame(null);
    }

    protected JFrame createFrame(String title) {
        ImageIcon icon = !Config.get("logo.path").isEmpty() ? new ImageIcon(new File(Config.get("logo.path")).getAbsolutePath()) : Image.parse("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", 16);
        this.frame = new JFrame(title == null ? "" : title);
        this.frame.setIconImage(icon.getImage());
        this.frame.setLayout(new BorderLayout());
        this.frame.setDefaultCloseOperation(2);
        this.frame.add((Component)this, "Center");
        this.frame.setMinimumSize(new Dimension(600, 400));
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        return this.frame;
    }

    protected boolean save(Map<String, Object> params) throws Exception {
        ((Model)this.controller).setValues(params);
        try {
            boolean bl = ((Model)this.controller).save() != null;
            return bl;
        }
        finally {
            if (this.frame != null) {
                this.frame.dispose();
            }
        }
    }

    protected boolean delete() throws Exception {
        ((Model)this.controller).setValues(this.fields.getValues());
        return ((Model)this.controller).delete();
    }

    protected boolean print() throws Exception {
        Daruma p = new Daruma();
        p.head();
        p.linhaCorte();
        p.tamanhoFonte(2);
        p.negrito("Dados cadastro");
        p.novaLinha();
        p.novaLinha();
        for (Field field : this.getController().getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            field.setAccessible(true);
            Object value = field.get(this.getController());
            p.leftLine(Daruma.bold(Utils.ascii(((Model)this.getController()).getLabel(field.getName()), false)) + ": " + String.valueOf(value == null ? "" : value));
        }
        p.saltarLinhas(5);
        return true;
    }

    protected void add(JComponent c, int row, int col, int numColsOcup, boolean fill) {
        GridPanel panel = this.lastPanel;
        panel.add(c, col, row, numColsOcup, 1.0 / (double)panel.getNumColumns(), fill);
        this.colIndex = col + numColsOcup;
        if (this.colIndex >= panel.getNumColumns()) {
            ++this.row;
            this.colIndex = 0;
        }
    }
}

