/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.orm;

import br.com.ctecinf.Database;
import br.com.ctecinf.autocomplete.AutoCompleteModel;
import br.com.ctecinf.combobox.ComboBoxModel;
import br.com.ctecinf.orm.Column;
import br.com.ctecinf.orm.NullModel;
import br.com.ctecinf.orm.Table;
import br.com.ctecinf.swing.OptionPane;
import br.com.ctecinf.table.TableColumn;
import br.com.ctecinf.table.TableModel;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Model
implements Comparable<Model>,
Serializable {
    protected String primaryKey = "id";
    private Object id;

    public Long getId() {
        return this.id == null ? null : Long.valueOf(Long.parseLong(this.id.toString()));
    }

    public <T extends Model> T setId(Object id) throws Exception {
        this.id = id;
        if (id != null) {
            String where;
            Class<?> model = this.getClass();
            List<?> list = this.find(model, where = Model.getTableName(model) + "." + this.primaryKey + " = " + String.valueOf(id), -1);
            if (list == null) {
                this.id = null;
                return null;
            }
            Model obj = (Model)list.get(0);
            for (Field field : model.getDeclaredFields()) {
                Field f = obj.getClass().getDeclaredField(field.getName());
                f.setAccessible(true);
                field.setAccessible(true);
                field.set(this, f.get(obj));
            }
        }
        return (T)this;
    }

    public <T extends Model> Map<String, Object> getParams() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(this.primaryKey, this.id);
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            Column column = field.getAnnotation(Column.class);
            String name = column.name().isEmpty() ? Database.java2Database(field.getName()) : column.name();
            field.setAccessible(true);
            Object obj = field.get(this);
            if (obj != null && column.join().isAssignableFrom(NullModel.class)) {
                try {
                    if (field.getType().isAssignableFrom(String.class) && !obj.getClass().isAssignableFrom(String.class)) {
                        obj = obj.toString();
                    } else if (field.getType().isAssignableFrom(BigDecimal.class) && !obj.getClass().isAssignableFrom(BigDecimal.class)) {
                        obj = BigDecimal.valueOf(Double.valueOf(obj.toString()));
                    } else if (field.getType().isAssignableFrom(Boolean.class) && !obj.getClass().isAssignableFrom(Boolean.class) || field.getType().isAssignableFrom(Boolean.TYPE) && !obj.getClass().isAssignableFrom(Boolean.TYPE)) {
                        obj = obj.toString().equalsIgnoreCase("sim") || obj.toString().equalsIgnoreCase("true") || obj.toString().equalsIgnoreCase("yes") || obj.toString().equalsIgnoreCase("1");
                    } else if (field.getType().isAssignableFrom(Double.class) && !obj.getClass().isAssignableFrom(Double.class) || field.getType().isAssignableFrom(Double.TYPE) && !obj.getClass().isAssignableFrom(Double.TYPE)) {
                        obj = Double.parseDouble(obj.toString());
                    } else if (field.getType().isAssignableFrom(Float.class) && !obj.getClass().isAssignableFrom(Float.class) || field.getType().isAssignableFrom(Float.TYPE) && !obj.getClass().isAssignableFrom(Float.TYPE)) {
                        obj = Float.valueOf(Float.parseFloat(obj.toString()));
                    } else if (field.getType().isAssignableFrom(Long.class) && !obj.getClass().isAssignableFrom(Long.class) || field.getType().isAssignableFrom(Long.TYPE) && !obj.getClass().isAssignableFrom(Long.TYPE)) {
                        obj = Long.parseLong(obj.toString());
                    } else if (field.getType().isAssignableFrom(Integer.class) && !obj.getClass().isAssignableFrom(Integer.class) || field.getType().isAssignableFrom(Integer.TYPE) && !obj.getClass().isAssignableFrom(Integer.TYPE)) {
                        obj = Integer.parseInt(obj.toString());
                    }
                }
                catch (Exception ex) {
                    throw new Exception("Valor do campo [" + field.getName() + "] n\u00e3o corresponde ao tipo.\n" + ex.getMessage());
                }
            }
            if (!column.join().isAssignableFrom(NullModel.class)) {
                params.put(name.toLowerCase(), this.extractId((Model)obj));
                continue;
            }
            params.put(name.toLowerCase(), obj);
        }
        return params;
    }

    public void setValues(Map<String, Object> params) throws Exception {
        if (params.containsKey(this.primaryKey)) {
            this.id = params.get(this.primaryKey);
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Field field = this.getClass().getDeclaredField(Database.database2Java(entry.getKey()));
            if (field == null) continue;
            field.setAccessible(true);
            Object value = params.get(entry.getKey());
            if (value instanceof Number) {
                Number num = (Number)value;
                if (field.getType().isAssignableFrom(Long.class) || field.getType().isAssignableFrom(Long.TYPE)) {
                    value = num.longValue();
                } else if (field.getType().isAssignableFrom(Integer.class) || field.getType().isAssignableFrom(Integer.TYPE)) {
                    value = num.intValue();
                } else if (field.getType().isAssignableFrom(Double.class) || field.getType().isAssignableFrom(Double.TYPE)) {
                    value = num.doubleValue();
                } else if (field.getType().isAssignableFrom(Float.class) || field.getType().isAssignableFrom(Float.TYPE)) {
                    value = Float.valueOf(num.floatValue());
                } else if (field.getType().isAssignableFrom(BigDecimal.class)) {
                    value = BigDecimal.valueOf(num.doubleValue());
                }
            }
            if (field.getType().isAssignableFrom(String.class) && value != null && !value.getClass().isAssignableFrom(String.class)) {
                value = value.toString();
            }
            field.set(this, value);
        }
    }

    public <T extends Model> Long save() throws Exception {
        Map<String, Object> params = this.getParams();
        String sql = this.id == null ? Database.insertScript(Model.getTableName(this.getClass()), this.primaryKey, params) : Database.updateScript(Model.getTableName(this.getClass()), this.primaryKey, params);
        this.id = Database.executeUpdate(sql);
        return this.getId();
    }

    public boolean delete() throws Exception {
        if (this.id == null) {
            throw new Exception("Identificador nulo.");
        }
        String sql = "DELETE FROM " + Model.getTableName(this.getClass()) + " WHERE " + this.primaryKey + "='" + String.valueOf(this.id) + "'";
        Long ret = Database.executeUpdate(sql);
        this.id = null;
        return ret != null && ret > -1L;
    }

    public <T extends Model> List<T> findAll() throws Exception {
        return this.find(this.getClass(), null, -1);
    }

    public <T extends Model> List<T> listOf(Class<T> model) throws Exception {
        if (this.id == null) {
            return null;
        }
        String where = Model.getTableName(this.getClass()) + "." + this.primaryKey + "=" + String.valueOf(this.id);
        return this.find(model, where, -1);
    }

    public <T extends Model> TableModel getTableModel() throws Exception {
        return this.getTableModel(this.getClass());
    }

    public <T extends Model> TableModel getTableModel(Class<T> model) throws Exception {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        List<T> data = Collections.synchronizedList(new ArrayList());
        columns.add(new TableColumn(0, this.primaryKey, "C\u00f3digo", Long.class, 6));
        int index = 1;
        for (Field field : model.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Column.class) || !field.getAnnotation(Column.class).tableDisplay()) continue;
            Column column = field.getAnnotation(Column.class);
            String label = column.label().isEmpty() ? column.name() : column.label();
            columns.add(new TableColumn(index, field.getName(), label, field.getType(), field.getName().length()));
            ++index;
        }
        String where = null;
        if (!this.getClass().isAssignableFrom(model) && this.id != null) {
            where = Model.getTableName(this.getClass()) + "." + this.primaryKey + "=" + String.valueOf(this.id);
        } else if (!this.getClass().isAssignableFrom(model) && this.id == null) {
            return new TableModel(columns, data);
        }
        String query = this.query(model, where);
        try (Connection conn = Database.openConnection();
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                data.add(this.newInstance(model, rs, columns));
            }
        }
        return new TableModel(columns, data);
    }

    public <T extends Model> AutoCompleteModel<T> getAutoCompleteModel() {
        final AutoCompleteModel listModel = new AutoCompleteModel();
        final Class<?> model = this.getClass();
        new Thread(new Runnable(){
            final /* synthetic */ Model this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try (Connection conn = Database.openConnection();
                     Statement st = conn.createStatement();
                     ResultSet rs = st.executeQuery(this.this$0.query(model, null));){
                    while (rs.next()) {
                        Object obj = this.this$0.newInstance(model, rs);
                        listModel.add(obj);
                    }
                    listModel.endLoad();
                }
                catch (Exception ex) {
                    OptionPane.error(ex);
                    listModel.endLoad();
                }
            }
        }).start();
        return listModel;
    }

    public <T extends Model> ComboBoxModel<T> getComboBoxModel() {
        ComboBoxModel comboModel = new ComboBoxModel();
        Class<?> model = this.getClass();
        try (Connection conn = Database.openConnection();
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery(this.query(model, null));){
            while (rs.next()) {
                Object obj = this.newInstance(model, rs);
                comboModel.addElement(obj);
                comboModel.setWidth(Math.max(comboModel.getWidth(), obj.toString().length()));
            }
        }
        catch (Exception ex) {
            OptionPane.error(ex);
        }
        return comboModel;
    }

    public <T extends Model> Class<?> getType(String fieldName) {
        return this.getType(this.getClass(), fieldName);
    }

    public <T extends Model> Class<?> getType(Class<T> model, String fieldName) {
        try {
            Field field = model.getDeclaredField(fieldName);
            return field.getType();
        }
        catch (NoSuchFieldException | SecurityException ex) {
            return Object.class;
        }
    }

    public <T extends Model> boolean isNotNull(String fieldName) {
        return this.isNotNull(this.getClass(), fieldName);
    }

    public <T extends Model> boolean isNotNull(Class<T> model, String fieldName) {
        try {
            Field field = model.getDeclaredField(fieldName);
            if (field.isAnnotationPresent(Column.class)) {
                return field.getAnnotation(Column.class).isNotNull();
            }
            return false;
        }
        catch (NoSuchFieldException | SecurityException ex) {
            return false;
        }
    }

    public <T extends Model> String getLabel(String fieldName) {
        return this.getLabel(this.getClass(), fieldName);
    }

    public <T extends Model> String getLabel(Class<T> model, String fieldName) {
        try {
            Field field = model.getDeclaredField(fieldName);
            if (field.isAnnotationPresent(Column.class)) {
                return field.getAnnotation(Column.class).label();
            }
            return null;
        }
        catch (NoSuchFieldException | SecurityException ex) {
            return null;
        }
    }

    public <T extends Model> String[] getDefaultValues(String fieldName) {
        return this.getDefaultValues(this.getClass(), fieldName);
    }

    public <T extends Model> String[] getDefaultValues(Class<T> model, String fieldName) {
        try {
            Field field = model.getDeclaredField(fieldName);
            if (field.isAnnotationPresent(Column.class)) {
                return field.getAnnotation(Column.class).defaultValues();
            }
            return new String[0];
        }
        catch (NoSuchFieldException | SecurityException ex) {
            return new String[0];
        }
    }

    protected <T extends Model> List<T> find(Class<T> model, String where, int maxResults) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        try (Connection conn = Database.openConnection();
             Statement st = conn.createStatement();){
            if (maxResults > 0) {
                st.setMaxRows(maxResults);
            }
            try (ResultSet rs = st.executeQuery(this.query(model, where));){
                while (rs.next()) {
                    T obj = this.newInstance(model, rs);
                    list.add(obj);
                }
            }
        }
        return list.isEmpty() ? null : list;
    }

    private <T extends Model> Object extractId(T obj) throws Exception {
        if (obj == null) {
            return null;
        }
        Class<Model> model = obj.getClass().getSuperclass();
        if (model.isAssignableFrom(Model.class)) {
            Field field = model.getDeclaredField("id");
            field.setAccessible(true);
            return field.get(obj);
        }
        return null;
    }

    private static <T extends Model> String getTableName(Class<T> model) {
        return model.isAnnotationPresent(Table.class) ? model.getAnnotation(Table.class).value() : Database.java2Database(model.getSimpleName());
    }

    private <T extends Model> String getPrimaryKey(Class<T> model) throws Exception {
        Field field = model.getSuperclass().getDeclaredField("primaryKey");
        field.setAccessible(true);
        return (String)field.get(model.newInstance());
    }

    private <T extends Model> T newInstance(Class<T> model, ResultSet rs) throws Exception {
        return this.newInstance(model, rs, null);
    }

    private <T extends Model> T newInstance(Class<T> model, ResultSet rs, List<TableColumn> columns) throws Exception {
        String table = Model.getTableName(model);
        String idColumn = table + "_" + this.primaryKey;
        Object idValue = Database.toValue(rs, idColumn);
        if (idValue != null) {
            Model obj = (Model)model.newInstance();
            model.getSuperclass().getDeclaredField("id").set(obj, idValue);
            for (Field field : model.getDeclaredFields()) {
                Object o;
                if (!field.isAnnotationPresent(Column.class)) continue;
                Column column = field.getAnnotation(Column.class);
                String name = column.name().isEmpty() ? Database.java2Database(field.getName()) : column.name();
                TableColumn tableColumn = this.getTableColumn(columns, name);
                field.setAccessible(true);
                if (field.getAnnotation(Column.class).join().isAssignableFrom(NullModel.class)) {
                    o = Database.toValue(rs, table + "_" + name);
                    if (tableColumn != null && o != null && o.toString().trim().length() > tableColumn.getWidth()) {
                        tableColumn.setWidth(o.toString().trim().length());
                    }
                    field.set(obj, o);
                    continue;
                }
                o = this.newInstance(field.getType(), rs, columns);
                if (tableColumn != null && o != null && o.toString().trim().length() > tableColumn.getWidth()) {
                    tableColumn.setWidth(o.toString().trim().length());
                }
                field.set(obj, o);
            }
            return (T)obj;
        }
        return null;
    }

    private TableColumn getTableColumn(List<TableColumn> columns, String name) {
        if (columns != null && name != null) {
            for (TableColumn column : columns) {
                if (!column.getName().equalsIgnoreCase(name)) continue;
                return column;
            }
        }
        return null;
    }

    private <T extends Model> String query(Class<T> model, String where) throws Exception {
        String table = Model.getTableName(model);
        String join = this.setJoin(model);
        String cols = table + "." + this.primaryKey + " AS " + table + "_" + this.primaryKey;
        cols = cols + this.setCols(model);
        return "SELECT " + cols + " FROM " + table + join + (String)(where == null ? "" : " WHERE " + where);
    }

    private <T extends Model> String setCols(Class<T> model) throws Exception {
        String table = Model.getTableName(model);
        Object cols = "";
        for (Field field : model.getDeclaredFields()) {
            if (field.isAnnotationPresent(Column.class)) {
                String name = field.getAnnotation(Column.class).name().isEmpty() ? Database.java2Database(field.getName()) : field.getAnnotation(Column.class).name();
                cols = (String)cols + ", " + table + "." + name + " AS " + table + "_" + name;
            }
            if (!field.isAnnotationPresent(Column.class) || field.getAnnotation(Column.class).join().isAssignableFrom(NullModel.class)) continue;
            Column column = field.getAnnotation(Column.class);
            String name = column.name().isEmpty() ? Database.java2Database(field.getName()) : column.name();
            Class<? extends Model> ref = column.join();
            String tableRef = Model.getTableName(ref);
            String idRef = this.getPrimaryKey(ref);
            cols = (String)cols + ", CASE WHEN " + table + "." + name + " IS NULL THEN NULL ELSE " + tableRef + "." + idRef + " END AS " + tableRef + "_" + idRef;
            cols = (String)cols + this.setCols(ref);
        }
        return cols;
    }

    private <T extends Model> String setJoin(Class<T> model) throws Exception {
        String table = Model.getTableName(model);
        Object join = "";
        for (Field field : model.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Column.class) || field.getAnnotation(Column.class).join().isAssignableFrom(NullModel.class)) continue;
            Column column = field.getAnnotation(Column.class);
            String name = column.name().isEmpty() ? Database.java2Database(field.getName()) : column.name();
            Class<? extends Model> ref = column.join();
            String tableRef = Model.getTableName(ref);
            String idRef = this.getPrimaryKey(ref);
            join = (String)join + " JOIN " + tableRef + " ON CASE WHEN " + table + "." + name + " IS NULL THEN (SELECT MIN(" + tableRef + "." + idRef + ") FROM " + tableRef + ") ELSE " + table + "." + name + " END = " + tableRef + "." + idRef;
            join = (String)join + this.setJoin(ref);
        }
        return join;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Model other = (Model)obj;
        return Objects.equals(this.id, other.id);
    }

    @Override
    public int compareTo(Model o) {
        if (o == null) {
            return 1;
        }
        return this.toString().compareToIgnoreCase(o.toString());
    }
}

