/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.orm;

import br.com.ctecinf.Database;
import br.com.ctecinf.Utils;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;

public class CodeGenerate {
    public static void model() throws Exception {
        CodeGenerate.model(null, false);
    }

    public static void model(String path) throws Exception {
        CodeGenerate.model(path, false);
    }

    public static void model(String path, boolean replaceExist) throws Exception {
        String packModel = "br.com.ctecinf.model";
        if (path == null || ((String)path).isEmpty()) {
            path = "src";
        }
        if (((String)path).endsWith(File.separator)) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        path = (String)path + File.separator + packModel.replace(".", File.separator);
        try (Connection conn = Database.openConnection();
             ResultSet rs = conn.getMetaData().getTables(null, null, "%", new String[]{"TABLE"});){
            while (rs.next()) {
                String tableName = rs.getString(3).toLowerCase().trim();
                String className = Database.database2Java(tableName, true);
                SimpleDateFormat dtCreate = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                SimpleDateFormat dtVersion = new SimpleDateFormat("yyyyMM");
                Object getSets = "";
                Object toString = "";
                String content = "/*\n * To change this license header, choose License Headers in Project Properties.\n * To change this template file, choose Tools | Templates\n * and open the template in the editor.\n */\npackage " + packModel + ";\n\nimport br.com.ctecinf.orm.Model;\nimport br.com.ctecinf.orm.Table;\nimport br.com.ctecinf.orm.Column;\nimport java.sql.Types;\n\n/**\n *\n * @author C\u00e1ssio Concei\u00e7\u00e3o\n * @since " + dtCreate.format(new Date()) + "\n * @version " + dtVersion.format(new Date()) + "\n * @see http://ctecinf.com.br/\n */\n@Table(\"" + rs.getString(3).toLowerCase().trim() + "\")\npublic class " + className + " extends Model {\n\n";
                String columnId = null;
                TreeMap<String, String> columnsFk = new TreeMap<String, String>();
                try (ResultSet rsCols = conn.getMetaData().getPrimaryKeys(conn.getCatalog(), conn.getSchema(), tableName);){
                    if (rsCols.next()) {
                        columnId = rsCols.getString(4).toLowerCase().trim();
                    }
                }
                rsCols = conn.getMetaData().getImportedKeys(conn.getCatalog(), conn.getSchema(), tableName);
                try {
                    while (rsCols.next()) {
                        columnsFk.put(rsCols.getString(8).toLowerCase().trim(), rsCols.getString(3).toLowerCase().trim());
                    }
                }
                finally {
                    if (rsCols != null) {
                        rsCols.close();
                    }
                }
                rsCols = conn.getMetaData().getColumns(conn.getCatalog(), conn.getSchema(), tableName, "%");
                try {
                    while (rsCols.next()) {
                        boolean notNull;
                        String columnName = rsCols.getString(4).toLowerCase().trim();
                        String fieldName = Database.database2Java(columnName, false);
                        if (columnName.endsWith("_id")) {
                            fieldName = Database.database2Java(columnName.substring(0, columnName.length() - 3), false);
                        }
                        String type = Database.type2Class(rsCols.getInt(5)).getName();
                        String columnType = ", type = " + CodeGenerate.getType(rsCols.getInt(5));
                        String label = ", label = \"" + CodeGenerate.getLabel(columnName.replace("_", " ")) + "\"";
                        boolean bl = notNull = !rsCols.getString(18).equalsIgnoreCase("yes");
                        if (type.contains("java.lang.")) {
                            type = type.replace("java.lang.", "");
                        }
                        if (!columnName.equalsIgnoreCase(columnId) && !columnsFk.keySet().contains(columnName)) {
                            content = content + "    @Column(name = \"" + columnName + "\"" + columnType + (notNull ? ", isNotNull = true" : "") + label + ")\n    private " + type + " " + fieldName + ";\n\n";
                            if (((String)toString).isEmpty() && rsCols.getInt(5) == 12) {
                                toString = "    @Override\n    public String toString() {\n        return " + fieldName + " == null ? \"" + className + " {\" + (getId() == null ? \"N\u00e3o cadastrado\" : \"ID = \" + getId()) + \"}\" : " + fieldName + ";\n    }\n";
                            }
                            getSets = (String)getSets + "    public " + type + " get" + Database.database2Java(fieldName, true) + "() {\n        return this." + fieldName + ";\n    }\n\n    public void set" + Database.database2Java(fieldName, true) + "(" + type + " " + fieldName + ") {\n        this." + fieldName + " = " + fieldName + ";\n    }\n\n";
                            continue;
                        }
                        if (columnName.equalsIgnoreCase(columnId) || !columnsFk.keySet().contains(columnName)) continue;
                        content = content + "    @Column(name = \"" + columnName + "\"" + columnType + (notNull ? ", isNotNull = true" : "") + label + ", join = " + Database.database2Java((String)columnsFk.get(columnName), true) + ".class)\n    private " + Database.database2Java((String)columnsFk.get(columnName), true) + " " + fieldName + ";\n\n";
                        if (((String)toString).isEmpty()) {
                            toString = "    @Override\n    public String toString() {\n        return " + fieldName + " == null ? \"" + className + " {\" + (getId() == null ? \"N\u00e3o cadastrado\" : \"ID = \" + getId()) + \"}\" : " + fieldName + ".toString();\n    }\n";
                        }
                        getSets = (String)getSets + "    public " + Database.database2Java((String)columnsFk.get(columnName), true) + " get" + Database.database2Java(fieldName, true) + "() {\n        return this." + fieldName + ";\n    }\n\n    public void set" + Database.database2Java(fieldName, true) + "(" + Database.database2Java((String)columnsFk.get(columnName), true) + " " + fieldName + ") {\n        this." + fieldName + " = " + fieldName + ";\n    }\n\n";
                    }
                }
                finally {
                    if (rsCols != null) {
                        rsCols.close();
                    }
                }
                content = content + (String)getSets + (String)toString + "}";
                File f = new File((String)path + File.separator + className + ".java");
                if (f.exists() && replaceExist) {
                    Utils.writeFile((String)path + File.separator + className + ".java", content, false);
                    continue;
                }
                if (f.exists()) continue;
                Utils.writeFile((String)path + File.separator + className + ".java", content, false);
            }
        }
    }

    private static String getLabel(String name) {
        Object str = "";
        boolean upper = true;
        for (char c : name.toCharArray()) {
            if (c == ' ') {
                upper = true;
                str = (String)str + " ";
                continue;
            }
            if (upper) {
                str = (String)str + String.valueOf(c).toUpperCase();
                upper = false;
                continue;
            }
            str = (String)str + String.valueOf(c).toLowerCase();
        }
        return ((String)str).replace(" Id", "");
    }

    private static String getType(int type) {
        switch (type) {
            case -5: {
                return "Types.BIGINT";
            }
            case -2: {
                return "Types.BOOLEAN";
            }
            case -7: {
                return "Types.BOOLEAN";
            }
            case 2004: {
                return "Types.BLOB";
            }
            case 16: {
                return "Types.BOOLEAN";
            }
            case 1: {
                return "Types.VARCHAR";
            }
            case 91: {
                return "Types.DATE";
            }
            case 3: {
                return "Types.DECIMAL";
            }
            case 8: {
                return "Types.DOUBLE";
            }
            case 6: {
                return "Types.FLOAT";
            }
            case 4: {
                return "Types.INTEGER";
            }
            case -16: {
                return "Types.VARCHAR";
            }
            case -1: {
                return "Types.BLOB";
            }
            case -15: {
                return "Types.VARCHAR";
            }
            case -9: {
                return "Types.VARCHAR";
            }
            case 5: {
                return "Types.BOOLEAN";
            }
            case 92: {
                return "Types.TIME";
            }
            case 93: {
                return "Types.TIMESTAMP";
            }
            case -6: {
                return "Types.BOOLEAN";
            }
            case 12: {
                return "Types.VARCHAR";
            }
        }
        return "Types.VARCHAR";
    }
}

