/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.nfe.view;

import br.com.ctecinf.autocomplete.AutoCompleteField;
import br.com.ctecinf.model.Municipio;
import br.com.ctecinf.text.NumberFormatter;
import br.com.ctecinf.text.UpperCaseFormatter;
import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public class EnderecoPanel
extends JPanel {
    private AutoCompleteField<Municipio> municipio;
    private JFormattedTextField logradouro;
    private JFormattedTextField numero;
    private JFormattedTextField complemento;
    private JFormattedTextField bairro;
    private JFormattedTextField cep;

    public EnderecoPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridLayout(6, 1));
        this.municipio = new AutoCompleteField(new Municipio().getAutoCompleteModel());
        this.setLabel(this.municipio, "Munic\u00edpio", true);
        this.add(this.municipio);
        this.logradouro = new JFormattedTextField(new UpperCaseFormatter());
        this.setLabel(this.logradouro, "Logradouro", true);
        this.add(this.logradouro);
        this.numero = new JFormattedTextField(new NumberFormatter(0));
        this.setLabel(this.numero, "N\u00famero", true);
        this.add(this.numero);
        this.complemento = new JFormattedTextField(new UpperCaseFormatter());
        this.setLabel(this.complemento, "Complemento", false);
        this.add(this.complemento);
        this.bairro = new JFormattedTextField(new UpperCaseFormatter());
        this.setLabel(this.bairro, "Bairro", true);
        this.add(this.bairro);
        this.cep = new JFormattedTextField(new NumberFormatter(0));
        this.setLabel(this.cep, "CEP", false);
        this.add(this.cep);
    }

    public void setLabel(JComponent component, String label, boolean notNull) {
        component.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, " " + (notNull ? "* " : "") + label + " ", 0, 0, component.getFont().deriveFont(1), notNull ? Color.RED : Color.BLACK), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
    }

    public AutoCompleteField<Municipio> getMunicipio() {
        return this.municipio;
    }

    public JFormattedTextField getLogradouro() {
        return this.logradouro;
    }

    public JFormattedTextField getNumero() {
        return this.numero;
    }

    public JFormattedTextField getComplemento() {
        return this.complemento;
    }

    public JFormattedTextField getBairro() {
        return this.bairro;
    }

    public JFormattedTextField getCep() {
        return this.cep;
    }
}

