/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.nfe.view;

import br.com.ctecinf.Config;
import br.com.ctecinf.Daruma;
import br.com.ctecinf.Email;
import br.com.ctecinf.Empresa;
import br.com.ctecinf.Utils;
import br.com.ctecinf.nfe.Controller;
import br.com.ctecinf.nfe.DanfePDF;
import br.com.ctecinf.nfe.SEFAZConnection;
import br.com.ctecinf.swing.Image;
import br.com.ctecinf.swing.OptionPane;
import br.com.ctecinf.swing.PleaseWaitDialog;
import br.com.ctecinf.table.Table;
import br.com.ctecinf.table.TableModel;
import br.com.ctecinf.text.MaskFormatter;
import br.com.ctecinf.text.UpperCaseFormatter;
import br.inf.portalfiscal.nfe.v100.evento.TRetEnvEvento;
import br.inf.portalfiscal.nfe.v310.autorizacao.TNfeProc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EmitidasPanel
extends JPanel
implements ActionListener {
    private static final String LABEL_CANCELAR = "Cancelar NFC-e";
    private static final String LABEL_IMPRIMIR = "Imprimir";
    private static final String LABEL_EMAIL = "Enviar por email";
    private static final String LABEL_VISUALIZAR = "Visualizar NFC-e";
    private static final String LABEL_XML = "Arquivo XML";
    private Table table;

    public EmitidasPanel() {
        super(new BorderLayout());
        this.initUI();
    }

    private void initUI() {
        try {
            TableModel model = Controller.getNFCeEmitidas();
            this.table = new Table(model);
            this.add((Component)new JScrollPane(this.table), "Center");
        }
        catch (Exception ex) {
            OptionPane.error(ex);
        }
        JPanel pButton = new JPanel(new FlowLayout(2));
        JButton button = new JButton(LABEL_CANCELAR, Image.parse("iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAAN1wAADdcBQiibeAAAAAd0SU1FB9wJGxcwGPZj30sAAAUCSURBVFjD7ZdtiFRVGMd/d/bOy86MO3fdN3fXnVVUsrbVlRTRLNFKrMDSIohKCCIxiAqlIIIIIvBL9SUC6YPYhyKyF0sMQtPQBQuz2hZDbdN9mV2dWWdmZ3bv3nvPSx9mdle22dzcjb544HDgvpz/7zzPc87zHLjZ/udm/NsfvoQ5Vc3VL/oMY63WulZD0GeQQumfxYi95+7USP9/AnBsQdXOQCj0WqTGqqtbWF8WDgcwlUY7Lp49ykh2mGTfoLaH7bRWat+aS1d3zQrAt5WR1nBN7HDDHbc01i+ZD66Hdlz02Oi4IARaSLQUaCEYvJyhvy+TMw1z++qeK1/cMMCxRuupaH3NBy0PrgkYWoMn0J6Hdj1wPLTror2CqC5CIMQ4SFdXUudd+d76nvTzU2mUTfXi+LyK7dVL4vtuvW+liVIFcSHAFUWQQkcpkLIwKolWEi0VadfBXxEyQlKv2loeaPwwa381bYDDkcCyynjdwaX3rPAjZEFYFAW9iRGl0EqhxwCkIjEywv7+Xj5KDnA0k6a2vsZoJNCyymd0H8yP/jpZy1cKIFo159DS9cuDetQd97N2xszuFSBkYaVINQ7yfSrJW13n6cjn0Low14Hui7hxK7QoUv52I1Rd1wJH5oafWbB88RNRK2IgJXhyYvVCgJAT4mMmV4ovE30cGEigJs2ngT9yQ2xpvS28ZNhd+Fl2+NNr35uTAUKR0Os1DVWGHnWKM2hQGrRGq4nVIlXR35JvBhIcujIwZTAnbZszTo6mWHgjEAculXTBJxALV5TPG4v08S7EpF7cclJyajDF5/2J6+73k7091DfXzt1RY22ZMgaqK0PP1TbWmNorJTomLKEo3p5Ksq/nEnoaB86ldJpwc52xwYpuA2IlXWD6zdXhcj9aCLJ5j+yCFQStiglnAhqNUIqMJzCbBE+3XV/8zx9PcmSgkwHlEA36q4FaIPs3AG0YDT4UWiiU0jS9/CrheHzGCSf55FYY6CTjOISC/jAQLmkBwzBM7QkwQAuFEALP82YMoFXBfAoD019mAKGSAFqqpHQ9fGUGnqvo+forAvXzZgwgUoMAxGJzGPT6Rq+NvUkW0L+N5OxNkWiAjLJ5/+3ds5LzhVE4caoti16hhwCnJEA+p95JpYZeCocsY8hzGTZnr/CotWL4k3nOOM5RwC65DR+w7V7b9q4iBJ6Us1r5rG69jf7zvbk3f+9uB1JT5gIh2Z/JjFBpGLMmXh4MsrHldhLZ4Q5AAINTAtx1eWhXImXnGkw/vlmCeGzTBnqOd+Rf+KXrXaAbJlKGr0SFonWZ/9krl/Py0camGYvfuaKVW31R9VPy6qfdtp0DLlw3Hd+dSH+c8dh7uwzJrfFmbtQOa9taeWTFSs6cOtu+8/S5A0An4E6rItqfcw5tUqp6cSDS1raoybyQzWJLMS3hUDDA4/ffy7rKBnX6+C/t20517gEuTl79PwIAfJQbPby6rCxlDTlrH2prKbdicxhyXYYcp+T31RUVbFjZxo7NmxE/d+dPnOv+ePsPZ/cWxTtvuCxfBrWvxOs+iFuRdQ0L51nm/LlGv+eQdhwUMLcyRo0VI3h1lP5zPcOJdK5jd+ef71zI21ngbDHwZnwx8QHNLzRUP7ouGno4XB60gqYZ9vnLDFdI2xYq1+HJ797o7DohwQN6gPOTfT7jm1HxnxhQV8xqoeIzp3jCpYpd3bx4Tqf9BTLX0Cl4ZigWAAAAAElFTkSuQmCC", 24));
        button.addActionListener(this);
        pButton.add(button);
        button = new JButton(LABEL_IMPRIMIR, Image.parse("iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAAN1wAADdcBQiibeAAAAAd0SU1FB9wJGxctMtK0eoEAAAiKSURBVFjDpZdrbBzVFcd/M3NnZndnvV7Hz/i5dpzEVFUSRzWRSdQPBUWFIgFNaWlEQ0WVSHyI1A8gpAraSG2lqqhfqiipTFsgJSISar+AojxEUes8hMEmgTh+xDhxYsfxZne9Xq93Z+fZD7YHGygoyZXO7p3V3fv/n/8959wzEncxHn74z7H5+YWtiqJ+N5ezDn/88a9uc5dD+qYFzz77t7Js1u4Mh8V2IZQHSyV7vWFo+n331WvxeCT+1lsfXs5mhzr7+3vsuyEgVj48//wRw7ZFpyQpD6iq8qBp2htDIS3U1VWttm+oq2hbVy2trYsjyyDLoEgQDqutBw8WXwJ+c08KvPDCP7fattN///2JTEuiuqKhaY20prIc3wfPBx8WPySQpEVwRQZJ8nl455+up1IL6wcHD1h3SkBenrzyyq6BSET7z5atifimzlapvKKckgNFG4rWktlgWktmL5rtSjz5422Vtu3uuRsF5JUPuZy5+43Xzt5eML1VYMvzZSLL4KUl+/6jnUY4rO29ZwIHD/70ZrFov/HRh1edZeCi9Tl44PmKecmGsvIokiw3wgH5nggAZLPmH0+8M5AKgFYewUpgZ9HyCybDw0Ns3uyW79uXOrN///4j95yGv9j35rtPPfvID8qrKnBc8DzwlhbPZ2dI3xondfMzCrkZKiuiNDU1UVVVhWEYvPfee/7Q0NAmIO953mxPT8/cHRP44ZN/+cmO733n71se+HYkeWuC5NQYmelxBAs0N9XT3t5OIpFAVVXS6TS2bQd269Ytrly5gmEYmKZJMpmcTKVSRyVJOtTT03P9Gwns3bt3CyjPCxF5qq2tXmlra6W9vZ1169ZhGAa5XI5MJkOhUMCyLHzfB0BRFCRpcTvHcfA8L9gznU7T19dn3bhx43f19fW/P3DggPd/Cezbt+/Qnj17nuvs7CQSiQBgmiaZTIa5uTk8z0MIgaIoAajneTiOg2VZ2La9ClxRFHRdR9d1PvnkE06dOvVOKpV64u2333YBlC8S6OrqWmhubv55VVUVpmkyPT2NaZoIIYjFYsRiMVRVRdM0fN/HsixM06RYLOI4TqCIEIJwOIxhGBiGgRCChoYGysrKNk5MTEQHBgZOrVJg7969uwzD+GVjY+P2WCwm1dbWsm3bNqqrqwPPfN/Hdd1AEdM0vxQ/mqYFHquq+pWBd+zYMW9sbGz94cOHx5Ul8F+3tbUdfuihh5qbm5uleDyO53lcuHCBmZkZ1q9fD4DrujiOw/T0NLa9+u7RdT3wNhQKoSifiytJErquE4lEiEajJBIJ6eTJk+mLFy/+V+zfv1+PGMZLO3fuDM5xWcKamhoymQxHjhzhmWeewXEcCoUCrusuFhFZDrzVdR1Z/rysqKoa/C6EIJvNBhljWRau694PIAqFgtHU1KSWxWJYloW8AgAgEongeR5Hjx7l6aefJp/PYxgGmqYFthxsmqYF8SHLMrlcjqmpKSzLWvUfAN/3DUARiqKYtm0jhMDzPDRdx/M8PM/Dtu1Avvn5eXp7e+nu7kYIgaZpCCFQVRUhROC9ZVlcvXqVQqGApmlEo1FCodDqHmBxfQRQ5Z6enoLjOMiKghBi0ZbkWxlEoVCIsbExstkslZWVlJeXB17JsszU1BT9/f1cunQJIQSVlZWUlZUFtWHl8H0fVVVDgCKW8nxBEcLwfR/huqiqiuM4hEIhisVisImiKPT29rJr1y4A5ubmGB8fx7IsKioqqK+vD9Lwi8PzPPL5fKCooigaIAmAUqlkFQsFQw+FUIRYRUIIEQQmQCaT4cSJE0FNSCQSQfVzHOdLwIVCIagj4XA4UDUUCkUAsUwgn7x9uyI7O0s0GqWurg6hqqiOE6TTSim3bdtGWVlZAPrFlPR9n0wmg+u6RKNRMpkMAwMDOI7D7t27l9NWB2QBYNt2dv3GjU2+55FKJhkZGcF1HNbW139lMVmZJStHPp8nm80ihEDXdUZHR+nv7yedTgPQ0NDAEh6SJKkBAd/3iz4gC0FFVRVbYjGKxSKjIyOkUylcxyEcDq+6bFae7eTkJKVSiXA4jCzLXLlyhYmJCUzTRJIkotEopVKJUqnE2bNnOXfuXG5wcPCvwRFIkmQiSSiKgreUjrqus2HjRgqNjXx68SLJZDLIBtd1mZub4/r160iSRE1NDclkkomJCfL5PKZpUl5eTigUolQqoes68XictWvXkkwmicfjsZaWlid27979r+W2/PqV4WG+tWkTQgh838f3fYTnEQqHWbNmTRCMs7OzjI6O0tLSQkdHB67rks1mKZVKwaUDEA6HiUQi6LqO7/s4joPruliWhaZpSJJ0NR6PT4ulwvDca6++OlpTW/vio489ZrRv2IBQ1aAgVaxZQy6XQ5IkysrKSCQSNDU1BUfhui7pdDrwMhKJBPfG8ncymaSvr4/h4eG+wcHBN/r7+weBkgA4dOhQHvhtV1fX65+Njb2UaG392fcfeSTcvmEDqqZRWVPD1ORkEO2u667KClmWSSaT1NbWBv2Boij4vs+NGzc4f/48Q0NDH42MjBzp6+v7FLi+ZM6qfuDmzZu5y5cvv1syzWNXx8djw5cvdxjRqKiqrl5sWGdn8TyPxsZGKisrA4Xm5+fJ5XKUl5cjSRKSJDExMcHx48c5ffr0wPnz5/9w/PjxN6empvqBS0CaxTbz698Nu7u7O5qbm19ubGz8Uff27VqxUMAsFunu7qajo4NUKsXJkyc5c+bMZKlUSjU2Nm5OJBLS1NQU4+PjF0dHR1//4IMPLgCTSx5bd/xyulR4NrW2tr5cVVX1eF1dnejq6mJmZobe3t7Ja9eu/eP999//t+M4tzZv3hxvbm5+PJ1O3zx37tzHS8ATXwV8RwSW1+7YsWNrQ0PDi6qqJmZmZk4vAc8A14D8ij3jwMLXAS+P/wFbaEVOGZb8ywAAAABJRU5ErkJggg==", 24));
        button.addActionListener(this);
        pButton.add(button);
        button = new JButton(LABEL_EMAIL, Image.parse("iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAAN1wAADdcBQiibeAAAAAd0SU1FB9wJHAAUEfrpCwUAAAP1SURBVFjD7ZZbbJRVEMd/Z2/d3ra7tGzaUq0tYkNCBMUSqhFRg5iGBjXVROXBGAkSE30yPvDkE9GHamLQatQEUiHaqkiaNG0kAYs0saAlcQsFtaktayktZc12L939zvjw7X23CaiEl05yvnPOzDnznzMzmW9gmZZpmW4zqeTi+Sen9oC8LminKAEElKDRmHtzFgRRGsmQQ4KPBkv2GVE6Q5eA0kHQ+wZ6Hu0FsAG8tHXcHUUOvPXOSqu31o4WUkMEtAhawNBkydLy3CFLyi6MznK023cIWAtcsQEs2IpcVmLWcEhwllgKKAStuTn+EvJo1EAp5QHuA/otZgDCiBIO7L/CT6eCtwz89A+TDJ2aAIskvW81DSiGsnLFm/trONkfoO+b+f8V3DCEvmOXmL8WYs8bLVSuLE0loSW5sDuh5k4Hr+2rZdofpevjaeKL8p/Bo4uani98FJfa2LajCa0UWHS+AYIJZrEpXni1Gk+Vjc6OPwmFjH8NHgzG6Pr8HA33rODBRxowEokpQr4BGsnK7G07q2je4ubDd8eZm128afC52TCHPh1h00N13LuxNgWuxcRKki1ti85Tsr65ApfHzmcfjPP0i3Xc0VB6Q+CTE39ztPs8rU81sarenQVuCGa9yAuBKvxCd6Udq0NxrPsyg8dnCtaC5L1YXDjx/QRfdvnwVDmpXuXKBxcShS3LgEgqBzLHX/4In7z/Ow+31tK+dw0Tk2E6O3yMjV5PG6IhEjX4eXiazveG8c9EaHt5E2VeN0e6RgiHYlngWsx8ywuBVjoL/LexBb4+PEXbrrtwe51ogceeqefyRJCh09N81/0H5W47i1GDQDBCdb2bza1rcXvLMQSaNtZTXFHMkYPDtD27AZe7JFVNpXAOpD3wy/B1jvfN0L67kRKXHUOTGt66Mh5vvxutIRSOIyiUzZo+I+mz1Q1eHGVOer46y/bWdXhrPGYIyAlBBMyfhcCJgav8eHKW5/auzgZPxlGbbjcEbA4bymY19zngyXWZx8UD25sZ6B/l0pjfDIUq4IH5a1E63r5IhbeI9t2rEaWWVpyxT8bXSORDipdhqMPp5P4nNnNm8CznL0wRCAQL14GaxhLadtVDEjwjy2/UkFzw5F2sVtZtaSZCEbF4LNsAkZghCBtaqrJelOt+XUCxznm9sdR9DVoratc0IqLjWSHo7V3v37HzzNDhjy62VFY7zSYkEatky6FFSDYqWszmItFymLyMIWLyDGWuJTFrhGAgQDjoH8zJASXFDt/WX88dfEWPRFfojEpFYp3iWTJ56W+qmlpy7yW+CX4sthDx+74dA+aAuMpp0axAVWZu3CLSwNUc65dpmW4P/QMSv72Fv0gXzAAAAABJRU5ErkJggg==", 24));
        button.addActionListener(this);
        pButton.add(button);
        button = new JButton(LABEL_VISUALIZAR, Image.parse("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", 24));
        button.addActionListener(this);
        pButton.add(button);
        button = new JButton(LABEL_XML, Image.parse("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", 24));
        button.addActionListener(this);
        pButton.add(button);
        this.add((Component)pButton, "North");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.table.getSelectedRow() == -1) {
            OptionPane.alert("Selecione uma NFC-e na lista.");
            return;
        }
        String versao = (String)this.table.getValueAt(this.table.getSelectedRow(), 1);
        String cancel = String.valueOf(this.table.getValueAt(this.table.getSelectedRow(), 3));
        String inut = String.valueOf(this.table.getValueAt(this.table.getSelectedRow(), 4));
        String path = (String)this.table.getValueAt(this.table.getSelectedRow(), 6);
        String xml = (String)this.table.getValueAt(this.table.getSelectedRow(), 8);
        File file = new File(path);
        if (!file.exists()) {
            try {
                Utils.writeFile(path, xml);
            }
            catch (IOException ex) {
                OptionPane.error(ex);
                return;
            }
        }
        switch (e.getActionCommand()) {
            case "Cancelar NFC-e": {
                this.cancel(cancel, inut);
                break;
            }
            case "Enviar por email": {
                this.email(path, file, versao, cancel, inut);
                break;
            }
            case "Imprimir": {
                this.print(cancel, path, versao, inut);
                break;
            }
            case "Visualizar NFC-e": {
                this.view(path, cancel, inut);
                break;
            }
            case "Arquivo XML": {
                try {
                    Desktop.getDesktop().open(file);
                    break;
                }
                catch (Exception ex) {
                    OptionPane.error(ex);
                }
            }
        }
    }

    private void cancel(String cancel, String inut) {
        if (inut.equalsIgnoreCase("NFC-e INUTILIZADA")) {
            OptionPane.info("NFC-e com numera\u00e7\u00e3o inutilizada.");
            return;
        }
        if (cancel.equalsIgnoreCase("sim")) {
            OptionPane.info("NFC-e j\u00e1 cancelada.");
            return;
        }
        final String chave = String.valueOf(this.table.getValueAt(this.table.getSelectedRow(), 4));
        final String just = OptionPane.input("Justificativa NFC-e " + String.valueOf(this.table.getValueAt(this.table.getSelectedRow(), 2)), null, new UpperCaseFormatter());
        if (just != null) {
            new PleaseWaitDialog(this){
                final /* synthetic */ EmitidasPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public Object exec() throws Exception {
                    return SEFAZConnection.enviarEventoCancelamento(chave, just);
                }

                public void end(Object result) {
                    if (result != null) {
                        TRetEnvEvento ret = (TRetEnvEvento)result;
                        OptionPane.info(ret.getRetEvento().get(0).getInfEvento().getCStat() + ": " + ret.getRetEvento().get(0).getInfEvento().getXMotivo());
                    }
                }
            }.start();
        }
    }

    private void email(final String path, final File file, final String versao, String cancel, String inut) {
        if (inut.equalsIgnoreCase("NFC-e INUTILIZADA")) {
            OptionPane.info("NFC-e com numera\u00e7\u00e3o inutilizada.");
            return;
        }
        if (cancel.equalsIgnoreCase("sim")) {
            OptionPane.info("NFC-e cancelada.");
            return;
        }
        final String email = OptionPane.input("Email do destinat\u00e1rio", null, null);
        if (email == null) {
            return;
        }
        new PleaseWaitDialog(this){
            final /* synthetic */ EmitidasPanel this$0;
            {
                this.this$0 = this$0;
            }

            public Object exec() throws Exception {
                File pdf = DanfePDF.createFile(path);
                String msg = "Segue em anexo o arquivo XML da sua NFC-e emitida por " + Empresa.getRazaoSocial() + "\n\n";
                if (versao.trim().equalsIgnoreCase("4.00")) {
                    br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc nfe = Utils.unmarshaller(br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc.class, Utils.readFile(path));
                    msg = msg + "Link para visualizar a NFC-e diretamente no site da SEFAZ.\n";
                    msg = msg + nfe.getNFe().getInfNFeSupl().getQrCode() + "\n\n";
                }
                msg = msg + "Att,\n" + Empresa.getRazaoSocial() + "\nCNPJ " + MaskFormatter.format(Empresa.getCnpj(), "##.###.###/####-##") + "\nFone: " + MaskFormatter.format(Empresa.getFone(), "(##) ####-####");
                Email.send(email, "NFC-e de " + Empresa.getRazaoSocial(), msg, file, pdf);
                return true;
            }

            public void end(Object result) {
                if (result != null && ((Boolean)result).booleanValue()) {
                    OptionPane.success("Email enviado com sucesso.");
                }
            }
        }.start();
    }

    private void print(String cancel, String path, String versao, String inut) {
        if (inut.equalsIgnoreCase("NFC-e INUTILIZADA")) {
            OptionPane.info("NFC-e com numera\u00e7\u00e3o inutilizada.");
            return;
        }
        try {
            if (cancel.equalsIgnoreCase("sim")) {
                Object p = new Daruma();
                ((Daruma)p).iniciarCond();
                ((Daruma)p).tamanhoFonte(4);
                ((Daruma)p).alinharCentro();
                ((Daruma)p).negrito("NFC-e CANCELADA");
                ((Daruma)p).novaLinha();
                ((Daruma)p).alinharCentro();
                ((Daruma)p).negrito("SEM VALOR FISCAL");
                ((Daruma)p).novaLinha();
                ((Daruma)p).end();
            }
            switch (versao) {
                case "3.10": {
                    TNfeProc nfe = Utils.unmarshaller(TNfeProc.class, Utils.readFile(path));
                    Daruma.danfeNFCe(nfe, Config.get("nfe.amb").equals("1") ? Empresa.getCscTokenProd() : Empresa.getCscTokenHomo());
                    break;
                }
                case "4.00": {
                    br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc nfe = Utils.unmarshaller(br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc.class, Utils.readFile(path));
                    if (!nfe.getNFe().getInfNFe().getIde().getIndFinal().equals("1")) break;
                    Daruma.danfeNFCe4(nfe);
                    break;
                }
            }
        }
        catch (Exception ex) {
            OptionPane.error(ex);
        }
    }

    private void view(final String path, String cancel, String inut) {
        if (inut.equalsIgnoreCase("NFC-e INUTILIZADA")) {
            OptionPane.info("NFC-e com numera\u00e7\u00e3o inutilizada.");
            return;
        }
        if (cancel.equalsIgnoreCase("sim")) {
            OptionPane.info("NFC-e cancelada.");
            return;
        }
        new PleaseWaitDialog(this){
            final /* synthetic */ EmitidasPanel this$0;
            {
                this.this$0 = this$0;
            }

            public Object exec() throws Exception {
                return DanfePDF.createFile(path);
            }

            public void end(Object result) {
                if (result != null) {
                    try {
                        Desktop.getDesktop().open((File)result);
                    }
                    catch (Exception ex) {
                        OptionPane.error(ex);
                    }
                }
            }
        }.start();
    }
}

