/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.nfe.view;

import br.com.ctecinf.text.MaskFormatter;
import br.inf.portalfiscal.nfe.v400.autorizacao.TNFe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfirmarPanel
extends JPanel {
    private final TNFe nfe;
    private static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)DecimalFormat.getNumberInstance(new Locale("pt", "BR"));

    public ConfirmarPanel(TNFe nfe) {
        super(new BorderLayout());
        this.nfe = nfe;
        this.initUI();
    }

    private void initUI() {
        this.add((Component)new JLabel("Confere as informa\u00e7\u00f5es descritas acima?"), "South");
        JEditorPane editor = new JEditorPane("text/html", this.danfeHTML());
        editor.setEditable(false);
        editor.setBackground(new Color(255, 250, 198));
        this.add((Component)editor, "Center");
    }

    private String head() {
        String cnpj = this.nfe.getInfNFe().getEmit().getCNPJ();
        String razaoSocial = this.nfe.getInfNFe().getEmit().getXNome();
        Object endereco = this.nfe.getInfNFe().getEmit().getEnderEmit().getXLgr();
        endereco = (String)endereco + (String)(this.nfe.getInfNFe().getEmit().getEnderEmit().getNro() != null ? ", " + this.nfe.getInfNFe().getEmit().getEnderEmit().getNro() : "");
        endereco = (String)endereco + (String)(this.nfe.getInfNFe().getEmit().getEnderEmit().getXCpl() != null ? " - " + this.nfe.getInfNFe().getEmit().getEnderEmit().getXCpl() : "");
        endereco = (String)endereco + (String)(this.nfe.getInfNFe().getEmit().getEnderEmit().getXBairro() != null ? ", " + this.nfe.getInfNFe().getEmit().getEnderEmit().getXBairro() : "");
        endereco = (String)endereco + (String)(this.nfe.getInfNFe().getEmit().getEnderEmit().getXMun() != null ? ", " + this.nfe.getInfNFe().getEmit().getEnderEmit().getXMun() : "");
        endereco = (String)endereco + " - " + this.nfe.getInfNFe().getEmit().getEnderEmit().getUF().value();
        return "<p align=\"center\">CNPJ " + MaskFormatter.format(cnpj, "##.###.###/####-##") + " <b>" + razaoSocial + "</b><br />\n" + (String)endereco + "<br />\nDANFE NFC-e - Documento Auxiliar<br />\nda Nota Fiscal de Consumidor Eletronica</p><br />\n";
    }

    private String produtos() {
        Object str = "";
        for (TNFe.InfNFe.Det det : this.nfe.getInfNFe().getDet()) {
            TNFe.InfNFe.Det.Prod prod = det.getProd();
            String cod = prod.getCProd();
            String desc = prod.getXProd();
            String qtde = prod.getQCom();
            String und = prod.getUCom();
            String vlUnit = DECIMAL_FORMAT.format(Double.parseDouble(prod.getVUnCom()));
            String total = DECIMAL_FORMAT.format(Double.parseDouble(prod.getVProd()));
            str = (String)str + "                <tr>\n                    <td>" + cod + "</td><td>" + desc + "</td><td>" + qtde + "</td><td>" + und + "</td><td align=\"right\">" + vlUnit + "</td><td align=\"right\">" + total + "</td>\n                </tr>\n";
        }
        return str;
    }

    private String pagamentos() {
        Object str = "";
        for (TNFe.InfNFe.Pag.DetPag detPag : this.nfe.getInfNFe().getPag().getDetPag()) {
            String desc = this.getDescPagto(detPag.getTPag());
            String valor = DECIMAL_FORMAT.format(Double.parseDouble(detPag.getVPag()));
            str = (String)str + "                <tr>\n                    <td align=\"left\">" + desc + "</td><td align=\"right\">" + valor + "</td>\n                </tr>\n";
        }
        return str;
    }

    private String getDescPagto(String tPag) {
        switch (tPag) {
            case "01": {
                return "Dinheiro";
            }
            case "02": {
                return "Cheque";
            }
            case "03": {
                return "Cartao de Credito";
            }
            case "04": {
                return "Cartao de Debito";
            }
            case "05": {
                return "Credito Loja";
            }
            case "16": {
                return "Deposito Bancario";
            }
            case "17": {
                return "Pix";
            }
        }
        return "Outros";
    }

    private String danfeHTML() {
        String str = "<html>\n<div style=\"width:320px;font-size:9px\">\n            \n" + this.head() + "            \n            <table style=\"width:100%;font-size:8px\">\n                <tr>\n                    <th width=\"10%\" align=\"left\">C\u00f3d.</th><th width=\"40%\" align=\"left\">Descri\u00e7\u00e3o</th><th width=\"10%\" align=\"left\">Qtde.</th><th width=\"10%\" align=\"left\">UN</th><th width=\"15%\" align=\"right\">Vl. Unit.</th><th width=\"15%\" align=\"right\">Vl. Total</th>\n                </tr>\n" + this.produtos() + "            </table>\n            \n            <table style=\"width:100%;font-size:9px\">\n                \n                <tr>\n                    <td align=\"left\">Qtde. total de itens</td><td align=\"right\">" + this.nfe.getInfNFe().getDet().size() + "</td>\n                </tr>\n                \n                <tr>\n                    <td align=\"left\">Valor total R$</td><td align=\"right\">" + DECIMAL_FORMAT.format(Double.parseDouble(this.nfe.getInfNFe().getTotal().getICMSTot().getVProd())) + "</td>\n                </tr>\n                \n                <tr>\n                    <td align=\"left\">Desconto R$</td><td align=\"right\">" + DECIMAL_FORMAT.format(Double.parseDouble(this.nfe.getInfNFe().getTotal().getICMSTot().getVDesc())) + "</td>\n                </tr>\n                \n                <tr>\n                    <th align=\"left\">Valor \u00e0 pagar R$</th><th align=\"right\">" + DECIMAL_FORMAT.format(Double.parseDouble(this.nfe.getInfNFe().getTotal().getICMSTot().getVNF())) + "</th>\n                </tr>\n                \n            </table>\n            \n            <table style=\"width:100%;font-size:9px\">\n                \n                <tr>\n                    <td align=\"left\">FORMA PAGAMENTO</td><td align=\"right\">VALOR PAGO R$</td>\n                </tr>\n                \n" + this.pagamentos() + "                \n            </table>\n            \n            <table style=\"width:100%;font-size:9px\">\n                \n                <tr>\n                    <td align=\"left\">Troco R$</td><td align=\"right\">" + DECIMAL_FORMAT.format(this.nfe.getInfNFe().getPag().getVTroco() == null ? "0" : Double.valueOf(Double.parseDouble(this.nfe.getInfNFe().getPag().getVTroco()))) + "</td>\n                </tr>\n                \n            </table>\n            \n";
        if (this.nfe.getInfNFe().getDest() != null) {
            String nome = this.nfe.getInfNFe().getDest().getXNome();
            if (this.nfe.getInfNFe().getDest().getCPF() != null) {
                String cpf = this.nfe.getInfNFe().getDest().getCPF();
                str = str + "<p align=\"center\"><b>CONSUMIDOR - CPF " + MaskFormatter.format(cpf, "###.###.###-##") + "</b>";
            } else if (this.nfe.getInfNFe().getDest().getIdEstrangeiro() != null) {
                String idEstrangeiro = this.nfe.getInfNFe().getDest().getCPF();
                str = str + "<p align=\"center\"><b>CONSUMIDOR - ID ESTRANGEIRO " + idEstrangeiro + "</b>";
            }
            if (nome != null && !nome.isEmpty()) {
                str = str + "<br />" + nome;
            }
            str = str + "</p>";
        } else {
            str = str + "<p align=\"center\"><b>CONSUMIDOR N\u00c3O IDENTIFICADO</b></p>";
        }
        str = str + "</div>";
        return str;
    }

    static {
        DECIMAL_FORMAT.setMinimumFractionDigits(2);
        DECIMAL_FORMAT.setMaximumFractionDigits(2);
    }
}

