/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.nfe;

import br.com.ctecinf.Config;
import br.com.ctecinf.Daruma;
import br.com.ctecinf.Empresa;
import br.com.ctecinf.Utils;
import br.com.ctecinf.nfe.Controller;
import br.com.ctecinf.nfe.NFCe;
import br.com.ctecinf.nfe.PKCS11;
import br.com.ctecinf.nfe.Signature;
import br.com.ctecinf.swing.OptionPane;
import br.com.ctecinf.text.MaskFormatter;
import br.inf.portalfiscal.nfe.v100.evento.TEnvEvento;
import br.inf.portalfiscal.nfe.v100.evento.TEvento;
import br.inf.portalfiscal.nfe.v100.evento.TProcEvento;
import br.inf.portalfiscal.nfe.v100.evento.TRetEnvEvento;
import br.inf.portalfiscal.nfe.v400.autorizacao.TEnviNFe;
import br.inf.portalfiscal.nfe.v400.autorizacao.TNFe;
import br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc;
import br.inf.portalfiscal.nfe.v400.autorizacao.TRetEnviNFe;
import br.inf.portalfiscal.nfe.v400.inutilizacao.TInutNFe;
import br.inf.portalfiscal.nfe.v400.inutilizacao.TProcInutNFe;
import br.inf.portalfiscal.nfe.v400.inutilizacao.TRetInutNFe;
import br.inf.portalfiscal.nfe.v400.status.TConsStatServ;
import br.inf.portalfiscal.nfe.v400.status.TRetConsStatServ;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SEFAZConnection {
    private static boolean REGISTRADO = false;
    private static boolean DEBUG = true;

    private static String chaveAcesso(TNFe nfe) {
        TNFe.InfNFe.Ide ide = nfe.getInfNFe().getIde();
        Calendar dt = Utils.dateNFe2Date(ide.getDhEmi());
        String yy = String.valueOf(dt.get(1));
        String mm = Utils.leftPad2(dt.get(2) + 1, 2, '0');
        String dataAAMM = yy.substring(2) + mm;
        StringBuilder chave = new StringBuilder();
        chave.append(Utils.leftPad2(ide.getCUF(), 2, '0'));
        chave.append(Utils.leftPad2(dataAAMM, 4, '0'));
        chave.append(Utils.leftPad2(nfe.getInfNFe().getEmit().getCNPJ(), 14, '0'));
        chave.append(Utils.leftPad2(ide.getMod(), 2, '0'));
        chave.append(Utils.leftPad2(ide.getSerie(), 3, '0'));
        chave.append(Utils.leftPad2(ide.getNNF(), 9, '0'));
        chave.append(Utils.leftPad2(ide.getTpEmis(), 1, '0'));
        chave.append(ide.getCNF());
        return chave.toString();
    }

    private static String qrCode(String chaveAcesso, String tpAmb, String cscToken) throws NoSuchAlgorithmException {
        StringBuilder params = new StringBuilder();
        params.append(chaveAcesso.replace("NFe", "")).append("|");
        params.append("2|");
        params.append(tpAmb).append("|");
        params.append("1");
        params.append(cscToken);
        return "https://www.sefaz.rs.gov.br/NFCE/NFCE-COM.aspx?p=" + params.toString().replace(cscToken, "") + "|" + Utils.sha1(params.toString()).toUpperCase();
    }

    public static void registrarConexao(boolean debug) throws Exception {
        REGISTRADO = true;
        DEBUG = debug;
        if (DEBUG) {
            System.out.println("Registrando conex\u00e3o com SEFAZ...");
        }
        PKCS11.load();
        if (DEBUG) {
            System.out.println("Conex\u00e3o com SEFAZ registrada!");
        }
        TRetConsStatServ ret = SEFAZConnection.consultarStatusServico();
        if (DEBUG) {
            System.out.println(ret.getXMotivo());
        }
    }

    public static TRetConsStatServ consultarStatusServico() throws Exception {
        if (!REGISTRADO) {
            SEFAZConnection.registrarConexao(DEBUG);
        }
        TConsStatServ statServ = new TConsStatServ();
        statServ.setVersao("4.00");
        statServ.setCUF(String.valueOf(Empresa.getUfIBGE()));
        statServ.setTpAmb(Config.get("nfe.amb"));
        statServ.setXServ("STATUS");
        String xml = Utils.marshaller(statServ);
        URL url = new URL(statServ.getTpAmb().equals("1") ? "https://nfce.sefazrs.rs.gov.br/ws/NfeStatusServico/NfeStatusServico4.asmx" : "https://nfce-homologacao.sefazrs.rs.gov.br/ws/NfeStatusServico/NfeStatusServico4.asmx");
        if (DEBUG) {
            System.out.println("\nAguardando resposta SEFAZ...\n\n" + xml);
        }
        SOAPMessage response = SEFAZConnection.sendXML(xml, "http://www.portalfiscal.inf.br/nfe/wsdl/NFeStatusServico4", url);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        response.writeTo((OutputStream)out);
        int begin = out.toString().indexOf("<nfeResultMsg xmlns=\"http://www.portalfiscal.inf.br/nfe/wsdl/NFeStatusServico4\">");
        int end = out.toString().indexOf("</nfeResultMsg>");
        String result = null;
        if (begin > -1 && end > begin) {
            result = out.toString().substring(begin, end).replace("<nfeResultMsg xmlns=\"http://www.portalfiscal.inf.br/nfe/wsdl/NFeStatusServico4\">", "");
        }
        if (DEBUG) {
            System.out.println("\nResposta SEFAZ: " + result);
        }
        return Utils.unmarshaller(TRetConsStatServ.class, result);
    }

    public static TRetEnviNFe enviarNFe(TNFe nfce) throws Exception {
        TRetEnviNFe retEnviNFe;
        Long nnf = Controller.getNextNNF();
        nfce.getInfNFe().getIde().setNNF(nnf.toString());
        TEnviNFe enviNFe = new TEnviNFe();
        enviNFe.getNFe().add(nfce);
        enviNFe.setVersao("4.00");
        enviNFe.getNFe().get(0).getInfNFe().setVersao("4.00");
        enviNFe.getNFe().get(0).getInfNFe().getIde().setVerProc("NFCe2308");
        enviNFe.setIdLote(nnf.toString());
        enviNFe.setIndSinc("1");
        int tpAmb = Integer.parseInt(enviNFe.getNFe().get(0).getInfNFe().getIde().getTpAmb());
        TNFe.InfNFe.Ide ide = enviNFe.getNFe().get(0).getInfNFe().getIde();
        String dhEmi = Utils.date2NFe();
        enviNFe.getNFe().get(0).getInfNFe().getIde().setDhEmi(dhEmi);
        Object chave = SEFAZConnection.chaveAcesso(enviNFe.getNFe().get(0));
        if (DEBUG) {
            System.out.println("\nChave de acesso: " + (String)chave);
        }
        enviNFe.getNFe().get(0).getInfNFe().getIde().setCDV(String.valueOf(Utils.modulo11((String)chave)));
        chave = (String)chave + ide.getCDV();
        enviNFe.getNFe().get(0).getInfNFe().setId("NFe" + (String)chave);
        System.out.println(Utils.marshaller(enviNFe));
        Document document = Signature.nfe(enviNFe);
        if (DEBUG) {
            System.out.println("\nXML Assinado");
        }
        String cscToken = tpAmb == 2 ? Empresa.getCscTokenHomo() : Empresa.getCscTokenProd();
        Element elQrCode = document.createElement("qrCode");
        elQrCode.appendChild(document.createCDATASection(SEFAZConnection.qrCode((String)chave, String.valueOf(tpAmb), cscToken)));
        Element elURLChave = document.createElement("urlChave");
        elURLChave.appendChild(document.createTextNode("https://www.sefaz.rs.gov.br/NFCE/NFCE-COM.aspx"));
        Node elInf = document.getElementsByTagName("infNFeSupl").item(0);
        if (elInf.hasChildNodes()) {
            for (int i = 0; i < elInf.getChildNodes().getLength(); ++i) {
                elInf.removeChild(elInf.getChildNodes().item(i));
            }
        }
        elInf.appendChild(elQrCode);
        elInf.appendChild(elURLChave);
        String xml = Utils.doc2Str(document);
        if (DEBUG) {
            System.out.println("\nAguardando resposta SEFAZ...\n\n" + xml);
        }
        TEnviNFe nfe = Utils.unmarshaller(TEnviNFe.class, xml);
        enviNFe.getNFe().get(0).setSignature(nfe.getNFe().get(0).getSignature());
        enviNFe.getNFe().get(0).setInfNFeSupl(nfe.getNFe().get(0).getInfNFeSupl());
        URL url = new URL(tpAmb == 1 ? "https://nfce.sefazrs.rs.gov.br/ws/NfeAutorizacao/NFeAutorizacao4.asmx" : "https://nfce-homologacao.sefazrs.rs.gov.br/ws/NfeAutorizacao/NFeAutorizacao4.asmx");
        SOAPMessage response = SEFAZConnection.sendXML(xml, "http://www.portalfiscal.inf.br/nfe/wsdl/NFeAutorizacao4", url);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        response.writeTo((OutputStream)out);
        int begin = out.toString().indexOf("<nfeResultMsg xmlns=\"http://www.portalfiscal.inf.br/nfe/wsdl/NFeAutorizacao4\">");
        int end = out.toString().indexOf("</nfeResultMsg>");
        String result = null;
        if (begin > -1 && end > begin) {
            result = out.toString().substring(begin, end).replace("<nfeResultMsg xmlns=\"http://www.portalfiscal.inf.br/nfe/wsdl/NFeAutorizacao4\">", "");
        }
        if (DEBUG) {
            System.out.println("\nResposta SEFAZ: " + result);
        }
        if ((retEnviNFe = Utils.unmarshaller(TRetEnviNFe.class, result)).getCStat().equals("104") && retEnviNFe.getProtNFe().getInfProt().getCStat().equals("100")) {
            new Thread(() -> {
                block11: {
                    File file;
                    TNfeProc nfeProc;
                    block10: {
                        nfeProc = new TNfeProc();
                        nfeProc.setVersao(enviNFe.getVersao());
                        nfeProc.setNFe(enviNFe.getNFe().get(0));
                        nfeProc.setProtNFe(retEnviNFe.getProtNFe());
                        file = new File("nfeProc", nfeProc.getNFe().getInfNFe().getIde().getNNF() + ".xml");
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        try {
                            Utils.writeFile(file, Utils.marshaller(nfeProc), false);
                        }
                        catch (IOException | JAXBException ex) {
                            if (!DEBUG) break block10;
                            System.err.println(ex);
                        }
                    }
                    try {
                        Daruma.danfeNFCe4(nfeProc);
                    }
                    catch (IOException ex) {
                        try {
                            Controller.importarNFCe(file);
                            OptionPane.success("NFC-e emitida, reenicie o sistema e v\u00e1 em 'NFC-e Emitidas' para imprimir.");
                            System.exit(0);
                        }
                        catch (Exception ex1) {
                            OptionPane.error(ex1);
                        }
                    }
                    try {
                        if (Controller.importarNFCe(file)) {
                            OptionPane.success(retEnviNFe.getProtNFe().getInfProt().getCStat() + ": " + retEnviNFe.getProtNFe().getInfProt().getXMotivo() + "\nNFC-e N\u00famero: " + nfeProc.getNFe().getInfNFe().getIde().getNNF() + "\nN\u00famero Autoriza\u00e7\u00e3o: " + MaskFormatter.format(retEnviNFe.getProtNFe().getInfProt().getNProt(), "### ########## ##") + "\nChave de Acesso: " + MaskFormatter.format(retEnviNFe.getProtNFe().getInfProt().getChNFe(), "#### #### #### #### #### #### #### #### #### #### ####"));
                        }
                    }
                    catch (Exception ex) {
                        if (!DEBUG) break block11;
                        System.err.println(ex);
                    }
                }
            }).start();
            return null;
        }
        if (retEnviNFe.getCStat().equals("225") || retEnviNFe.getCStat().equals("215")) {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            clip.setContents(new StringSelection(xml), null);
        }
        return retEnviNFe;
    }

    public static TRetInutNFe enviarInutNFe(int nnfIni, int nnfFim) throws Exception {
        TRetInutNFe retInutNFe;
        if (!REGISTRADO) {
            SEFAZConnection.registrarConexao(DEBUG);
        }
        TInutNFe.InfInut infInut = new TInutNFe.InfInut();
        infInut.setCNPJ(Empresa.getCnpj());
        infInut.setCUF(String.valueOf(Empresa.getUfIBGE()));
        infInut.setMod("65");
        infInut.setSerie(String.valueOf(Empresa.getSerie()));
        infInut.setNNFIni(String.valueOf(nnfIni));
        infInut.setNNFFin(String.valueOf(nnfFim));
        infInut.setTpAmb(Config.get("nfe.amb"));
        infInut.setXJust("Falha no sistema em gerar identificador causou a quebra de sequ\u00eancia.");
        infInut.setXServ("INUTILIZAR");
        TInutNFe inutNFe = new TInutNFe();
        inutNFe.setInfInut(infInut);
        inutNFe.setVersao("4.00");
        Calendar dt = Utils.dateFromServer();
        inutNFe.getInfInut().setAno(String.valueOf(dt.get(1) - 2000));
        Object id = "ID";
        id = (String)id + Utils.leftPad2(inutNFe.getInfInut().getCUF(), 2, '0');
        id = (String)id + (dt.get(1) - 2000);
        id = (String)id + inutNFe.getInfInut().getCNPJ();
        id = (String)id + inutNFe.getInfInut().getMod();
        id = (String)id + Utils.leftPad2(inutNFe.getInfInut().getSerie(), 3, '0');
        id = (String)id + Utils.leftPad2(inutNFe.getInfInut().getNNFIni(), 9, '0');
        id = (String)id + Utils.leftPad2(inutNFe.getInfInut().getNNFFin(), 9, '0');
        inutNFe.getInfInut().setId((String)id);
        Document doc = Signature.inutNFe(inutNFe);
        String xml = Utils.doc2Str(doc);
        URL url = new URL(inutNFe.getInfInut().getTpAmb().equals("1") ? "https://nfce.sefazrs.rs.gov.br/ws/nfeinutilizacao/NFeInutilizacao4.asmx" : "https://nfce-homologacao.sefazrs.rs.gov.br/ws/nfeinutilizacao/NFeInutilizacao4.asmx");
        if (DEBUG) {
            System.out.println("\nAguardando resposta SEFAZ...\n\n" + xml);
        }
        SOAPMessage response = SEFAZConnection.sendXML(xml, "http://www.portalfiscal.inf.br/nfe/wsdl/NFeInutilizacao4", url);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        response.writeTo((OutputStream)out);
        int begin = out.toString().indexOf("<nfeResultMsg xmlns=\"http://www.portalfiscal.inf.br/nfe/wsdl/NFeInutilizacao4\">");
        int end = out.toString().indexOf("</nfeResultMsg>");
        String result = null;
        if (begin > -1 && end > begin) {
            result = out.toString().substring(begin, end).replace("<nfeResultMsg xmlns=\"http://www.portalfiscal.inf.br/nfe/wsdl/NFeInutilizacao4\">", "");
        }
        if (DEBUG) {
            System.out.println("\nResposta SEFAZ: " + result);
        }
        if ((retInutNFe = Utils.unmarshaller(TRetInutNFe.class, result)).getInfInut().getCStat().equals("102")) {
            new Thread(() -> {
                block2: {
                    try {
                        TProcInutNFe procInutNFe = new TProcInutNFe();
                        procInutNFe.setInutNFe(inutNFe);
                        procInutNFe.setRetInutNFe(retInutNFe);
                        procInutNFe.setVersao(inutNFe.getVersao());
                        String xmlProc = Utils.marshaller(procInutNFe);
                        String xmlPath = NFCe.getProcNFePath(dt).getAbsolutePath() + File.separator + retInutNFe.getInfInut().getNProt() + "_v" + procInutNFe.getVersao() + "-procInutNFe.xml";
                        Utils.writeFile(xmlPath, xmlProc);
                        Controller.saveInutilizacao(retInutNFe, xmlProc, xmlPath);
                    }
                    catch (Exception ex) {
                        if (!DEBUG) break block2;
                        System.err.println(ex);
                    }
                }
            }).start();
        }
        return retInutNFe;
    }

    public static TRetEnvEvento enviarEventoCancelamento(String chaveAcesso, String justificativa) throws Exception {
        TRetEnvEvento retEnvEvento;
        if (!REGISTRADO) {
            SEFAZConnection.registrarConexao(DEBUG);
        }
        String id = "ID110111" + chaveAcesso.replace("NFe", "").trim() + "01";
        String cnpj = Empresa.getCnpj();
        String codigoUF = String.valueOf(Empresa.getUfIBGE());
        String dhEvento = Utils.date2NFe();
        Long idLote = Controller.getIdLoteEvento();
        Long nAut = Controller.getNumeroAutorizacaoNFCe(chaveAcesso);
        TEvento.InfEvento.DetEvento detEvento = new TEvento.InfEvento.DetEvento();
        detEvento.setVersao("1.00");
        detEvento.setNProt(nAut.toString());
        detEvento.setDescEvento("Cancelamento");
        detEvento.setXJust(justificativa.trim());
        TEvento.InfEvento infEvento = new TEvento.InfEvento();
        infEvento.setVerEvento("1.00");
        infEvento.setId(id);
        infEvento.setDhEvento(dhEvento);
        infEvento.setChNFe(chaveAcesso.replace("NFe", "").trim());
        infEvento.setCNPJ(cnpj.trim());
        infEvento.setCOrgao(codigoUF.trim());
        infEvento.setTpAmb(Config.get("nfe.amb"));
        infEvento.setTpEvento("110111");
        infEvento.setDetEvento(detEvento);
        infEvento.setNSeqEvento("1");
        TEvento evento = new TEvento();
        evento.setVersao("1.00");
        evento.setInfEvento(infEvento);
        TEnvEvento envEvento = new TEnvEvento();
        envEvento.setIdLote(idLote.toString());
        envEvento.getEvento().add(evento);
        envEvento.setVersao("1.00");
        Document document = Signature.evento(envEvento);
        if (DEBUG) {
            System.out.println("\nXML Assinado");
        }
        String xml = Utils.doc2Str(document);
        URL url = new URL(envEvento.getEvento().get(0).getInfEvento().getTpAmb().equals("1") ? "https://nfce.sefazrs.rs.gov.br/ws/recepcaoevento/recepcaoevento4.asmx" : "https://nfce-homologacao.sefazrs.rs.gov.br/ws/recepcaoevento/recepcaoevento4.asmx");
        if (DEBUG) {
            System.out.println("\nAguardando resposta SEFAZ...\n\n" + xml);
        }
        SOAPMessage response = SEFAZConnection.sendXML(xml, "http://www.portalfiscal.inf.br/nfe/wsdl/NFeRecepcaoEvento4", url);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        response.writeTo((OutputStream)out);
        int begin = out.toString().indexOf("<nfeResultMsg xmlns=\"http://www.portalfiscal.inf.br/nfe/wsdl/NFeRecepcaoEvento4\">");
        int end = out.toString().indexOf("</nfeResultMsg>");
        String result = null;
        if (begin > -1 && end > begin) {
            result = out.toString().substring(begin, end).replace("<nfeResultMsg xmlns=\"http://www.portalfiscal.inf.br/nfe/wsdl/NFeRecepcaoEvento4\">", "");
        }
        if (DEBUG) {
            System.out.println("\nResposta SEFAZ: " + result);
        }
        if ((retEnvEvento = Utils.unmarshaller(TRetEnvEvento.class, result)).getCStat().equals("128") && retEnvEvento.getRetEvento().get(0).getInfEvento().getCStat().equals("135")) {
            new Thread(() -> {
                block2: {
                    try {
                        TProcEvento procEvento = new TProcEvento();
                        procEvento.setVersao(envEvento.getVersao());
                        procEvento.setEvento(envEvento.getEvento().get(0));
                        procEvento.setRetEvento(retEnvEvento.getRetEvento().get(0));
                        String xmlProc = Utils.marshaller(procEvento);
                        String xmlPath = NFCe.getProcNFePath(Utils.dateNFe2Date(dhEvento)).getAbsolutePath() + File.separator + procEvento.getEvento().getInfEvento().getChNFe() + "_" + procEvento.getEvento().getInfEvento().getTpEvento() + "-procEventoNFe.xml";
                        Utils.writeFile(xmlPath, xmlProc);
                        Controller.saveEvento(idLote, procEvento, xmlProc, xmlPath);
                    }
                    catch (Exception ex) {
                        if (!DEBUG) break block2;
                        System.err.println(ex);
                    }
                }
            }).start();
        }
        return retEnvEvento;
    }

    private static SOAPMessage sendXML(String xml, String xmlns, URL url) throws Exception {
        StringBuilder soap = new StringBuilder();
        soap.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        soap.append("<soap12:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap12=\"http://www.w3.org/2003/05/soap-envelope\">");
        soap.append("<soap12:Body>");
        soap.append("<nfeDadosMsg xmlns=\"").append(xmlns).append("\">");
        soap.append(xml);
        soap.append("</nfeDadosMsg>");
        soap.append("</soap12:Body>");
        soap.append("</soap12:Envelope>");
        MessageFactory messageFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        MimeHeaders header = new MimeHeaders();
        header.addHeader("Content-Type", "application/soap+xml; charset=utf-8");
        SOAPMessage request = messageFactory.createMessage(header, (InputStream)new ByteArrayInputStream(soap.toString().getBytes()));
        SOAPConnection connection = SOAPConnectionFactory.newInstance().createConnection();
        return connection.call(request, (Object)url);
    }

    public static String decodeGZipToXml(String conteudoEncode) throws Exception {
        if (conteudoEncode == null || conteudoEncode.length() == 0) {
            return "";
        }
        byte[] conteudo = DatatypeConverter.parseBase64Binary((String)conteudoEncode);
        try (GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(conteudo));){
            String string;
            try (BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8));){
                String line;
                StringBuilder outStr = new StringBuilder();
                while ((line = bf.readLine()) != null) {
                    outStr.append(line);
                }
                string = outStr.toString();
            }
            return string;
        }
    }
}

