/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.nfe;

import br.com.ctecinf.nfe.Cartao;
import br.com.ctecinf.nfe.Constants;
import br.com.ctecinf.nfe.NFCe;
import br.com.ctecinf.nfe.SEFAZConnection;
import br.com.ctecinf.nfe.view.ConfirmarPanel;
import br.com.ctecinf.swing.OptionPane;
import br.com.ctecinf.swing.PleaseWaitDialog;
import br.com.ctecinf.text.MaskFormatter;
import br.com.ctecinf.text.NumberFormatter;
import br.inf.portalfiscal.nfe.v400.autorizacao.TRetEnviNFe;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;

public class PgtoAntecipado {
    public static final void show() {
        Number vPag;
        Number value;
        final NFCe nfce = new NFCe();
        String cpf = OptionPane.input("CPF", null, new MaskFormatter("###.###.###-##"));
        if (cpf != null) {
            try {
                String nome = OptionPane.input("Nome", null, null);
                nfce.addDest(cpf, nome, null, null);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        if ((value = (Number)OptionPane.input("Valor do Sinal", 0.0, new NumberFormatter(2))) == null) {
            return;
        }
        if (value.doubleValue() == 0.0) {
            OptionPane.error("Valor do produto n\u00e3o pode ser zero.");
            return;
        }
        nfce.setPagamentoAntecipado(value.doubleValue());
        double total = value.doubleValue();
        double totalPago = 0.0;
        do {
            String tPag;
            if ((tPag = (String)OptionPane.choice("Forma de pagamento", Constants.FORMAS_PAGAMENTO)) == null) {
                return;
            }
            Cartao cartao = null;
            if (tPag.equals("CARTAO CREDITO") || tPag.equals("CARTAO DEBITO")) {
                cartao = (Cartao)OptionPane.choice("Bandeira", Cartao.CARTOES);
                if (cartao.toString().equalsIgnoreCase("outros")) {
                    cartao.setCnpj(OptionPane.input("CNPJ da empresa de cart\u00e3o", null, new MaskFormatter("##.###.###/####-##")));
                }
                cartao.setcAut(OptionPane.input("N\u00famero da Autoriza\u00e7\u00e3o", null, null));
            }
            if ((vPag = (Number)OptionPane.input("Valor", total - totalPago, new NumberFormatter(2))) == null) {
                return;
            }
            switch (tPag) {
                case "DINHEIRO": {
                    nfce.addPagamentoDinheiro(vPag.doubleValue());
                    break;
                }
                case "CHEQUE": {
                    nfce.addPagamentoCheque(vPag.doubleValue());
                    break;
                }
                case "CARTAO CREDITO": {
                    nfce.addPagamentoCartaoCredito(cartao, vPag.doubleValue());
                    break;
                }
                case "CARTAO DEBITO": {
                    nfce.addPagamentoCartaoDebito(cartao, vPag.doubleValue());
                    break;
                }
                case "P/ CONTA ENCOMENDA": {
                    nfce.addPagamentoCrediario(vPag.doubleValue());
                    break;
                }
                case "DEPOSITO BANCARIO": {
                    nfce.addPagamentoDeposito(vPag.doubleValue());
                    break;
                }
                case "PIX": {
                    nfce.addPagamentoPix(vPag.doubleValue());
                    break;
                }
                default: {
                    nfce.addPagamentoOutros(vPag.doubleValue());
                }
            }
        } while ((totalPago += vPag.doubleValue()) < total);
        nfce.finalizar(0.0);
        if (OptionPane.confirm(new ConfirmarPanel(nfce))) {
            new PleaseWaitDialog(){

                public Object exec() throws Exception {
                    return SEFAZConnection.enviarNFe(nfce);
                }

                public void end(Object result) {
                    if (result != null) {
                        TRetEnviNFe retEnviNFe = (TRetEnviNFe)result;
                        if (retEnviNFe.getCStat().equals("225") || retEnviNFe.getCStat().equals("215")) {
                            OptionPane.error("Erro no lote, acessando o validador de XML no SEFAZ para verificar erro.\nUsar [Ctrl + v] para colar o XML no validador.");
                            try {
                                Desktop.getDesktop().browse(URI.create("https://www.sefaz.rs.gov.br/nfe/nfe-val.aspx"));
                            }
                            catch (IOException ex) {
                                System.err.println(ex);
                            }
                        } else {
                            String msg = retEnviNFe.getProtNFe().getInfProt().getCStat() + ": " + retEnviNFe.getProtNFe().getInfProt().getXMotivo();
                            OptionPane.info(msg);
                        }
                    }
                }
            }.start();
        }
    }
}

