/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.nfe;

import br.com.ctecinf.Empresa;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Security;

public class PKCS11 {
    private static final String NAME = "SunPKCS11";

    public static PKCS11 load() throws IOException, IllegalAccessException, KeyStoreException {
        PKCS11 pkcs11 = new PKCS11();
        File file = new File("config", "pkcs11.properties");
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            try (PrintWriter p = new PrintWriter(new FileWriter(file, false));){
                p.write("name=SmartCard\nlibrary=" + pkcs11.getProviderLibrary().getAbsolutePath() + "\nshowInfo=false");
            }
        }
        Security.addProvider(Security.getProvider(NAME).configure(file.getAbsolutePath()));
        KeyStore keyStore = KeyStore.getInstance("PKCS11");
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        System.setProperty("javax.net.ssl.keyStoreType", keyStore.getType());
        System.setProperty("javax.net.ssl.keyStore", "NONE");
        System.setProperty("javax.net.ssl.keyStorePassword", Empresa.getSenhaCertificado());
        System.setProperty("javax.net.ssl.keyStoreProvider", keyStore.getProvider().getName());
        System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", "true");
        System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        System.setProperty("javax.net.ssl.trustStore", "cacerts");
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
        return pkcs11;
    }

    protected File getProviderLibrary() throws IOException, IllegalAccessException {
        if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
            return new File("lib", "libOcsCryptoki.so");
        }
        return new File("lib", "aetpkss1.dll");
    }
}

