/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.nfe;

import br.com.ctecinf.Config;
import br.com.ctecinf.Empresa;
import br.com.ctecinf.Utils;
import br.com.ctecinf.model.Produto;
import br.com.ctecinf.nfe.Cartao;
import br.inf.portalfiscal.nfe.v400.autorizacao.ObjectFactory;
import br.inf.portalfiscal.nfe.v400.autorizacao.TEnderEmi;
import br.inf.portalfiscal.nfe.v400.autorizacao.TEndereco;
import br.inf.portalfiscal.nfe.v400.autorizacao.TNFe;
import br.inf.portalfiscal.nfe.v400.autorizacao.TUfEmi;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="NFe")
public class NFCe
extends TNFe {
    public NFCe() {
        TEnderEmi enderEmi = new TEnderEmi();
        enderEmi.setCEP(Empresa.getCep());
        enderEmi.setCMun(String.valueOf(Empresa.getMunicipioIBGE()));
        enderEmi.setFone(Empresa.getFone());
        enderEmi.setNro(String.valueOf(Empresa.getNumero()));
        enderEmi.setUF(TUfEmi.valueOf(Empresa.getUf()));
        enderEmi.setXBairro(Empresa.getBairro());
        enderEmi.setXCpl(Empresa.getComplemento());
        enderEmi.setXLgr(Empresa.getLogradouro());
        enderEmi.setXMun(Empresa.getMunicipio());
        TNFe.InfNFe.Emit emit = new TNFe.InfNFe.Emit();
        emit.setCNPJ(Empresa.getCnpj());
        emit.setXFant(Empresa.getNomeFantasia());
        emit.setXNome(Empresa.getRazaoSocial());
        emit.setIE(Empresa.getInscEstadual());
        emit.setCRT("1");
        emit.setEnderEmit(enderEmi);
        TNFe.InfNFe.Ide ide = new TNFe.InfNFe.Ide();
        ide.setMod("65");
        ide.setTpAmb(Config.get("nfe.amb"));
        ide.setCUF(String.valueOf(Empresa.getUfIBGE()));
        ide.setCMunFG(emit.getEnderEmit().getCMun());
        ide.setFinNFe(String.valueOf(1));
        ide.setIdDest(String.valueOf(1));
        ide.setIndFinal(String.valueOf(1));
        ide.setIndPres(String.valueOf(1));
        ide.setNatOp(Empresa.getNatOperacao());
        ide.setProcEmi(String.valueOf(0));
        ide.setSerie(String.valueOf(Empresa.getSerie()));
        ide.setTpEmis(String.valueOf(1));
        ide.setTpImp(String.valueOf(4));
        ide.setTpNF(String.valueOf(1));
        ide.setCNF(Utils.leftPad2(String.valueOf((int)(Math.random() * 9.9999999E7)), 8, '0'));
        TNFe.InfNFe.Transp transp = new TNFe.InfNFe.Transp();
        transp.setModFrete("9");
        TNFe.InfNFe.Total.ICMSTot icmsTot = new TNFe.InfNFe.Total.ICMSTot();
        icmsTot.setVBC("0.00");
        icmsTot.setVBCST("0.00");
        icmsTot.setVCOFINS("0.00");
        icmsTot.setVDesc(Utils.decimalFormat2Digits().format(0L));
        icmsTot.setVFCP("0.00");
        icmsTot.setVFCPST("0.00");
        icmsTot.setVFCPSTRet("0.00");
        icmsTot.setVFCPUFDest("0.00");
        icmsTot.setVFrete("0.00");
        icmsTot.setVICMS("0.00");
        icmsTot.setVICMSDeson("0.00");
        icmsTot.setVICMSUFDest("0.00");
        icmsTot.setVICMSUFRemet("0.00");
        icmsTot.setVII("0.00");
        icmsTot.setVIPI("0.00");
        icmsTot.setVIPIDevol("0.00");
        icmsTot.setVNF(Utils.decimalFormat2Digits().format(0L));
        icmsTot.setVOutro("0.00");
        icmsTot.setVPIS("0.00");
        icmsTot.setVProd(Utils.decimalFormat2Digits().format(0L));
        icmsTot.setVST("0.00");
        icmsTot.setVSeg("0.00");
        TNFe.InfNFe.Total total = new TNFe.InfNFe.Total();
        total.setICMSTot(icmsTot);
        TNFe.InfNFe.InfAdic infAdic = new TNFe.InfNFe.InfAdic();
        TNFe.InfNFe.Pag pag = new TNFe.InfNFe.Pag();
        this.infNFe = new TNFe.InfNFe();
        this.infNFe.setEmit(emit);
        this.infNFe.setIde(ide);
        this.infNFe.setTransp(transp);
        this.infNFe.setTotal(total);
        this.infNFe.setInfAdic(infAdic);
        this.infNFe.setPag(pag);
        if (Empresa.getContadorCNPJ() != null && Empresa.getContadorCNPJ().length() == 14) {
            TNFe.InfNFe.AutXML autXML = new TNFe.InfNFe.AutXML();
            autXML.setCNPJ(Empresa.getContadorCNPJ());
            this.infNFe.getAutXML().add(autXML);
        }
        this.infNFeSupl = new TNFe.InfNFeSupl();
        super.setInfNFe(this.infNFe);
        super.setInfNFeSupl(this.infNFeSupl);
    }

    public void addDest(String cpf, String nome, String email, TEndereco endereco) throws Exception {
        if (cpf == null) {
            throw new Exception("CPF n\u00e3o pode ser nulo.");
        }
        if (!this.infNFe.getIde().getTpAmb().equals("2")) {
            TNFe.InfNFe.Dest dest = new TNFe.InfNFe.Dest();
            dest.setCPF(cpf.replace(".", "").replace("-", "").trim());
            if (nome != null && !nome.isEmpty()) {
                dest.setXNome(nome.trim());
            }
            if (email != null && !email.isEmpty()) {
                dest.setEmail(email.trim());
            }
            if (endereco != null) {
                dest.setEnderDest(endereco);
            }
            dest.setIndIEDest("9");
            this.infNFe.setDest(dest);
        }
    }

    public void addDestEstrangeiro(String idEstrangeiro, String nome, String email) throws Exception {
        if (idEstrangeiro == null) {
            throw new Exception("ID Estrangeiro n\u00e3o pode ser nulo.");
        }
        if (!this.infNFe.getIde().getTpAmb().equals("2")) {
            TNFe.InfNFe.Dest dest = new TNFe.InfNFe.Dest();
            dest.setIdEstrangeiro(idEstrangeiro.trim());
            if (nome != null && !nome.isEmpty()) {
                dest.setXNome(nome.trim());
            }
            if (email != null && !email.isEmpty()) {
                dest.setEmail(email.trim());
            }
            dest.setIndIEDest("9");
            this.infNFe.setDest(dest);
        }
    }

    public void addPagamentoDinheiro(double vPag) {
        TNFe.InfNFe.Pag.DetPag pag = new TNFe.InfNFe.Pag.DetPag();
        pag.setTPag("01");
        pag.setVPag(Utils.decimalFormat2Digits().format(vPag));
        this.infNFe.getPag().getDetPag().add(pag);
    }

    public void addPagamentoCheque(double vPag) {
        TNFe.InfNFe.Pag.DetPag pag = new TNFe.InfNFe.Pag.DetPag();
        pag.setTPag("02");
        pag.setVPag(Utils.decimalFormat2Digits().format(vPag));
        this.infNFe.getPag().getDetPag().add(pag);
    }

    public void addPagamentoCartaoCredito(Cartao cartao, double vPag) {
        TNFe.InfNFe.Pag.DetPag.Card card = new TNFe.InfNFe.Pag.DetPag.Card();
        card.setCNPJ(cartao.getCnpj());
        card.setCAut(cartao.getcAut());
        card.setTBand(Utils.leftPad2(cartao.gettBand(), 2, '0'));
        card.setTpIntegra(String.valueOf(cartao.getTpIntegra()));
        TNFe.InfNFe.Pag.DetPag pag = new TNFe.InfNFe.Pag.DetPag();
        pag.setCard(card);
        pag.setTPag("03");
        pag.setVPag(Utils.decimalFormat2Digits().format(vPag));
        this.infNFe.getPag().getDetPag().add(pag);
    }

    public void addPagamentoCartaoDebito(Cartao cartao, double vPag) {
        TNFe.InfNFe.Pag.DetPag.Card card = new TNFe.InfNFe.Pag.DetPag.Card();
        card.setCNPJ(cartao.getCnpj());
        card.setCAut(cartao.getcAut());
        card.setTBand(Utils.leftPad2(cartao.gettBand(), 2, '0'));
        card.setTpIntegra(String.valueOf(cartao.getTpIntegra()));
        TNFe.InfNFe.Pag.DetPag pag = new TNFe.InfNFe.Pag.DetPag();
        pag.setCard(card);
        pag.setTPag("04");
        pag.setVPag(Utils.decimalFormat2Digits().format(vPag));
        this.infNFe.getPag().getDetPag().add(pag);
    }

    public void addPagamentoCrediario(double vPag) {
        TNFe.InfNFe.Pag.DetPag pag = new TNFe.InfNFe.Pag.DetPag();
        pag.setTPag("05");
        pag.setVPag(Utils.decimalFormat2Digits().format(vPag));
        this.infNFe.getPag().getDetPag().add(pag);
    }

    public void addPagamentoPix(double vPag) {
        TNFe.InfNFe.Pag.DetPag pag = new TNFe.InfNFe.Pag.DetPag();
        pag.setTPag("17");
        pag.setVPag(Utils.decimalFormat2Digits().format(vPag));
        TNFe.InfNFe.InfAdic.ObsCont obsCont = new TNFe.InfNFe.InfAdic.ObsCont();
        obsCont.setXCampo("tPix");
        obsCont.setXTexto("1");
        this.infNFe.getPag().getDetPag().add(pag);
        this.infNFe.getInfAdic().getObsCont().add(obsCont);
    }

    public void addPagamentoDeposito(double vPag) {
        TNFe.InfNFe.Pag.DetPag pag = new TNFe.InfNFe.Pag.DetPag();
        pag.setTPag("16");
        pag.setVPag(Utils.decimalFormat2Digits().format(vPag));
        this.infNFe.getPag().getDetPag().add(pag);
    }

    public void addPagamentoOutros(double vPag) {
        TNFe.InfNFe.Pag.DetPag pag = new TNFe.InfNFe.Pag.DetPag();
        pag.setTPag("99");
        pag.setVPag(Utils.decimalFormat2Digits().format(vPag));
        this.infNFe.getPag().getDetPag().add(pag);
    }

    public void setPagamentoAntecipado(double vPag) {
        TNFe.InfNFe.Det.Prod prod = new TNFe.InfNFe.Det.Prod();
        prod.setCProd("CFOP5949");
        prod.setCEAN("SEM GTIN");
        if (this.infNFe.getDet().isEmpty() && this.infNFe.getIde().getTpAmb().equals("2")) {
            prod.setXProd("NOTA FISCAL EMITIDA EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL");
        } else {
            prod.setXProd("PAGAMENTO ANTECIPADO");
        }
        prod.setNCM("00000000");
        prod.setCBenef("RS052999");
        prod.setCFOP("5949");
        prod.setUCom("UN");
        prod.setQCom("1");
        prod.setVUnCom(Utils.decimalFormat2Digits().format(vPag));
        prod.setVProd(Utils.decimalFormat2Digits().format(vPag));
        prod.setCEANTrib("SEM GTIN");
        prod.setUTrib("UN");
        prod.setQTrib("1");
        prod.setVUnTrib(Utils.decimalFormat4Digits().format(vPag));
        prod.setIndTot("1");
        TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN900 icmssN900 = new TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN900();
        icmssN900.setOrig("0");
        icmssN900.setCSOSN("900");
        TNFe.InfNFe.Det.Imposto.ICMS icms = new TNFe.InfNFe.Det.Imposto.ICMS();
        icms.setICMSSN900(icmssN900);
        TNFe.InfNFe.Det.Imposto.PIS.PISOutr pisnt = new TNFe.InfNFe.Det.Imposto.PIS.PISOutr();
        pisnt.setCST("99");
        pisnt.setQBCProd("0.0000");
        pisnt.setVAliqProd("0.0000");
        pisnt.setVPIS("0.00");
        TNFe.InfNFe.Det.Imposto.PIS pis = new TNFe.InfNFe.Det.Imposto.PIS();
        pis.setPISOutr(pisnt);
        TNFe.InfNFe.Det.Imposto.COFINS.COFINSOutr cofinsnt = new TNFe.InfNFe.Det.Imposto.COFINS.COFINSOutr();
        cofinsnt.setCST("99");
        cofinsnt.setQBCProd("0.0000");
        cofinsnt.setVAliqProd("0.0000");
        cofinsnt.setVCOFINS("0.00");
        TNFe.InfNFe.Det.Imposto.COFINS cofins = new TNFe.InfNFe.Det.Imposto.COFINS();
        cofins.setCOFINSOutr(cofinsnt);
        TNFe.InfNFe.Det.Imposto imposto = new TNFe.InfNFe.Det.Imposto();
        imposto.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoICMS(icms));
        imposto.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoPIS(pis));
        imposto.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoCOFINS(cofins));
        TNFe.InfNFe.Det det = new TNFe.InfNFe.Det();
        det.setNItem(String.valueOf(this.infNFe.getDet().size() + 1));
        det.setProd(prod);
        det.setImposto(imposto);
        this.infNFe.getDet().add(det);
        this.infNFe.getTotal().getICMSTot().setVProd(Utils.decimalFormat2Digits().format(vPag));
        this.infNFe.getTotal().getICMSTot().setVNF(Utils.decimalFormat2Digits().format(vPag));
    }

    public void addProduto(Produto p, double qtde, Double desconto) {
        TNFe.InfNFe.Det.Prod prod = new TNFe.InfNFe.Det.Prod();
        prod.setCEAN("SEM GTIN");
        prod.setCEANTrib("SEM GTIN");
        if (this.infNFe.getDet().isEmpty() && this.infNFe.getIde().getTpAmb().equals("2")) {
            prod.setCProd("CFOP" + Empresa.getCfopId());
            prod.setXProd("NOTA FISCAL EMITIDA EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL");
        } else {
            prod.setCProd(String.valueOf(p.getId()).trim());
            prod.setXProd(p.getDescricao().trim());
        }
        double vProd = p.getValorUnitario().doubleValue() * qtde;
        prod.setCFOP(String.valueOf(Empresa.getCfopId()).trim());
        prod.setNCM(String.valueOf(p.getNcm().getId()).trim());
        prod.setQCom(Utils.decimalFormat4Digits().format(qtde));
        prod.setQTrib(Utils.decimalFormat4Digits().format(qtde));
        prod.setUCom(p.getUndCom().trim());
        prod.setUTrib(p.getUndCom().trim());
        prod.setVUnCom(Utils.decimalFormat4Digits().format(p.getValorUnitario()));
        prod.setVUnTrib(Utils.decimalFormat4Digits().format(p.getValorUnitario()));
        prod.setVProd(Utils.decimalFormat2Digits().format(vProd));
        if (desconto != null && desconto > 0.0) {
            prod.setVDesc(Utils.decimalFormat2Digits().format(desconto));
        }
        prod.setIndTot("1");
        TNFe.InfNFe.Det.Imposto.ICMS icms = new TNFe.InfNFe.Det.Imposto.ICMS();
        TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN102 icmssN102 = new TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN102();
        icmssN102.setCSOSN("102");
        icmssN102.setOrig(String.valueOf(Empresa.getIcmsOrigemId()));
        icms.setICMSSN102(icmssN102);
        TNFe.InfNFe.Det.Imposto.PIS.PISOutr pisnt = new TNFe.InfNFe.Det.Imposto.PIS.PISOutr();
        pisnt.setCST("99");
        pisnt.setQBCProd("0.0000");
        pisnt.setVAliqProd("0.0000");
        pisnt.setVPIS("0.00");
        TNFe.InfNFe.Det.Imposto.PIS pis = new TNFe.InfNFe.Det.Imposto.PIS();
        pis.setPISOutr(pisnt);
        TNFe.InfNFe.Det.Imposto.COFINS.COFINSOutr cofinsnt = new TNFe.InfNFe.Det.Imposto.COFINS.COFINSOutr();
        cofinsnt.setCST("99");
        cofinsnt.setQBCProd("0.0000");
        cofinsnt.setVAliqProd("0.0000");
        cofinsnt.setVCOFINS("0.00");
        TNFe.InfNFe.Det.Imposto.COFINS cofins = new TNFe.InfNFe.Det.Imposto.COFINS();
        cofins.setCOFINSOutr(cofinsnt);
        TNFe.InfNFe.Det.Imposto imposto = new TNFe.InfNFe.Det.Imposto();
        imposto.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoICMS(icms));
        imposto.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoPIS(pis));
        imposto.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoCOFINS(cofins));
        TNFe.InfNFe.Det det = new TNFe.InfNFe.Det();
        det.setNItem(String.valueOf(this.infNFe.getDet().size() + 1));
        det.setProd(prod);
        det.setImposto(imposto);
        this.infNFe.getDet().add(det);
        double vTot = Double.parseDouble(this.infNFe.getTotal().getICMSTot().getVProd());
        this.infNFe.getTotal().getICMSTot().setVProd(Utils.decimalFormat2Digits().format(vProd + vTot));
        this.infNFe.getTotal().getICMSTot().setVNF(Utils.decimalFormat2Digits().format(vProd + vTot));
    }

    public void finalizar(double troco) {
        double subTotal;
        double total = subTotal = Double.parseDouble(this.infNFe.getTotal().getICMSTot().getVProd());
        double tributos = Empresa.getAliquota();
        double desconto = 0.0;
        for (TNFe.InfNFe.Det det : this.infNFe.getDet()) {
            if (det.getProd().getVDesc() == null) continue;
            desconto += Double.parseDouble(det.getProd().getVDesc());
        }
        total -= desconto;
        if (troco > 0.0) {
            for (TNFe.InfNFe.Pag.DetPag pag : this.infNFe.getPag().getDetPag()) {
                if (!pag.getTPag().equals("01") || !(Double.parseDouble(pag.getVPag()) > troco)) continue;
                pag.setVPag(Utils.decimalFormat2Digits().format(Double.parseDouble(pag.getVPag()) - troco));
                break;
            }
        }
        this.infNFe.getPag().setVTroco(Utils.decimalFormat2Digits().format(troco));
        this.infNFe.getTotal().getICMSTot().setVDesc(Utils.decimalFormat2Digits().format(desconto));
        this.infNFe.getTotal().getICMSTot().setVNF(Utils.decimalFormat2Digits().format(total));
        this.infNFe.getInfAdic().setInfCpl("Documento emitido por ME ou EPP optante pelo Simples Nacional. Tributos Totais Incidentes (Lei Federal 12.741/2012):    " + DecimalFormat.getCurrencyInstance(new Locale("pt", "BR")).format(total * tributos / 100.0));
    }

    public static File getProcNFePath(Calendar cal) {
        Locale local = new Locale("pt", "BR");
        if (cal == null) {
            cal = Utils.dateFromServer();
        }
        return new File(Config.get("nfe.xml.path"), "xml" + File.separator + cal.get(1) + File.separator + cal.getDisplayName(2, 2, local));
    }
}

