/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.nfe;

import br.com.ctecinf.Utils;
import br.com.ctecinf.text.MaskFormatter;
import br.com.ctecinf.text.NumberFormatter;
import br.com.ctecinf.text.TimestampFormatter;
import br.inf.portalfiscal.nfe.v310.autorizacao.TNFe;
import br.inf.portalfiscal.nfe.v310.autorizacao.TNfeProc;
import br.inf.portalfiscal.nfe.v400.autorizacao.TNFe;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.BarcodeQRCode;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;

public class DanfePDF {
    public static File createFile(String xmlPath) throws Exception {
        return DanfePDF.createFile(new File(xmlPath));
    }

    public static File createFile(File xml) throws Exception {
        File pdf = new File("pdf", xml.getName().replace(".xml", ".pdf"));
        if (!pdf.getParentFile().exists()) {
            pdf.getParentFile().mkdirs();
        }
        if (pdf.exists()) {
            return pdf;
        }
        Document document = new Document();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(pdf));
        document.open();
        String strXML = Utils.readFile(xml);
        Object nfe = strXML.contains("versao=\"4.00\"") ? Utils.unmarshaller(br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc.class, strXML) : Utils.unmarshaller(TNfeProc.class, strXML);
        String str = DanfePDF.getDanfeHTML(nfe);
        System.out.println(str);
        XMLWorkerHelper.getInstance().parseXHtml(writer, document, (Reader)new StringReader(str));
        BarcodeQRCode barcodeQRCode = nfe instanceof br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc ? new BarcodeQRCode(((br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc)nfe).getNFe().getInfNFeSupl().getQrCode(), 1000, 1000, null) : new BarcodeQRCode(((TNfeProc)nfe).getNFe().getInfNFeSupl().getQrCode(), 1000, 1000, null);
        Image codeQrImage = barcodeQRCode.getImage();
        codeQrImage.scaleAbsolute(120.0f, 120.0f);
        Paragraph p = new Paragraph();
        p.add((Element)codeQrImage);
        p.setIndentationLeft(45.0f);
        document.add((Element)p);
        String desc = nfe instanceof br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc ? ((br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc)nfe).getNFe().getInfNFe().getInfAdic().getInfCpl() : ((TNfeProc)nfe).getNFe().getInfNFe().getInfAdic().getInfCpl();
        XMLWorkerHelper.getInstance().parseXHtml(writer, document, (Reader)new StringReader("<div style=\"width:280px;font-size:9px\"><p align=\"center\">" + desc + "</p></div>"));
        document.close();
        return pdf;
    }

    private static String getDanfeHTML(Object nfe) {
        if (nfe instanceof br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc) {
            return DanfePDF.danfe4HTML((br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc)nfe);
        }
        return DanfePDF.danfe3((TNfeProc)nfe);
    }

    private static String head(Object nfe) {
        Object endereco;
        String razaoSocial;
        String cnpj;
        if (nfe instanceof br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc) {
            br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc p = (br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc)nfe;
            cnpj = p.getNFe().getInfNFe().getEmit().getCNPJ();
            razaoSocial = p.getNFe().getInfNFe().getEmit().getXNome();
            endereco = p.getNFe().getInfNFe().getEmit().getEnderEmit().getXLgr();
            endereco = (String)endereco + (String)(p.getNFe().getInfNFe().getEmit().getEnderEmit().getNro() != null ? ", " + p.getNFe().getInfNFe().getEmit().getEnderEmit().getNro() : "");
            endereco = (String)endereco + (String)(p.getNFe().getInfNFe().getEmit().getEnderEmit().getXCpl() != null ? " - " + p.getNFe().getInfNFe().getEmit().getEnderEmit().getXCpl() : "");
            endereco = (String)endereco + (String)(p.getNFe().getInfNFe().getEmit().getEnderEmit().getXBairro() != null ? ", " + p.getNFe().getInfNFe().getEmit().getEnderEmit().getXBairro() : "");
            endereco = (String)endereco + (String)(p.getNFe().getInfNFe().getEmit().getEnderEmit().getXMun() != null ? ", " + p.getNFe().getInfNFe().getEmit().getEnderEmit().getXMun() : "");
            endereco = (String)endereco + " - " + p.getNFe().getInfNFe().getEmit().getEnderEmit().getUF().value();
        } else {
            TNfeProc p = (TNfeProc)nfe;
            cnpj = p.getNFe().getInfNFe().getEmit().getCNPJ();
            razaoSocial = p.getNFe().getInfNFe().getEmit().getXNome();
            endereco = p.getNFe().getInfNFe().getEmit().getEnderEmit().getXLgr();
            endereco = (String)endereco + (String)(p.getNFe().getInfNFe().getEmit().getEnderEmit().getNro() != null ? ", " + p.getNFe().getInfNFe().getEmit().getEnderEmit().getNro() : "");
            endereco = (String)endereco + (String)(p.getNFe().getInfNFe().getEmit().getEnderEmit().getXCpl() != null ? " - " + p.getNFe().getInfNFe().getEmit().getEnderEmit().getXCpl() : "");
            endereco = (String)endereco + (String)(p.getNFe().getInfNFe().getEmit().getEnderEmit().getXBairro() != null ? ", " + p.getNFe().getInfNFe().getEmit().getEnderEmit().getXBairro() : "");
            endereco = (String)endereco + (String)(p.getNFe().getInfNFe().getEmit().getEnderEmit().getXMun() != null ? ", " + p.getNFe().getInfNFe().getEmit().getEnderEmit().getXMun() : "");
            endereco = (String)endereco + " - " + p.getNFe().getInfNFe().getEmit().getEnderEmit().getUF().value();
        }
        return "                <p align=\"center\">CNPJ " + MaskFormatter.format(cnpj, "##.###.###/####-##") + " <b>" + razaoSocial + "</b><br />\n                " + (String)endereco + "<br />\n                Documento Auxiliar da Nota Fiscal de Consumidor Eletr\u00f4nica</p><br />\n";
    }

    private static String produtos(Object nfe) {
        Object str = "";
        if (nfe instanceof br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc) {
            br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc p = (br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc)nfe;
            for (TNFe.InfNFe.Det det : p.getNFe().getInfNFe().getDet()) {
                TNFe.InfNFe.Det.Prod prod = det.getProd();
                String cod = prod.getCProd();
                String desc = prod.getXProd();
                String qtde = prod.getQCom();
                String und = prod.getUCom();
                String vlUnit = NumberFormatter.format().format(Double.parseDouble(prod.getVUnCom()));
                String total = NumberFormatter.format().format(Double.parseDouble(prod.getVProd()));
                str = (String)str + "                <tr>\n                    <td>" + cod + "</td><td>" + desc + "</td><td>" + qtde + "</td><td>" + und + "</td><td align=\"right\">" + vlUnit + "</td><td align=\"right\">" + total + "</td>\n                </tr>\n";
            }
        } else {
            TNfeProc p = (TNfeProc)nfe;
            for (TNFe.InfNFe.Det det : p.getNFe().getInfNFe().getDet()) {
                TNFe.InfNFe.Det.Prod prod = det.getProd();
                String cod = prod.getCProd();
                String desc = prod.getXProd();
                String qtde = prod.getQCom();
                String und = prod.getUCom();
                String vlUnit = NumberFormatter.format().format(Double.parseDouble(prod.getVUnCom()));
                String total = NumberFormatter.format().format(Double.parseDouble(prod.getVProd()));
                str = (String)str + "                <tr>\n                    <td>" + cod + "</td><td>" + desc + "</td><td>" + qtde + "</td><td>" + und + "</td><td align=\"right\">" + vlUnit + "</td><td align=\"right\">" + total + "</td>\n                </tr>\n";
            }
        }
        return str;
    }

    private static String pagamentos(Object nfe) {
        Object str = "";
        if (nfe instanceof br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc) {
            br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc p = (br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc)nfe;
            for (TNFe.InfNFe.Pag.DetPag detPag : p.getNFe().getInfNFe().getPag().getDetPag()) {
                String desc = DanfePDF.getDescPagto(detPag.getTPag());
                String valor = NumberFormatter.format().format(Double.parseDouble(detPag.getVPag()));
                str = (String)str + "                <tr>\n                    <td align=\"left\">" + desc + "</td><td align=\"right\">" + valor + "</td>\n                </tr>\n";
            }
        } else {
            TNfeProc p = (TNfeProc)nfe;
            for (TNFe.InfNFe.Pag pag : p.getNFe().getInfNFe().getPag()) {
                String desc = DanfePDF.getDescPagto(pag.getTPag());
                String valor = NumberFormatter.format().format(Double.parseDouble(pag.getVPag()));
                str = (String)str + "                <tr>\n                    <td align=\"left\">" + desc + "</td><td align=\"right\">" + valor + "</td>\n                </tr>\n";
            }
        }
        return str;
    }

    private static String getDescPagto(String tPag) {
        return switch (tPag) {
            case "01" -> "Dinheiro";
            case "02" -> "Cheque";
            case "03" -> "Cartao de Credito";
            case "04" -> "Cartao de Debito";
            case "05" -> "Credito Loja";
            case "16" -> "Deposito Bancario";
            case "17" -> "Pagamento Instantaneo (Pix)";
            default -> "Outros";
        };
    }

    private static String danfe3(TNfeProc nfe) {
        String str = "<div style=\"width:320px;font-size:9px\">\n            \n" + DanfePDF.head(nfe) + "            \n            <table style=\"width:100%;font-size:8px\">\n                <tr>\n                    <th width=\"10%\" align=\"left\">C\u00f3d.</th><th width=\"40%\" align=\"left\">Descri\u00e7\u00e3o</th><th width=\"10%\" align=\"left\">Qtde.</th><th width=\"10%\" align=\"left\">UN</th><th width=\"15%\" align=\"right\">Vl. Unit.</th><th width=\"15%\" align=\"right\">Vl. Total</th>\n                </tr>\n" + DanfePDF.produtos(nfe) + "            </table>\n            \n            <table style=\"width:100%;font-size:9px\">\n                \n                <tr>\n                    <td align=\"left\">Qtde. total de itens</td><td align=\"right\">" + nfe.getNFe().getInfNFe().getDet().size() + "</td>\n                </tr>\n                \n                <tr>\n                    <td align=\"left\">Valor total R$</td><td align=\"right\">" + NumberFormatter.format().format(Double.parseDouble(nfe.getNFe().getInfNFe().getTotal().getICMSTot().getVProd())) + "</td>\n                </tr>\n                \n                <tr>\n                    <td align=\"left\">Desconto R$</td><td align=\"right\">" + NumberFormatter.format().format(Double.parseDouble(nfe.getNFe().getInfNFe().getTotal().getICMSTot().getVDesc())) + "</td>\n                </tr>\n                \n                <tr>\n                    <th align=\"left\">Valor \u00e0 pagar R$</th><th align=\"right\">" + NumberFormatter.format().format(Double.parseDouble(nfe.getNFe().getInfNFe().getTotal().getICMSTot().getVNF())) + "</th>\n                </tr>\n                \n            </table>\n            \n            <table style=\"width:100%;font-size:9px\">\n                \n                <tr>\n                    <td align=\"left\">FORMA PAGAMENTO</td><td align=\"right\">VALOR PAGO R$</td>\n                </tr>\n                \n" + DanfePDF.pagamentos(nfe) + "                \n            </table>\n            \n            <p align=\"center\"><b>Consulte pela chave de acesso em</b><br />https://www.sefaz.rs.gov.br/NFCE/NFCE-COM.aspx<br />" + MaskFormatter.format(nfe.getNFe().getInfNFe().getId().replace("NFe", ""), "#### #### #### #### #### #### #### #### #### #### ####") + "</p>\n            \n";
        if (nfe.getNFe().getInfNFe().getDest() != null) {
            String nome = nfe.getNFe().getInfNFe().getDest().getXNome();
            if (nfe.getNFe().getInfNFe().getDest().getCPF() != null) {
                String cpf = nfe.getNFe().getInfNFe().getDest().getCPF();
                str = str + "<p align=\"center\"><b>CONSUMIDOR - CPF " + MaskFormatter.format(cpf, "###.###.###-##") + "</b>";
            } else if (nfe.getNFe().getInfNFe().getDest().getIdEstrangeiro() != null) {
                String idEstrangeiro = nfe.getNFe().getInfNFe().getDest().getCPF();
                str = str + "<p align=\"center\"><b>CONSUMIDOR - ID ESTRANGEIRO " + idEstrangeiro + "</b>";
            }
            if (!nome.isEmpty()) {
                str = str + "<br />" + nome;
            }
            str = str + "</p>";
        } else {
            str = str + "<p align=\"center\"><b>CONSUMIDOR N\u00c3O IDENTIFICADO</b></p>";
        }
        str = str + "            \n            <p align=\"center\"><b>NFC-e " + nfe.getNFe().getInfNFe().getIde().getNNF() + "&nbsp;&nbsp;&nbsp;S\u00e9rie " + nfe.getNFe().getInfNFe().getIde().getSerie() + "&nbsp;&nbsp;&nbsp;" + TimestampFormatter.format().format(Utils.dateNFe2Date(nfe.getNFe().getInfNFe().getIde().getDhEmi()).getTime()) + "<br />Protocolo de autoriza\u00e7\u00e3o:</b> " + MaskFormatter.format(nfe.getProtNFe().getInfProt().getNProt(), "### ########## ##") + "<br /><b>Data de autoriza\u00e7\u00e3o</b> " + TimestampFormatter.format().format(Utils.dateNFe2Date(nfe.getProtNFe().getInfProt().getDhRecbto()).getTime()) + "</p>\n            \n        </div>";
        return str;
    }

    private static String danfe4HTML(br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc nfe) {
        String str = "<div style=\"width:320px;font-size:9px\">\n            \n" + DanfePDF.head(nfe) + "            \n            <table style=\"width:100%;font-size:8px\">\n                <tr>\n                    <th width=\"10%\" align=\"left\">C\u00f3d.</th><th width=\"40%\" align=\"left\">Descri\u00e7\u00e3o</th><th width=\"10%\" align=\"left\">Qtde.</th><th width=\"10%\" align=\"left\">UN</th><th width=\"15%\" align=\"right\">Vl. Unit.</th><th width=\"15%\" align=\"right\">Vl. Total</th>\n                </tr>\n" + DanfePDF.produtos(nfe) + "            </table>\n            \n            <table style=\"width:100%;font-size:9px\">\n                \n                <tr>\n                    <td align=\"left\">Qtde. total de itens</td><td align=\"right\">" + nfe.getNFe().getInfNFe().getDet().size() + "</td>\n                </tr>\n                \n                <tr>\n                    <td align=\"left\">Valor total R$</td><td align=\"right\">" + NumberFormatter.format().format(Double.parseDouble(nfe.getNFe().getInfNFe().getTotal().getICMSTot().getVProd())) + "</td>\n                </tr>\n                \n                <tr>\n                    <td align=\"left\">Desconto R$</td><td align=\"right\">" + NumberFormatter.format().format(Double.parseDouble(nfe.getNFe().getInfNFe().getTotal().getICMSTot().getVDesc())) + "</td>\n                </tr>\n                \n                <tr>\n                    <th align=\"left\">Valor \u00e0 pagar R$</th><th align=\"right\">" + NumberFormatter.format().format(Double.parseDouble(nfe.getNFe().getInfNFe().getTotal().getICMSTot().getVNF())) + "</th>\n                </tr>\n                \n            </table>\n            \n            <table style=\"width:100%;font-size:9px\">\n                \n                <tr>\n                    <td align=\"left\">FORMA PAGAMENTO</td><td align=\"right\">VALOR PAGO R$</td>\n                </tr>\n                \n" + DanfePDF.pagamentos(nfe) + "                \n            </table>\n            \n            <table style=\"width:100%;font-size:9px\">\n                \n                <tr>\n                    <td align=\"left\">Troco R$</td><td align=\"right\">" + NumberFormatter.format().format(nfe.getNFe().getInfNFe().getPag().getVTroco() == null ? "0" : Double.valueOf(Double.parseDouble(nfe.getNFe().getInfNFe().getPag().getVTroco()))) + "</td>\n                </tr>\n                \n            </table>\n            \n            <p align=\"center\"><b>Consulte pela chave de acesso em</b><br />https://www.sefaz.rs.gov.br/NFCE/NFCE-COM.aspx<br />" + MaskFormatter.format(nfe.getNFe().getInfNFe().getId().replace("NFe", ""), "#### #### #### #### #### #### #### #### #### #### ####") + "</p>\n            \n";
        if (nfe.getNFe().getInfNFe().getDest() != null) {
            String nome = nfe.getNFe().getInfNFe().getDest().getXNome();
            if (nfe.getNFe().getInfNFe().getDest().getCPF() != null) {
                String cpf = nfe.getNFe().getInfNFe().getDest().getCPF();
                str = str + "<p align=\"center\"><b>CONSUMIDOR - CPF " + MaskFormatter.format(cpf, "###.###.###-##") + "</b>";
            } else if (nfe.getNFe().getInfNFe().getDest().getIdEstrangeiro() != null) {
                String idEstrangeiro = nfe.getNFe().getInfNFe().getDest().getCPF();
                str = str + "<p align=\"center\"><b>CONSUMIDOR - ID ESTRANGEIRO " + idEstrangeiro + "</b>";
            }
            if (nome != null && !nome.isEmpty()) {
                str = str + "<br />" + nome;
            }
            str = str + "</p>";
        } else {
            str = str + "<p align=\"center\"><b>CONSUMIDOR N\u00c3O IDENTIFICADO</b></p>";
        }
        str = str + "            \n            <p align=\"center\"><b>NFC-e " + nfe.getNFe().getInfNFe().getIde().getNNF() + "&nbsp;&nbsp;&nbsp;S\u00e9rie " + nfe.getNFe().getInfNFe().getIde().getSerie() + "&nbsp;&nbsp;&nbsp;" + TimestampFormatter.format().format(Utils.dateNFe2Date(nfe.getNFe().getInfNFe().getIde().getDhEmi()).getTime()) + "<br />Protocolo de autoriza\u00e7\u00e3o:</b> " + MaskFormatter.format(nfe.getProtNFe().getInfProt().getNProt(), "### ########## ##") + "<br /><b>Data de autoriza\u00e7\u00e3o</b> " + TimestampFormatter.format().format(Utils.dateNFe2Date(nfe.getProtNFe().getInfProt().getDhRecbto()).getTime()) + "</p>\n            \n        </div>";
        return str;
    }
}

