/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.nfe;

import br.com.ctecinf.Config;
import br.com.ctecinf.Database;
import br.com.ctecinf.Empresa;
import br.com.ctecinf.Log;
import br.com.ctecinf.Utils;
import br.com.ctecinf.nfe.Cartao;
import br.com.ctecinf.nfe.DanfePDF;
import br.com.ctecinf.nfe.NFCe;
import br.com.ctecinf.table.TableModel;
import br.inf.portalfiscal.nfe.v100.evento.TProcEvento;
import br.inf.portalfiscal.nfe.v400.autorizacao.TNFe;
import br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc;
import br.inf.portalfiscal.nfe.v400.inutilizacao.TRetInutNFe;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class Controller
extends Database {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getNextNNF() throws Exception {
        if ("CTecInf Sistemas Gerenciais - ctecinf.com.br (PENDRIVE)".contains("PENDRIVE")) {
            DB_NAME = Config.get("db.name.migrate");
        }
        String query = "SELECT MAX(nnf) FROM nfe WHERE serie = '" + Empresa.getSerie() + "' AND tp_amb = " + Config.get("nfe.amb");
        try (Connection conn = Controller.openConnection();
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                Long l = rs.getLong(1) + 1L;
                return l;
            }
        }
        finally {
            DB_NAME = Config.get("db.name");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> getXMLFiles(Calendar dt) throws Exception, IOException {
        if ("CTecInf Sistemas Gerenciais - ctecinf.com.br (PENDRIVE)".contains("PENDRIVE")) {
            DB_NAME = Config.get("db.name.migrate");
        }
        dt.set(5, dt.getActualMinimum(5));
        Date start = new Date(dt.getTimeInMillis());
        dt.set(5, dt.getActualMaximum(5));
        Date end = new Date(dt.getTimeInMillis());
        String between = " BETWEEN '" + String.valueOf(start) + "' AND DATEADD(1 DAY TO DATE '" + String.valueOf(end) + "') ";
        String query = "SELECT nfe.xml_path, nfe_evento.xml_path, EXTRACT(MONTH FROM nfe.data_emissao), EXTRACT(YEAR FROM nfe.data_emissao), nfe.xml FROM nfe LEFT JOIN nfe_evento ON nfe_evento.nfe_id = nfe.id WHERE nfe.data_emissao " + between + " AND nfe.tp_amb=" + Config.get("nfe.amb");
        String mes = "";
        String ano = "";
        ArrayList<File> files = new ArrayList<File>();
        try (Connection conn = Controller.openConnection();
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                File file = new File(rs.getString(1));
                if (!file.exists()) {
                    Utils.writeFile(rs.getString(1), rs.getString(5));
                }
                files.add(file);
                String ev = rs.getString(2);
                if (ev != null && !ev.isEmpty()) {
                    files.add(new File(ev));
                }
                if (!mes.isEmpty() || !ano.isEmpty()) continue;
                mes = rs.getString(3);
                ano = rs.getString(4);
            }
        }
        finally {
            DB_NAME = Config.get("db.name");
        }
        return files;
    }

    public static TableModel getNFCeEmitidas() throws Exception {
        if ("CTecInf Sistemas Gerenciais - ctecinf.com.br (PENDRIVE)".contains("PENDRIVE")) {
            DB_NAME = Config.get("db.name.migrate");
        }
        String query = "SELECT t.data_emissao AS \"Data\", t.versao AS \"Vers\u00e3o\", t.nnf AS \"Num. NFCe\", CASE WHEN t.cancelada=1 THEN 'Sim' ELSE '' END AS \"Cancelada\", t.chave_acesso AS \"Chave de Acesso\", t.cliente AS \"CPF\", CASE WHEN t.cancelada=1 THEN (SELECT xml_path FROM nfe_evento WHERE nfe_id=t.id) ELSE t.xml_path END AS \"Arquivo\", t.qr_code AS \"URL\", CASE WHEN t.cancelada=1 THEN (SELECT xml FROM nfe_evento WHERE nfe_id=t.id) ELSE t.xml END AS \"XML\" FROM nfe t WHERE t.tp_amb=" + Config.get("nfe.amb") + " ORDER BY t.data_emissao DESC";
        try {
            TableModel tableModel = Controller.getTableModel(query);
            return tableModel;
        }
        finally {
            DB_NAME = Config.get("db.name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableModel getQuebraSequencia() throws Exception {
        if ("CTecInf Sistemas Gerenciais - ctecinf.com.br (PENDRIVE)".contains("PENDRIVE")) {
            DB_NAME = Config.get("db.name.migrate");
        }
        String query = "SELECT sequence_value FROM number_sequence(1, (SELECT MAX(nnf) FROM nfe WHERE tp_amb='" + Config.get("nfe.amb") + "')) WHERE sequence_value NOT IN (SELECT nnf FROM nfe WHERE tp_amb='" + Config.get("nfe.amb") + "')";
        TableModel<Object[]> model = new TableModel<Object[]>();
        model.addColumn("N\u00famero Inicial", String.class);
        model.addColumn("N\u00famero Final", String.class);
        try (Connection conn = Controller.openConnection();
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                Long num = rs.getLong(1);
                Object[] row = new Object[2];
                row[0] = rs.getLong(1);
                while (rs.next()) {
                    if (num + 1L != rs.getLong(1)) {
                        row[1] = num;
                        model.addRow(row);
                        row = new Object[2];
                        row[0] = rs.getLong(1);
                    }
                    num = rs.getLong(1);
                }
                row[1] = num;
                model.addRow(row);
            }
        }
        finally {
            DB_NAME = Config.get("db.name");
        }
        return model;
    }

    public static TableModel getNFCeRejeitadas() throws Exception {
        if ("CTecInf Sistemas Gerenciais - ctecinf.com.br (PENDRIVE)".contains("PENDRIVE")) {
            DB_NAME = Config.get("db.name.migrate");
        }
        String query = "SELECT t.data_emissao AS \"Data\", t.versao AS \"Vers\u00e3o\", t.nnf AS \"Num. NFCe\", t.motivo AS \"Motivo\", t.cliente AS \"CPF\", t.xml AS \"XML\", t.qr_code AS \"URL\" FROM nfe_rejeitada t WHERE t.tp_amb=" + Config.get("nfe.amb") + " ORDER BY t.data_emissao DESC";
        try {
            TableModel tableModel = Controller.getTableModel(query);
            return tableModel;
        }
        finally {
            DB_NAME = Config.get("db.name");
        }
    }

    public static TableModel getVendas(Calendar dt) throws Exception {
        if ("CTecInf Sistemas Gerenciais - ctecinf.com.br (PENDRIVE)".contains("PENDRIVE")) {
            DB_NAME = Config.get("db.name.migrate");
        }
        dt.set(5, dt.getActualMinimum(5));
        Date start = new Date(dt.getTimeInMillis());
        dt.set(5, dt.getActualMaximum(5));
        Date end = new Date(dt.getTimeInMillis());
        String between = "nfe.data_emissao BETWEEN '" + String.valueOf(start) + "' AND DATEADD(1 DAY TO DATE '" + String.valueOf(end) + "') AND nfe.tp_amb = '" + Config.get("nfe.amb") + "' ";
        String query = "SELECT r.DESCRICAO AS \"Forma de Pagamento\", SUM(r.VALOR) AS \"Sub-Total\" FROM nfe_pagamento r LEFT JOIN nfe ON nfe.id = r.nfe_id WHERE NOT (nfe.xml LIKE '%<xProd>PAGAMENTO ANTECIPADO</xProd>%') AND " + between + "GROUP BY r.DESCRICAO ORDER BY r.DESCRICAO";
        return Controller.getTableModel(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableModel getSaidaNCM(Calendar dt) throws Exception {
        dt.set(5, dt.getActualMinimum(5));
        Date start = new Date(dt.getTimeInMillis());
        dt.set(5, dt.getActualMaximum(5));
        Date end = new Date(dt.getTimeInMillis());
        String between = "nfe.data_emissao BETWEEN '" + String.valueOf(start) + "' AND DATEADD(1 DAY TO DATE '" + String.valueOf(end) + "') AND nfe.tp_amb = '" + Config.get("nfe.amb") + "' ";
        String query = "SELECT (SELECT descricao FROM ncm WHERE r.NCM_ID=ncm.id) AS \"NCM\", SUM(r.QTD_COM) AS \"Quantiade\", r.UND_COM AS \"Un. Comercial\" FROM nfe_produto r LEFT JOIN nfe ON nfe.id = r.nfe_id WHERE " + between + "GROUP BY r.NCM_ID, r.UND_COM ORDER BY r.NCM_ID";
        try {
            TableModel tableModel = Controller.getTableModel(query);
            return tableModel;
        }
        finally {
            DB_NAME = Config.get("db.name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXMLProc(Object nnf) throws Exception {
        if ("CTecInf Sistemas Gerenciais - ctecinf.com.br (PENDRIVE)".contains("PENDRIVE")) {
            DB_NAME = Config.get("db.name.migrate");
        }
        String query = "SELECT nf.XML FROM NFE nf WHERE nf.NNF=" + String.valueOf(nnf) + " AND tp_amb=" + Config.get("nfe.amb");
        try (Connection conn = Controller.openConnection();
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        finally {
            DB_NAME = Config.get("db.name");
        }
        throw new Exception("Registro n\u00e3o encontrado.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getIdLoteEvento() throws Exception {
        if ("CTecInf Sistemas Gerenciais - ctecinf.com.br (PENDRIVE)".contains("PENDRIVE")) {
            DB_NAME = Config.get("db.name.migrate");
        }
        String query = "SELECT MAX(id_lote) FROM nfe_evento WHERE tp_amb=" + Config.get("nfe.amb");
        try (Connection conn = Controller.openConnection();
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                Long l = rs.getLong(1) + 1L;
                return l;
            }
        }
        finally {
            DB_NAME = Config.get("db.name");
        }
        throw new Exception("Registro n\u00e3o encontrado.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getIdNFCe(String chaveAcesso) throws Exception {
        if ("CTecInf Sistemas Gerenciais - ctecinf.com.br (PENDRIVE)".contains("PENDRIVE")) {
            DB_NAME = Config.get("db.name.migrate");
        }
        String query = "SELECT id FROM nfe WHERE tp_amb=" + Config.get("nfe.amb") + " AND chave_acesso = '" + chaveAcesso.replace("NFe", "").trim() + "'";
        try (Connection conn = Controller.openConnection();
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                Long l = rs.getLong(1);
                return l;
            }
        }
        finally {
            DB_NAME = Config.get("db.name");
        }
        throw new Exception("Registro n\u00e3o encontrado.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getNumeroAutorizacaoNFCe(String chaveAcesso) throws Exception {
        if ("CTecInf Sistemas Gerenciais - ctecinf.com.br (PENDRIVE)".contains("PENDRIVE")) {
            DB_NAME = Config.get("db.name.migrate");
        }
        String query = "SELECT numero_autorizacao FROM nfe WHERE tp_amb=" + Config.get("nfe.amb") + " AND chave_acesso = '" + chaveAcesso.replace("NFe", "").trim() + "'";
        try (Connection conn = Controller.openConnection();
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                Long l = rs.getLong(1);
                return l;
            }
        }
        finally {
            DB_NAME = Config.get("db.name");
        }
        throw new Exception("Registro n\u00e3o encontrado.");
    }

    public static void saveEvento(Long loteId, TProcEvento procEvento, String xmlProc, String xmlPath) throws Exception {
        if ("CTecInf Sistemas Gerenciais - ctecinf.com.br (PENDRIVE)".contains("PENDRIVE")) {
            DB_NAME = Config.get("db.name.migrate");
        }
        String tpAmb = Config.get("nfe.amb");
        String versao = procEvento.getVersao();
        String nProt = procEvento.getRetEvento().getInfEvento().getNProt();
        String chaveAcesso = procEvento.getRetEvento().getInfEvento().getChNFe();
        Timestamp ts = new Timestamp(Utils.dateNFe2Date(procEvento.getRetEvento().getInfEvento().getDhRegEvento()).getTime().getTime());
        Long nfeId = Controller.getIdNFCe(chaveAcesso);
        String sql = "INSERT INTO nfe_evento (versao, tp_amb, data_evento, id_lote, chave_acesso_nfe, xml_path, xml, numero_protocolo, nfe_id) VALUES ('" + versao + "', " + tpAmb + ", '" + String.valueOf(ts) + "', " + loteId + ", '" + chaveAcesso + "', '" + xmlPath + "', '" + xmlProc + "', '" + nProt + "', " + nfeId + ")";
        Controller.executeUpdate(sql);
        sql = "UPDATE nfe SET cancelada = '1' WHERE id=" + nfeId;
        Controller.executeUpdate(sql);
        DB_NAME = Config.get("db.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveInutilizacao(TRetInutNFe retInutNFe, String xmlPath, String xmlProc) throws Exception {
        if ("CTecInf Sistemas Gerenciais - ctecinf.com.br (PENDRIVE)".contains("PENDRIVE")) {
            DB_NAME = Config.get("db.name.migrate");
        }
        String tpAmb = Config.get("nfe.amb");
        String nAut = retInutNFe.getInfInut().getNProt();
        String serie = retInutNFe.getInfInut().getSerie();
        String versao = retInutNFe.getVersao();
        Timestamp ts = new Timestamp(Utils.dateNFe2Date(retInutNFe.getInfInut().getDhRecbto()).getTime().getTime());
        int nnfIni = Integer.parseInt(retInutNFe.getInfInut().getNNFIni());
        int nnfFim = Integer.parseInt(retInutNFe.getInfInut().getNNFFin());
        try (Connection conn = Controller.openConnection();
             Statement st = conn.createStatement();){
            for (int nnf = nnfIni; nnf <= nnfFim; ++nnf) {
                String sql = "INSERT INTO nfe (versao, serie, tp_amb, data_emissao, nnf, xml_path, xml, numero_autorizacao, chave_acesso, cliente, qr_code) VALUES ('" + versao + "', '" + serie + "', " + tpAmb + ", '" + String.valueOf(ts) + "', " + nnf + ", '" + xmlPath + "', '" + xmlProc + "', '" + nAut + "', 'NFC-e INUTILIZADA', null, null)";
                st.executeUpdate(sql);
            }
        }
        finally {
            DB_NAME = Config.get("db.name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean importarNFCe(File xmlFile) throws Exception {
        block55: {
            if ("CTecInf Sistemas Gerenciais - ctecinf.com.br (PENDRIVE)".contains("PENDRIVE")) {
                DB_NAME = Config.get("db.name.migrate");
            }
            TNfeProc nfeProc = Utils.unmarshaller(TNfeProc.class, Utils.readFile(xmlFile));
            int tpAmb = Integer.parseInt(nfeProc.getNFe().getInfNFe().getIde().getTpAmb());
            String nnf = nfeProc.getNFe().getInfNFe().getIde().getNNF();
            String version = nfeProc.getNFe().getInfNFe().getVersao();
            String serie = nfeProc.getNFe().getInfNFe().getIde().getSerie();
            String nAut = nfeProc.getProtNFe().getInfProt().getNProt();
            Calendar cal = Utils.dateNFe2Date(nfeProc.getNFe().getInfNFe().getIde().getDhEmi());
            String xmlProc = Utils.marshaller(nfeProc);
            File file = new File(NFCe.getProcNFePath(cal), nAut + "_v" + version + "-procNFe.xml");
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file, false)));){
                    out.println(xmlProc);
                }
            }
            File pdf = DanfePDF.createFile(file);
            if (nfeProc.getNFe().getInfNFe().getDest() == null || nfeProc.getNFe().getInfNFe().getDest().getEmail() == null || !nfeProc.getNFe().getInfNFe().getDest().getEmail().isEmpty()) {
                // empty if block
            }
            try (Connection conn = Controller.openConnection();){
                Statement st;
                String chaveAcesso = nfeProc.getNFe().getInfNFe().getId().replace("NFe", "");
                Timestamp ts = new Timestamp(Utils.dateNFe2Date(nfeProc.getNFe().getInfNFe().getIde().getDhEmi()).getTime().getTime());
                Object cliente = "NULL";
                String qrCode = nfeProc.getNFe().getInfNFeSupl().getQrCode();
                if (nfeProc.getNFe().getInfNFe().getDest() != null) {
                    if (nfeProc.getNFe().getInfNFe().getDest().getCPF() != null) {
                        cliente = "'" + nfeProc.getNFe().getInfNFe().getDest().getCPF() + "'";
                    }
                    if (nfeProc.getNFe().getInfNFe().getDest().getIdEstrangeiro() != null) {
                        cliente = "'" + nfeProc.getNFe().getInfNFe().getDest().getIdEstrangeiro() + "'";
                    }
                    Object nome = "NULL";
                    Object email = "NULL";
                    if (nfeProc.getNFe().getInfNFe().getDest().getXNome() != null) {
                        nome = "'" + nfeProc.getNFe().getInfNFe().getDest().getXNome() + "'";
                    }
                    if (nfeProc.getNFe().getInfNFe().getDest().getEmail() != null) {
                        email = "'" + nfeProc.getNFe().getInfNFe().getDest().getEmail() + "'";
                    }
                    try {
                        st = conn.createStatement();
                        try {
                            st.executeUpdate("INSERT INTO cliente (id, nome, cpf, email, data_cadastro) VALUES (GEN_ID(SEQ_CLIENTE_ID, 1), " + (String)nome + ", " + (String)cliente + ", " + (String)email + ", '" + String.valueOf(ts) + "')");
                        }
                        finally {
                            if (st != null) {
                                st.close();
                            }
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("Cliente j\u00e1 cadastrado.");
                    }
                }
                Long nfeId = null;
                try (Statement st2 = conn.createStatement();
                     ResultSet rs = st2.executeQuery("SELECT id FROM NFE WHERE NNF=" + nnf);){
                    if (rs.next()) {
                        nfeId = rs.getLong(1);
                    }
                }
                if (nfeId != null) {
                    Controller.importPagProd(conn, nfeId, nfeProc);
                    break block55;
                }
                String sql = "INSERT INTO nfe (id, versao, serie, tp_amb, data_emissao, nnf, xml_path, xml, numero_autorizacao, chave_acesso, cliente, qr_code) VALUES (GEN_ID(SEQ_NFE_ID, 1), '" + version + "', '" + serie + "', " + tpAmb + ", '" + String.valueOf(ts) + "', " + nnf + ", '" + file.getPath() + "', '" + xmlProc + "', '" + nAut + "', '" + chaveAcesso + "', " + (String)cliente + ", '" + qrCode + "')";
                st = conn.createStatement();
                try {
                    st.executeUpdate(sql, 1);
                    ResultSet rs = st.getGeneratedKeys();
                    if (rs.next()) {
                        Controller.importPagProd(conn, rs.getLong(1), nfeProc);
                    }
                }
                finally {
                    if (st != null) {
                        st.close();
                    }
                }
            }
            finally {
                DB_NAME = Config.get("db.name");
            }
        }
        return true;
    }

    private static void importPagProd(Connection conn, Long nfeId, TNfeProc nfeProc) throws SQLException {
        if (nfeId != null) {
            Statement st1;
            ResultSet rs;
            boolean exist = false;
            try (Object st = conn.createStatement();){
                rs = st.executeQuery("SELECT id FROM nfe_pagamento WHERE nfe_id=" + nfeId);
                try {
                    if (rs.next()) {
                        exist = true;
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            if (!exist) {
                for (TNFe.InfNFe.Pag.DetPag pag : nfeProc.getNFe().getInfNFe().getPag().getDetPag()) {
                    String sql1 = pag.getTPag().equalsIgnoreCase("03") ? "INSERT INTO nfe_pagamento (id, descricao, valor, nfe_id) VALUES (GEN_ID(SEQ_NFE_PAGAMENTO_ID, 1), 'CARTAO CREDITO (" + Controller.getCartao(pag.getCard()) + ")', '" + pag.getVPag() + "', '" + nfeId + "')" : (pag.getTPag().equalsIgnoreCase("04") ? "INSERT INTO nfe_pagamento (id, descricao, valor, nfe_id) VALUES (GEN_ID(SEQ_NFE_PAGAMENTO_ID, 1), 'CARTAO DEBITO (" + Controller.getCartao(pag.getCard()) + ")', '" + pag.getVPag() + "', '" + nfeId + "')" : (pag.getTPag().equalsIgnoreCase("02") ? "INSERT INTO nfe_pagamento (id, descricao, valor, nfe_id) VALUES (GEN_ID(SEQ_NFE_PAGAMENTO_ID, 1), 'CHEQUE', '" + pag.getVPag() + "', '" + nfeId + "')" : (pag.getTPag().equalsIgnoreCase("05") ? "INSERT INTO nfe_pagamento (id, descricao, valor, nfe_id) VALUES (GEN_ID(SEQ_NFE_PAGAMENTO_ID, 1), 'P/ CONTA ENCOMENDA', '" + pag.getVPag() + "', '" + nfeId + "')" : (pag.getTPag().equalsIgnoreCase("01") ? "INSERT INTO nfe_pagamento (id, descricao, valor, nfe_id) VALUES (GEN_ID(SEQ_NFE_PAGAMENTO_ID, 1), 'DINHEIRO', '" + pag.getVPag() + "', '" + nfeId + "')" : (pag.getTPag().equalsIgnoreCase("17") ? "INSERT INTO nfe_pagamento (id, descricao, valor, nfe_id) VALUES (GEN_ID(SEQ_NFE_PAGAMENTO_ID, 1), 'PIX', '" + pag.getVPag() + "', '" + nfeId + "')" : (pag.getTPag().equalsIgnoreCase("16") ? "INSERT INTO nfe_pagamento (id, descricao, valor, nfe_id) VALUES (GEN_ID(SEQ_NFE_PAGAMENTO_ID, 1), 'DEPOSITO BANCARIO', '" + pag.getVPag() + "', '" + nfeId + "')" : "INSERT INTO nfe_pagamento (id, descricao, valor, nfe_id) VALUES (GEN_ID(SEQ_NFE_PAGAMENTO_ID, 1), 'OUTROS', '" + pag.getVPag() + "', '" + nfeId + "')"))))));
                    try {
                        st1 = conn.createStatement();
                        try {
                            st1.executeUpdate(sql1);
                        }
                        finally {
                            if (st1 != null) {
                                st1.close();
                            }
                        }
                    }
                    catch (Exception ex) {
                        Log.create(ex);
                    }
                }
            }
            exist = false;
            st = conn.createStatement();
            try {
                rs = st.executeQuery("SELECT id FROM nfe_produto WHERE nfe_id=" + nfeId);
                try {
                    if (rs.next()) {
                        exist = true;
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
            if (!exist) {
                for (TNFe.InfNFe.Det det : nfeProc.getNFe().getInfNFe().getDet()) {
                    TNFe.InfNFe.Det.Prod prod;
                    block66: {
                        prod = det.getProd();
                        st1 = conn.createStatement();
                        try (ResultSet rs2 = st1.executeQuery("SELECT * FROM produto WHERE id=" + prod.getCProd());){
                            if (rs2.next()) break block66;
                            try (Statement st2 = conn.createStatement();){
                                String sql = "INSERT INTO PRODUTO (ID, DESCRICAO, VALOR_UNITARIO, ALIQUOTA, UND_COM, CFOP_ID,    NCM_ID, ICMS_ID, ICMS_ORIGEM_ID, ULTIMA_ATUALIZACAO) VALUES (    '" + prod.getCProd() + "',     '" + prod.getXProd() + "',     '" + prod.getVUnCom() + "',     '35.49',     '" + prod.getUCom() + "',     '" + prod.getCFOP() + "',     '" + prod.getNCM() + "',     '102',     '0',     '" + String.valueOf(new Date(System.currentTimeMillis())) + "')";
                                st2.executeUpdate(sql);
                            }
                        }
                        finally {
                            if (st1 != null) {
                                st1.close();
                            }
                        }
                    }
                    try {
                        st1 = conn.createStatement();
                        try {
                            st1.executeUpdate("INSERT INTO NFE_PRODUTO (ID, PRODUTO_ID, NCM_ID, UND_COM, QTD_COM, VALOR_UNIT,NFE_ID) VALUES (GEN_ID(SEQ_NFE_PRODUTO_ID, 1), '" + prod.getCProd() + "', '" + prod.getNCM() + "', '" + prod.getUCom() + "', '" + prod.getQCom() + "', '" + prod.getVUnCom() + "', '" + nfeId + "')");
                        }
                        finally {
                            if (st1 == null) continue;
                            st1.close();
                        }
                    }
                    catch (Exception ex) {
                        Log.create(ex);
                    }
                }
            }
        }
    }

    private static String getCartao(TNFe.InfNFe.Pag.DetPag.Card card) {
        for (Cartao c : Cartao.CARTOES) {
            if (card.getTBand().equals("99") && card.getCNPJ().equals("92934215000106")) {
                return Cartao.banricomprasInstance().toString();
            }
            if (card.getTBand().equals("99") && card.getCNPJ().equals("01722480000167")) {
                return Cartao.verdecardInstance().toString();
            }
            if (!card.getTBand().equalsIgnoreCase(c.gettBand())) continue;
            return c.toString();
        }
        Cartao c = new Cartao();
        c.setCnpj(card.getCNPJ());
        c.setcAut(card.getCAut());
        c.setTpIntegra(Integer.parseInt(card.getTpIntegra()));
        c.settBand(card.getTBand());
        return c.toString();
    }
}

