/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.autocomplete;

import br.com.ctecinf.orm.Model;
import br.com.ctecinf.swing.ListModel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;

public class AutoCompleteModel<T>
extends ListModel<T> {
    public static int NUM_RESULT_SHOW = 8;
    private List<T> list;
    private boolean isLoaded = false;

    public AutoCompleteModel() {
        this(new ArrayList());
    }

    public AutoCompleteModel(List<T> list) {
        this.list = Collections.synchronizedList(new ArrayList<T>(list));
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void endLoad() {
        this.isLoaded = true;
    }

    public void addToSearch(T item) {
        this.getData().add(item);
    }

    @Override
    public void add(T item) {
        super.add(item);
        this.list.add(item);
        this.fireIntervalAdded(this, this.list.size() - 1, this.list.size() - 1);
    }

    @Override
    public void removeAll() {
        if (this.list != null && !this.list.isEmpty()) {
            this.fireIntervalRemoved(this, 0, this.list.size() - 1);
            this.list = Collections.synchronizedList(new ArrayList());
        }
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.list.get(index);
    }

    public void filter(String value) {
        this.removeAll();
        for (T c : this.search(value)) {
            this.add(c);
        }
    }

    private List<T> search(String value) {
        ArrayList founds = new ArrayList();
        try {
            for (Object obj : this.getData()) {
                if (this.check(obj, value)) {
                    founds.add(obj);
                }
                if (founds.size() != NUM_RESULT_SHOW) continue;
                Collections.sort(founds, new Comparator<T>(){

                    @Override
                    public int compare(T o1, T o2) {
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        return o1.toString().compareToIgnoreCase(o2.toString());
                    }
                });
                return founds;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return founds;
    }

    private boolean check(Object obj, String value) {
        if (obj == null) {
            return false;
        }
        if (value == null) {
            return false;
        }
        boolean check = false;
        if (obj instanceof Map) {
            if (value.substring(0, 1).equalsIgnoreCase("%")) {
                for (Object vl : ((Map)obj).values()) {
                    if (vl == null || vl.toString().toLowerCase().indexOf(value.substring(1).toLowerCase()) <= 0) continue;
                    check = true;
                    break;
                }
            } else {
                for (Object vl : ((Map)obj).values()) {
                    if (vl == null || vl.toString().toLowerCase().indexOf(value.toLowerCase()) != 0) continue;
                    check = true;
                    break;
                }
            }
        } else if (obj instanceof Model) {
            if (value.substring(0, 1).equalsIgnoreCase("%")) {
                if (obj.getClass().getSuperclass().isAssignableFrom(Model.class)) {
                    try {
                        Field field = obj.getClass().getSuperclass().getDeclaredField("id");
                        field.setAccessible(true);
                        Object vl = field.get(obj);
                        if (vl != null && vl.toString().toLowerCase().indexOf(value.substring(1).toLowerCase()) > 0) {
                            check = true;
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                        System.err.println(ex);
                    }
                }
                if (!check) {
                    for (Field field : obj.getClass().getDeclaredFields()) {
                        field.setAccessible(true);
                        try {
                            Object vl = field.get(obj);
                            if (vl == null || vl.toString().toLowerCase().indexOf(value.substring(1).toLowerCase()) <= 0) continue;
                            check = true;
                            break;
                        }
                        catch (IllegalAccessException | IllegalArgumentException ex) {
                            System.err.println(ex);
                        }
                    }
                }
            } else {
                if (obj.getClass().getSuperclass().isAssignableFrom(Model.class)) {
                    try {
                        Field field = obj.getClass().getSuperclass().getDeclaredField("id");
                        field.setAccessible(true);
                        Object vl = field.get(obj);
                        if (vl != null && vl.toString().toLowerCase().indexOf(value.toLowerCase()) == 0) {
                            check = true;
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                        System.err.println(ex);
                    }
                }
                if (!check) {
                    for (Field field : obj.getClass().getDeclaredFields()) {
                        field.setAccessible(true);
                        try {
                            Object vl = field.get(obj);
                            if (vl == null || vl.toString().toLowerCase().indexOf(value.toLowerCase()) != 0) continue;
                            check = true;
                            break;
                        }
                        catch (IllegalAccessException | IllegalArgumentException ex) {
                            System.err.println(ex);
                        }
                    }
                }
            }
        } else {
            if (value.substring(0, 1).equalsIgnoreCase("%")) {
                return obj.toString().toLowerCase().indexOf(value.substring(1).toLowerCase()) > 0;
            }
            return obj.toString().toLowerCase().indexOf(value.toLowerCase()) == 0;
        }
        return check;
    }
}

