/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf.autocomplete;

import br.com.ctecinf.autocomplete.AutoCompleteModel;
import br.com.ctecinf.event.SelectEvent;
import br.com.ctecinf.event.SelectListener;
import br.com.ctecinf.text.UpperCaseFormatter;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class AutoCompleteField<T>
extends JFormattedTextField
implements FocusListener {
    private JList<T> list;
    private JPopupMenu popup;
    private SelectListener listener;
    private JPopupMenu wait;

    public AutoCompleteField() {
        this(null, new AutoCompleteModel(), null, null);
    }

    public AutoCompleteField(AutoCompleteModel<T> model) {
        this(null, model, null, null);
    }

    public AutoCompleteField(String name, AutoCompleteModel<T> model) {
        this(name, model, null, null);
    }

    public AutoCompleteField(AutoCompleteModel<T> model, JFormattedTextField.AbstractFormatter formatter) {
        this(null, model, null, formatter);
    }

    public AutoCompleteField(String name, AutoCompleteModel<T> model, JFormattedTextField.AbstractFormatter formatter) {
        this(name, model, null, formatter);
    }

    public AutoCompleteField(String name, AutoCompleteModel<T> model, T selectedValue) {
        this(name, model, selectedValue, null);
    }

    public AutoCompleteField(String name, AutoCompleteModel<T> model, T selectedValue, JFormattedTextField.AbstractFormatter formatter) {
        super(formatter == null ? new UpperCaseFormatter() : formatter);
        if (name != null) {
            super.setName(name);
        }
        this.list = new JList<T>(model);
        this.setValue(selectedValue);
        this.initUI();
    }

    private void initUI() {
        this.setMargin(new Insets(1, 1, 1, 1));
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(8);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (AutoCompleteField.this.listener != null) {
                        AutoCompleteField.this.listener.onSelected(new SelectEvent(AutoCompleteField.this, e.getID(), AutoCompleteField.this.list.getSelectedValue()));
                    }
                    AutoCompleteField.this.setValue(AutoCompleteField.this.list.getSelectedValue());
                    AutoCompleteField.this.popup.setVisible(false);
                }
            }
        });
        this.popup = new JPopupMenu();
        this.popup.setOpaque(false);
        this.popup.add(new JScrollPane(this.list));
        super.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (AutoCompleteField.this.getModel().isLoaded()) {
                    if (AutoCompleteField.this.wait != null) {
                        AutoCompleteField.this.wait.setVisible(false);
                    }
                    if (e.getKeyCode() == 40 && AutoCompleteField.this.popup.isVisible()) {
                        int index = AutoCompleteField.this.list.getSelectedIndex();
                        if (++index == AutoCompleteField.this.list.getModel().getSize()) {
                            index = 0;
                        }
                        AutoCompleteField.this.list.setSelectedIndex(index);
                    } else if (e.getKeyCode() == 38 && AutoCompleteField.this.popup.isVisible()) {
                        int index = AutoCompleteField.this.list.getSelectedIndex();
                        if (--index == -1) {
                            index = AutoCompleteField.this.list.getModel().getSize() - 1;
                        }
                        AutoCompleteField.this.list.setSelectedIndex(index);
                    } else if (e.getKeyCode() == 10 && AutoCompleteField.this.popup.isVisible() && AutoCompleteField.this.list.getSelectedIndex() > -1) {
                        if (AutoCompleteField.this.listener != null) {
                            AutoCompleteField.this.listener.onSelected(new SelectEvent(AutoCompleteField.this, e.getID(), AutoCompleteField.this.list.getSelectedValue()));
                        }
                        AutoCompleteField.this.setValue(AutoCompleteField.this.list.getSelectedValue());
                        AutoCompleteField.this.popup.setVisible(false);
                    } else if (AutoCompleteField.this.getText().length() > 0) {
                        AutoCompleteField.this.getModel().filter(AutoCompleteField.this.getText());
                        if (AutoCompleteField.this.getModel().isEmpty()) {
                            AutoCompleteField.this.popup.setVisible(false);
                        } else {
                            AutoCompleteField.this.popup.revalidate();
                            AutoCompleteField.this.popup.repaint();
                            AutoCompleteField.this.popup.setLocation(AutoCompleteField.this.getLocationOnScreen().x, AutoCompleteField.this.getLocationOnScreen().y + AutoCompleteField.this.getHeight());
                            AutoCompleteField.this.popup.setVisible(true);
                        }
                    } else {
                        AutoCompleteField.this.popup.setVisible(false);
                    }
                } else if (AutoCompleteField.this.wait == null) {
                    AutoCompleteField.this.wait = new JPopupMenu();
                    AutoCompleteField.this.wait.setOpaque(false);
                    AutoCompleteField.this.wait.add("Aguarde Carregando...");
                    AutoCompleteField.this.wait.setLocation(AutoCompleteField.this.getLocationOnScreen().x, AutoCompleteField.this.getLocationOnScreen().y + AutoCompleteField.this.getHeight());
                    AutoCompleteField.this.wait.setVisible(true);
                }
            }
        });
        this.addFocusListener(this);
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.popup.setVisible(false);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.selectAll();
    }

    public T getValue() {
        return (T)super.getValue();
    }

    public AutoCompleteModel<T> getModel() {
        return (AutoCompleteModel)this.list.getModel();
    }

    public void setModel(AutoCompleteModel<T> model) {
        this.list.setModel(model);
    }

    public void addSelectListener(SelectListener sl) {
        this.listener = sl;
    }
}

