/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf;

import java.awt.FontMetrics;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class Utils {
    private static final JFormattedTextField TEXT_FIELD = new JFormattedTextField();

    public static String hexa(String value) {
        Object digVal = "";
        for (int i = 0; i < value.length(); ++i) {
            digVal = (String)digVal + Integer.toHexString(value.charAt(i));
        }
        return digVal;
    }

    public static String sha1(String value) throws NoSuchAlgorithmException {
        byte[] messageDigest = MessageDigest.getInstance("SHA-1").digest(value.getBytes());
        return new BigInteger(1, messageDigest).toString(16);
    }

    public static String md5(String value) throws NoSuchAlgorithmException {
        byte[] messageDigest = MessageDigest.getInstance("MD5").digest(value.getBytes());
        return new BigInteger(1, messageDigest).toString(16);
    }

    public static int modulo11(String chave) {
        int total = 0;
        int peso = 2;
        for (int i = 0; i < chave.length(); ++i) {
            total += (chave.charAt(chave.length() - 1 - i) - 48) * peso;
            if (++peso != 10) continue;
            peso = 2;
        }
        int resto = total % 11;
        return resto == 0 || resto == 1 ? 0 : 11 - resto;
    }

    public static boolean isCPF(String cpf) {
        if (cpf == null) {
            return false;
        }
        if ((cpf = cpf.replace(".", "").replace(" ", "").replace("-", "")).equals("00000000000") || cpf.equals("11111111111") || cpf.equals("22222222222") || cpf.equals("33333333333") || cpf.equals("44444444444") || cpf.equals("55555555555") || cpf.equals("66666666666") || cpf.equals("77777777777") || cpf.equals("88888888888") || cpf.equals("99999999999") || cpf.length() != 11) {
            return false;
        }
        try {
            int num;
            int i;
            int sm = 0;
            int peso = 10;
            for (i = 0; i < 9; ++i) {
                num = cpf.charAt(i) - 48;
                sm += num * peso;
                --peso;
            }
            int r = 11 - sm % 11;
            char dig10 = r == 10 || r == 11 ? (char)'0' : (char)((char)(r + 48));
            sm = 0;
            peso = 11;
            for (i = 0; i < 10; ++i) {
                num = cpf.charAt(i) - 48;
                sm += num * peso;
                --peso;
            }
            r = 11 - sm % 11;
            char dig11 = r == 10 || r == 11 ? (char)'0' : (char)((char)(r + 48));
            return dig10 == cpf.charAt(9) && dig11 == cpf.charAt(10);
        }
        catch (InputMismatchException ex) {
            return false;
        }
    }

    public static String date2NFe() {
        Calendar calendar = Utils.dateFromServer();
        Object format = "yyyy-MM-dd'T'HH:mm:ss";
        format = calendar.get(16) == 0 ? (String)format + "'-03:00'" : (String)format + "'-02:00'";
        SimpleDateFormat df = new SimpleDateFormat((String)format);
        return df.format(calendar.getTime());
    }

    public static Calendar dateNFe2Date(String date) {
        if (date == null || date.isEmpty()) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date dt = null;
        try {
            dt = df.parse(date.replace("-03:00", "").replace("-02:00", ""));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Calendar cal = Calendar.getInstance(new Locale("pt", "BR"));
        cal.setTime(dt);
        return cal;
    }

    public static Calendar dateFromServer() {
        Calendar c = Calendar.getInstance(new Locale("pt", "BR"));
        try {
            String server = "http://ctecinf.com.br/current_time_millis.php";
            URL url = new URL(server);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(4000);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String str = reader.readLine();
            c.setTimeInMillis(Long.parseLong(str));
        }
        catch (IOException | NumberFormatException exception) {
            // empty catch block
        }
        return c;
    }

    public static String perc2String(double value) {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getPercentInstance(new Locale("pt", "BR"));
        df.setMaximumFractionDigits(2);
        return df.format(value / 100.0);
    }

    public static DecimalFormat decimalFormat2Digits() {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.US);
        df.setGroupingUsed(false);
        df.setMinimumFractionDigits(2);
        df.setMaximumFractionDigits(2);
        return df;
    }

    public static DecimalFormat decimalFormat4Digits() {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.US);
        df.setGroupingUsed(false);
        df.setMinimumFractionDigits(4);
        df.setMaximumFractionDigits(4);
        return df;
    }

    public static String rightPad2(Object input, int width, char ch) {
        StringBuilder sb = new StringBuilder(String.valueOf(input).trim());
        while (sb.length() < width) {
            sb.insert(sb.length(), ch);
        }
        String strPad = sb.toString();
        if (strPad.length() > width) {
            strPad = strPad.substring(0, width);
        }
        return strPad;
    }

    public static String leftPad2(Object input, int width, char ch) {
        StringBuilder sb = new StringBuilder(String.valueOf(input).trim());
        while (sb.length() < width) {
            sb.insert(0, ch);
        }
        String strPad = sb.toString();
        if (strPad.length() > width) {
            strPad = strPad.substring(0, width);
        }
        return strPad;
    }

    public static <T> T unmarshaller(Class<? extends T> model, String xml) throws JAXBException {
        return (T)JAXBContext.newInstance((Class[])new Class[]{model}).createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
    }

    public static String marshaller(Object obj) throws JAXBException, IOException {
        Class<?> model = obj.getClass();
        if (!model.isAnnotationPresent(XmlRootElement.class)) {
            throw new JAXBException("Anota\u00e7\u00e3o @XmlRootElement(name=\"***default***\") n\u00e3o definida na classe [" + String.valueOf(obj.getClass()) + "].");
        }
        XmlRootElement qName = model.getAnnotation(XmlRootElement.class);
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{model}).createMarshaller();
        JAXBElement element = new JAXBElement(QName.valueOf(qName.name()), model, obj);
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        try (BufferedOutputStream buff = new BufferedOutputStream(byteArray);){
            marshaller.marshal((Object)element, (OutputStream)buff);
            buff.flush();
        }
        String xml = new String(byteArray.toByteArray());
        xml = xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>", "");
        xml = xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
        xml = xml.replace(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        xml = xml.replace(" xmlns:ns3=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        xml = xml.replace("ns2:", "");
        xml = xml.replace(":ns2", "");
        xml = xml.replace("ns3:", "");
        xml = xml.replace(":ns3", "");
        xml = xml.replace("<Signature>", "<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">");
        return xml;
    }

    public static String doc2Str(Document document) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(document), new StreamResult(os));
        String xml = os.toString();
        xml = xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
        xml = xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>", "");
        xml = xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
        xml = xml.replace("<Signature>", "<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">");
        return xml;
    }

    public static Document str2Doc(String str) throws Exception {
        DocumentBuilderFactory builder = DocumentBuilderFactory.newInstance();
        builder.setNamespaceAware(true);
        return builder.newDocumentBuilder().parse(new ByteArrayInputStream(str.getBytes()));
    }

    public static String ascii(String text, boolean upperCase) {
        return Normalizer.normalize(upperCase ? text.toUpperCase() : text, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
    }

    public static String inputStream2String(InputStream inputStream) throws IOException {
        StringBuilder str = new StringBuilder("");
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 1);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                str.append(line).append("\n");
            }
        }
        return str.toString().isEmpty() ? null : str.toString();
    }

    public static File writeFile(String path, String content) throws IOException {
        return Utils.writeFile(new File(path), content, false, false);
    }

    public static File writeFile(String path, String content, boolean append) throws IOException {
        return Utils.writeFile(new File(path), content, append, false);
    }

    public static File writeFile(String path, String content, boolean append, boolean appendIni) throws IOException {
        return Utils.writeFile(new File(path), content, append, appendIni);
    }

    public static File writeFile(File file, String content) throws IOException {
        return Utils.writeFile(file, content, false, false);
    }

    public static File writeFile(File file, String content, boolean append) throws IOException {
        return Utils.writeFile(file, content, append, false);
    }

    public static File writeFile(File file, String content, boolean append, boolean appendIni) throws IOException {
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        if (appendIni) {
            String str = Utils.readFile(file);
            content = (String)content + "\n" + str;
            append = false;
        }
        try (PrintWriter p = new PrintWriter(new FileWriter(file, append));){
            p.write((String)content);
        }
        return file;
    }

    public static String readFile(String path) throws IOException {
        return Utils.readFile(new File(path));
    }

    public static String readFile(File file) throws IOException {
        if (file == null || !file.exists()) {
            throw new IOException("Arquivo n\u00e3o encontrado.");
        }
        StringBuilder str = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                str.append(line);
                str.append("\n");
            }
        }
        return str.toString().isEmpty() ? null : str.toString().trim();
    }

    public static byte[] fileToByte(String path) throws IOException {
        return Utils.fileToByte(new File(path));
    }

    public static byte[] fileToByte(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }

    public static String limitWords(String text, int numCharsWord) {
        String[] arr = text.split(" ");
        Object str = "";
        for (String s : arr) {
            str = s.length() > numCharsWord ? (String)str + s.substring(0, 3) + " " : (String)str + s + " ";
        }
        return str;
    }

    public static String getMyIP() {
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                if (netint.isLoopback() || !netint.isUp()) continue;
                Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    if (!inetAddress.isSiteLocalAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException ex) {
            System.err.println(ex);
        }
        return null;
    }

    public static Object clone(Object obj) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(obj);
            oos.flush();
        }
        byte[] bytes = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bis);
        return ois.readObject();
    }

    public static String implode(String glue, String ... arr) {
        return Utils.implode(glue, Arrays.asList(arr));
    }

    public static String implode(String glue, List arr) {
        Object str = "";
        for (int i = 0; i < arr.size(); ++i) {
            str = (String)str + String.valueOf(arr.size() == i + 1 ? arr.get(i) : String.valueOf(arr.get(i)) + glue);
        }
        return str;
    }

    public static int contain(Object value, Object[] list) {
        if (value == null) {
            return -1;
        }
        for (int i = 0; i < list.length; ++i) {
            Object obj = list[i];
            if (obj == null || !obj.toString().equalsIgnoreCase(value.toString())) continue;
            return i;
        }
        return -1;
    }

    public static final List<File> listFiles(String path, final String endsWith) {
        final ArrayList<File> files = new ArrayList<File>();
        try {
            File file = new File("src");
            Files.walkFileTree(file.toPath(), new SimpleFileVisitor(){

                @Override
                public FileVisitResult visitFile(Object file, BasicFileAttributes attrs) throws IOException {
                    if (attrs.isRegularFile() && file.toString().endsWith(endsWith)) {
                        files.add(new File(file.toString()));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        return files;
    }

    public static String cleanPhone(String value) {
        Object str = "";
        if (value == null) {
            return null;
        }
        String[] aux = value.split("/");
        if (aux.length == 1) {
            aux = value.split(" - ");
        }
        for (char c : aux[0].toCharArray()) {
            if (!Character.isDigit(c)) continue;
            str = (String)str + c;
        }
        if (((String)str).equals("0000000000")) {
            return null;
        }
        if (((String)str).startsWith("051") || ((String)str).startsWith("055") || ((String)str).startsWith("053") || ((String)str).startsWith("054") || ((String)str).startsWith("052")) {
            str = ((String)str).substring(1);
        }
        if (((String)str).length() == 8 && (((String)str).startsWith("9") || ((String)str).startsWith("8"))) {
            str = "519" + (String)str;
        }
        if (((String)str).length() == 8) {
            str = "51" + (String)str;
        }
        if (((String)str).length() == 9) {
            str = "51" + (String)str;
        }
        return str;
    }

    public static FontMetrics getFontMetrics() {
        return TEXT_FIELD.getFontMetrics(TEXT_FIELD.getFont());
    }
}

