/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Post {
    private static final String BR = "\r\n";
    private final String boundary = UUID.randomUUID().toString();
    private final HttpURLConnection httpConn;
    private final OutputStream outputStream;
    private final PrintWriter writer;

    public Post(String serverURL, Map<String, String> headers) throws IOException {
        this.httpConn = (HttpURLConnection)new URL(serverURL).openConnection();
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        if (headers != null && !headers.isEmpty()) {
            for (String key : headers.keySet()) {
                String value = headers.get(key);
                this.httpConn.setRequestProperty(key, value);
            }
        }
        this.outputStream = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, Charset.defaultCharset()), true);
    }

    public static final String getUserAgent() {
        return System.getProperty("java.vm.name") + "/" + System.getProperty("java.version") + " (" + System.getProperty("os.name") + "; " + System.getProperty("java.vendor") + "/" + System.getProperty("os.version") + "; " + System.getProperty("user.language") + ")";
    }

    public static Post from(String serverURL) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", Post.getUserAgent());
        return new Post(serverURL, headers);
    }

    public void addData(String name, Object value) throws IOException {
        this.writer.append("--" + this.boundary).append(BR);
        if (value instanceof File) {
            File file = (File)value;
            this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + file.getName() + "\"").append(BR);
            this.writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(file.getName())).append(BR);
            this.writer.append("Content-Transfer-Encoding: binary").append(BR);
            this.writer.append(BR);
            this.writer.flush();
            try (FileInputStream inputStream = new FileInputStream(file);){
                int bytesRead;
                byte[] buffer = new byte[inputStream.available()];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    this.outputStream.write(buffer, 0, bytesRead);
                }
                this.outputStream.flush();
            }
            this.writer.append(BR);
        } else {
            this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(BR);
            this.writer.append("Content-Type: text/plain; charset=" + String.valueOf(Charset.defaultCharset())).append(BR);
            this.writer.append(BR);
            this.writer.append(value == null ? "" : value.toString()).append(BR);
        }
        this.writer.flush();
    }

    public ByteArrayOutputStream finish() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (PrintWriter printWriter = this.writer;){
            this.writer.flush();
            this.writer.append("--" + this.boundary + "--").append(BR);
        }
        if (this.httpConn.getResponseCode() == 200) {
            int length;
            byte[] buffer = new byte[this.httpConn.getInputStream().available()];
            while ((length = this.httpConn.getInputStream().read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
        } else {
            throw new IOException("Server returned non-OK status: " + this.httpConn.getResponseCode());
        }
        this.httpConn.disconnect();
        return result;
    }
}

