/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf;

import br.com.ctecinf.Config;
import br.com.ctecinf.swing.OptionPane;
import br.com.ctecinf.table.Table;
import br.com.ctecinf.text.DateFormatter;
import br.com.ctecinf.text.NumberFormatter;
import br.com.ctecinf.text.TimeFormatter;
import br.com.ctecinf.text.TimestampFormatter;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import javax.swing.JTable;

public class PDF
extends PdfPageEventHelper {
    private Document document;
    private File file;

    public void onStartPage(PdfWriter writer, Document document) {
        try {
            Rectangle pageSize = document.getPageSize();
            PdfContentByte directContent = writer.getDirectContent();
            directContent.setFontAndSize(BaseFont.createFont(), 6.0f);
            directContent.setTextMatrix(pageSize.getLeft(10.0f), pageSize.getBottom(10.0f));
            directContent.showText("ctecinf.com.br - Sistemas gerenciais");
            if (!Config.get("logo.path").isEmpty()) {
                Image img = null;
                File f = new File(Config.get("logo.path"));
                if (f.exists()) {
                    img = Image.getInstance((String)f.getAbsolutePath());
                }
                if (img != null) {
                    img.setAbsolutePosition(pageSize.getLeft(10.0f), pageSize.getTop(35.0f));
                    img.scaleToFit(55.0f, 30.0f);
                    directContent.addImage(img);
                }
            }
        }
        catch (DocumentException | IOException ex) {
            OptionPane.error(ex);
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        int currentPageNumber = writer.getCurrentPageNumber();
        try {
            Rectangle pageSize = document.getPageSize();
            PdfContentByte directContent = writer.getDirectContent();
            directContent.setFontAndSize(BaseFont.createFont(), 8.0f);
            directContent.setTextMatrix(pageSize.getRight(pageSize.getWidth() / 2.0f + 10.0f), pageSize.getBottom(10.0f));
            directContent.showText("P\u00e1gina " + currentPageNumber);
        }
        catch (DocumentException | IOException ex) {
            OptionPane.error(ex);
        }
    }

    public Document open(String fileName) throws DocumentException, FileNotFoundException {
        this.file = new File("pdf", fileName);
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        this.document = new Document(PageSize.A4, 10.0f, 10.0f, 36.0f, 20.0f);
        PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(this.file)).setPageEvent((PdfPageEvent)this);
        this.document.open();
        return this.document;
    }

    public void close() {
        this.document.close();
    }

    public File getFile() {
        return this.file;
    }

    public File parse(JTable table) throws Exception {
        return this.parse(null, table);
    }

    public File parse(String title, JTable table) throws Exception {
        int i;
        if (table.getRowCount() == 0) {
            throw new Exception("Lista vazia.");
        }
        String dt = TimestampFormatter.format().format(new java.util.Date());
        if (title == null) {
            title = "Sistemas Gerenciais - Relat\u00f3rio(" + dt + ")";
        }
        Document doc = this.open(((String)title).replace("Sistemas Gerenciais - ", "").replace("(", "_").replace(")", "_").replace("/", "_").replace(":", "_").replace(" ", "_") + ".pdf");
        Font fontHeader = FontFactory.getFont((String)Font.FontFamily.COURIER.name(), (float)8.0f, (int)1);
        Font fontData = FontFactory.getFont((String)Font.FontFamily.COURIER.name(), (float)8.0f, (int)0);
        Paragraph paragraph = new Paragraph((String)title, fontHeader);
        paragraph.setSpacingAfter(10.0f);
        paragraph.setAlignment(1);
        doc.add((Element)paragraph);
        int[] widths = new int[table.getColumnCount()];
        if (table instanceof Table) {
            for (i = 0; i < table.getColumnCount(); ++i) {
                int w = ((Table)table).getColumnWidth(i);
                widths[i] = w == 0 ? table.getColumn(table.getColumnName(i)).getWidth() : w;
            }
        } else {
            for (i = 0; i < table.getColumnCount(); ++i) {
                widths[i] = table.getColumn(table.getColumnName(i)).getWidth();
            }
        }
        PdfPTable pdfTable = new PdfPTable(table.getColumnCount());
        pdfTable.setWidthPercentage(100.0f);
        pdfTable.setWidths(widths);
        for (i = 0; i < table.getColumnCount(); ++i) {
            String col = table.getColumnName(i);
            PdfPCell cell = new PdfPCell(new Phrase(col, fontHeader));
            cell.setBorder(0);
            cell.setBorderWidthBottom(1.0f);
            cell.setBorderColorBottom(BaseColor.BLACK);
            pdfTable.addCell(cell);
        }
        for (i = 0; i < table.getRowCount(); ++i) {
            for (int j = 0; j < table.getColumnCount(); ++j) {
                Object value = table.getValueAt(i, j);
                String str = "";
                if (value != null && value.getClass().isAssignableFrom(Boolean.class)) {
                    str = (Boolean)value != false ? "Sim" : "N\u00e3o";
                } else if (value != null && (value.getClass().isAssignableFrom(java.util.Date.class) || value.getClass().isAssignableFrom(Date.class))) {
                    str = DateFormatter.format().format(value);
                } else if (value != null && value.getClass().isAssignableFrom(Time.class)) {
                    str = TimeFormatter.format().format(value);
                } else if (value != null && value.getClass().isAssignableFrom(Timestamp.class)) {
                    str = TimestampFormatter.format().format(value);
                } else if (value != null && (value.getClass().isAssignableFrom(Long.class) || value.getClass().isAssignableFrom(Long.TYPE))) {
                    str = NumberFormatter.format(0).format(value);
                } else if (value != null && (value.getClass().isAssignableFrom(Integer.class) || value.getClass().isAssignableFrom(Integer.TYPE))) {
                    str = NumberFormatter.format(0).format(value);
                } else if (value != null && (value.getClass().isAssignableFrom(Double.class) || value.getClass().isAssignableFrom(Double.TYPE))) {
                    str = NumberFormatter.format().format(value);
                } else if (value != null && value.getClass().isAssignableFrom(BigDecimal.class)) {
                    str = NumberFormatter.format().format(value);
                } else if (value != null && (value.getClass().isAssignableFrom(Float.class) || value.getClass().isAssignableFrom(Float.TYPE))) {
                    str = NumberFormatter.format().format(value);
                } else if (value != null) {
                    str = value.toString();
                }
                PdfPCell cell = new PdfPCell(new Phrase(str, fontData));
                cell.setBorder(0);
                cell.setBorderWidthBottom(0.3f);
                cell.setBorderColorBottom(BaseColor.BLACK);
                pdfTable.addCell(cell);
            }
        }
        doc.add((Element)pdfTable);
        this.close();
        return this.getFile();
    }
}

