/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf;

import br.com.ctecinf.Utils;
import br.com.ctecinf.swing.OptionPane;
import br.com.ctecinf.text.DateFormatter;
import java.awt.BorderLayout;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class Log {
    public static void create(Object message) {
        System.err.println(message);
        if (message instanceof Exception) {
            Date dt = new Date();
            String msg = "<br /><br /><br /><p>" + DateFormat.getTimeInstance().format(dt) + "> " + String.valueOf(message) + "</p>\n";
            for (StackTraceElement stack : ((Exception)message).getStackTrace()) {
                if (!stack.getClassName().contains("ctecinf") || stack.getClassName().contains("$")) continue;
                String url = new File("src").getAbsolutePath();
                msg = msg + "<p>(" + stack.getLineNumber() + ") <a href=\"" + url + File.separator + stack.getClassName().replace(".", File.separator).concat(".java") + "\">" + stack.getClassName() + "</a> -> " + stack.getMethodName() + "()</p>";
                System.err.println("(" + stack.getLineNumber() + ") " + stack.getClassName() + " -> " + stack.getMethodName() + "()");
            }
            try {
                Utils.writeFile("log" + File.separator + DateFormatter.format().format(dt).replace("/", "_") + ".html", msg, true, true);
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }
    }

    public static void show() throws IOException {
        Log.show(null);
    }

    public static void show(Date date) throws IOException {
        if (date == null) {
            date = new Date();
        }
        OptionPane.show(Log.get(date), 600, 400);
    }

    public static JPanel get(Date date) throws IOException {
        String path = "log" + File.separator + DateFormat.getDateInstance(2, new Locale("pt", "BR")).format(date).replace("/", "_").concat(".html");
        JEditorPane editor = new JEditorPane("text/html", Utils.readFile(path));
        editor.setEditable(false);
        editor.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        Desktop.getDesktop().open(new File(e.getDescription()));
                    }
                    catch (IOException | IllegalArgumentException ex) {
                        OptionPane.error(ex);
                    }
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(new JScrollPane(editor));
        return panel;
    }
}

