/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf;

import br.com.ctecinf.Config;
import br.com.ctecinf.Utils;
import br.com.ctecinf.autocomplete.AutoCompleteModel;
import br.com.ctecinf.swing.OptionPane;
import br.com.ctecinf.table.TableModel;
import br.com.ctecinf.text.DateFormatter;
import br.com.ctecinf.text.NumberFormatter;
import br.com.ctecinf.text.TimeFormatter;
import br.com.ctecinf.text.TimestampFormatter;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Database {
    public static final String[] JDBC = new String[]{"jdbc:firebirdsql:", "jdbc:mysql://", "jdbc:postgresql://", "jdbc:derby:", "jdbc:oracle:thin:"};
    protected static String DB_JDBC = Config.get("db.jdbc").isEmpty() ? "firebird" : Config.get("db.jdbc");
    protected static String DB_HOST = Config.get("db.host").isEmpty() ? "localhost" : Config.get("db.host");
    protected static String DB_NAME = Config.get("db.name").isEmpty() ? new File("data.fdb").getAbsolutePath() : Config.get("db.name");
    protected static String DB_USER = Config.get("db.user").isEmpty() ? "sysdba" : Config.get("db.user");
    protected static String DB_PASS = Config.get("db.pass").isEmpty() ? "masterkey" : Config.get("db.pass");

    private static String getURL(String dbname) throws SQLException {
        String jdbc = DB_JDBC;
        String host = DB_HOST;
        String name = dbname;
        Object url = null;
        for (String str : JDBC) {
            if (!str.contains(jdbc.toLowerCase())) continue;
            if (jdbc.equalsIgnoreCase("firebird") || jdbc.equalsIgnoreCase("derby")) {
                name = new File(name).getAbsolutePath();
            }
            url = str + host + str.substring(str.length() - 1) + name;
        }
        if (url == null || ((String)url).contains("null")) {
            throw new SQLException("Falta par\u00e2metro na URL[" + (String)url + "].");
        }
        return url;
    }

    private static String getURL() throws SQLException {
        return Database.getURL(DB_NAME);
    }

    public static Connection openConnection() throws SQLException {
        return DriverManager.getConnection(Database.getURL(), DB_USER, DB_PASS);
    }

    public static void exportData(String table) throws SQLException {
        Database.exportData(table, null);
    }

    public static void exportData(String table, String fromWhere) throws SQLException {
        ResultSet fromRS;
        Statement fromST;
        Connection toConn;
        String toURL = Database.getURL(Config.get("db.name.migrate"));
        ArrayList<String> cols = new ArrayList<String>();
        ArrayList<String> paramsInsert = new ArrayList<String>();
        ArrayList<CallSite> paramsUpdate = new ArrayList<CallSite>();
        String columnId = null;
        try (Connection conn = Database.openConnection();
             ResultSet rs = conn.getMetaData().getPrimaryKeys(null, null, table);){
            if (rs.next()) {
                columnId = rs.getString(4).toLowerCase().trim();
            }
        }
        if (columnId == null) {
            throw new SQLException("Tabela [" + table + "] n\u00e3o possui chave prim\u00e1ria.");
        }
        String create = "CREATE TABLE " + table + " (";
        String sequence = "seq_" + table + "_" + columnId;
        try (Connection conn = Database.openConnection();
             ResultSet rs = conn.getMetaData().getColumns(null, null, table, "%");){
            while (rs.next()) {
                String name = rs.getString(4).toLowerCase();
                Object type = rs.getString(6);
                if (rs.getInt(5) == 3 || rs.getInt(5) == 8 || rs.getInt(5) == 6 || rs.getInt(5) == 2) {
                    type = (String)type + "(" + rs.getInt(7) + "," + rs.getInt(9) + ")";
                }
                if (rs.getInt(5) == 1 || rs.getInt(5) == -16 || rs.getInt(5) == -15 || rs.getInt(5) == -9 || rs.getInt(5) == 12) {
                    type = (String)type + "(" + rs.getInt(7) + ")";
                }
                if (!name.equalsIgnoreCase(columnId)) {
                    cols.add(name);
                    paramsInsert.add("?");
                    paramsUpdate.add((CallSite)((Object)(name + " = ?")));
                }
                if (name.equalsIgnoreCase(columnId)) {
                    create = create + name + " " + (String)type + " NOT NULL PRIMARY KEY" + (rs.getString(23).equalsIgnoreCase("yes") ? " AUTO_INCREMENT" : "") + ",";
                    continue;
                }
                create = create + name + " " + (String)type + (rs.getString(18).equalsIgnoreCase("yes") ? "" : " NOT NULL") + ",";
            }
            create = create.substring(0, create.length() - 1) + ")";
        }
        boolean exist = false;
        try (Connection conn = DriverManager.getConnection(toURL, DB_USER, DB_PASS);
             ResultSet rs = conn.getMetaData().getTables(null, null, "%", new String[]{"TABLE"});){
            while (rs.next()) {
                if (!table.equalsIgnoreCase(rs.getString(3))) continue;
                exist = true;
                break;
            }
        }
        if (!exist) {
            conn = DriverManager.getConnection(toURL, DB_USER, DB_PASS);
            try (Statement st = conn.createStatement();
                 Connection conn2 = Database.openConnection();
                 Statement st2 = conn2.createStatement();
                 ResultSet rs = st2.executeQuery("SELECT MAX(" + columnId + ") FROM " + table);){
                st.execute(create);
                st.execute("CREATE SEQUENCE " + sequence);
                if (rs.next()) {
                    st.execute("SET SEQUENCE " + sequence + " TO " + String.valueOf(rs.getObject(1)));
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        Object max = null;
        try (Connection conn = DriverManager.getConnection(toURL, DB_USER, DB_PASS);
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery("SELECT MAX(" + columnId + ") FROM " + table);){
            if (rs.next()) {
                max = rs.getObject(1);
            }
        }
        Object where = "";
        if (max != null) {
            where = " WHERE " + columnId + " > " + String.valueOf(max) + " ";
        }
        String query = "SELECT " + columnId + ", " + Utils.implode(", ", cols) + " FROM " + table + (String)(fromWhere == null || fromWhere.isEmpty() ? where : (String)where + fromWhere);
        String sql = "INSERT INTO " + table + "(" + columnId + ", " + Utils.implode(", ", cols) + ") VALUES (?, " + Utils.implode(", ", paramsInsert) + ")";
        System.out.println(query);
        System.out.println(sql);
        try (Connection fromConn = Database.openConnection();){
            toConn = DriverManager.getConnection(toURL, DB_USER, DB_PASS);
            try {
                fromST = fromConn.createStatement();
                try {
                    fromRS = fromST.executeQuery(query);
                    try (PreparedStatement toInsert = toConn.prepareStatement(sql);){
                        while (fromRS.next()) {
                            toInsert.setObject(1, Database.toValue(fromRS, columnId));
                            for (int i = 0; i < cols.size(); ++i) {
                                toInsert.setObject(i + 2, Database.toValue(fromRS, (String)cols.get(i)));
                            }
                            toInsert.executeUpdate();
                        }
                    }
                    finally {
                        if (fromRS != null) {
                            fromRS.close();
                        }
                    }
                }
                finally {
                    if (fromST != null) {
                        fromST.close();
                    }
                }
            }
            finally {
                if (toConn != null) {
                    toConn.close();
                }
            }
        }
        if (max != null) {
            where = " WHERE " + columnId + " <= " + String.valueOf(max) + " ";
            query = "SELECT " + columnId + ", " + Utils.implode(", ", cols) + " FROM " + table + (String)(fromWhere == null || fromWhere.isEmpty() ? where : (String)where + fromWhere);
            sql = "UPDATE " + table + " SET " + Utils.implode(", ", paramsUpdate) + " WHERE " + columnId + " = ?";
            System.out.println(query);
            System.out.println(sql);
            fromConn = Database.openConnection();
            try {
                toConn = DriverManager.getConnection(toURL, DB_USER, DB_PASS);
                try {
                    fromST = fromConn.createStatement();
                    try {
                        fromRS = fromST.executeQuery(query);
                        try (PreparedStatement toUpdate = toConn.prepareStatement(sql);){
                            while (fromRS.next()) {
                                int index = 1;
                                for (String col : cols) {
                                    toUpdate.setObject(index, Database.toValue(fromRS, col));
                                    ++index;
                                }
                                toUpdate.setObject(index, Database.toValue(fromRS, columnId));
                                toUpdate.executeUpdate();
                            }
                        }
                        finally {
                            if (fromRS != null) {
                                fromRS.close();
                            }
                        }
                    }
                    finally {
                        if (fromST != null) {
                            fromST.close();
                        }
                    }
                }
                finally {
                    if (toConn != null) {
                        toConn.close();
                    }
                }
            }
            finally {
                if (fromConn != null) {
                    fromConn.close();
                }
            }
        }
    }

    public static Long executeUpdate(String sql) throws Exception {
        try (Connection conn = Database.openConnection();
             Statement st = conn.createStatement();){
            st.execute(sql, 1);
            try (ResultSet rs = st.getGeneratedKeys();){
                if (rs.next()) {
                    Long l = rs.getLong(1);
                    return l;
                }
            }
        }
        return null;
    }

    public static List<Map<String, Object>> executeQuery(String query) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try (Connection conn = Database.openConnection();
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                TreeMap map = new TreeMap();
                for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                    map.put(rs.getMetaData().getColumnName(i + 1).toLowerCase(), Database.toValue(rs, rs.getMetaData().getColumnLabel(i + 1)));
                }
                list.add(map);
            }
        }
        return list;
    }

    public static TableModel getTableModel(String query) {
        return Database.getTableModel(query, false);
    }

    public static TableModel getTableModel(final String query, boolean fast) {
        final TableModel model = new TableModel();
        if (fast) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Database.buildTableModel(model, query);
                }
            }).start();
        } else {
            Database.buildTableModel(model, query);
        }
        return model;
    }

    public static AutoCompleteModel<Map<String, Object>> getAutoCompleteModel(String query, String columnToString) {
        return Database.getAutoCompleteModel(query, columnToString, false);
    }

    public static AutoCompleteModel<Map<String, Object>> getAutoCompleteModel(final String query, final String columnToString, boolean fast) {
        final AutoCompleteModel<Map<String, Object>> model = new AutoCompleteModel<Map<String, Object>>();
        if (fast) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Database.buildAutoCompleteModel(model, columnToString, query);
                }
            }).start();
        } else {
            Database.buildAutoCompleteModel(model, columnToString, query);
        }
        return model;
    }

    public static String insertScript(String table, Map<String, Object> params) throws SQLException {
        String columnId = null;
        try (Connection conn = Database.openConnection();
             ResultSet rs = conn.getMetaData().getPrimaryKeys(null, null, table);){
            if (rs.next()) {
                columnId = rs.getString(4).toLowerCase();
            }
        }
        return Database.insertScript(table, columnId, params);
    }

    public static String insertScript(String table, String columnId, Map<String, Object> params) throws SQLException {
        String sequence = null;
        if (Database.getURL().contains("firebird")) {
            String query = "SELECT RDB$GENERATOR_NAME FROM RDB$GENERATORS";
            try (Connection conn = Database.openConnection();
                 Statement st = conn.createStatement();
                 ResultSet rs = st.executeQuery(query);){
                while (rs.next()) {
                    if (!rs.getString(1).toLowerCase().contains(table.toLowerCase())) continue;
                    sequence = rs.getString(1).toLowerCase().trim();
                    break;
                }
            }
            catch (SQLException ex) {
                System.err.println(ex);
            }
        }
        return Database.insertScript(table, columnId, params, sequence);
    }

    public static String insertScript(String table, String columnId, Map<String, Object> params, String sequenceName) throws SQLException {
        if (columnId == null) {
            throw new SQLException("Tabela n\u00e3o possui chave prim\u00e1ria.");
        }
        ArrayList<String> cols = new ArrayList<String>();
        ArrayList<Object> vals = new ArrayList<Object>();
        Object id = null;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(columnId)) {
                cols.add(entry.getKey());
                Object value = entry.getValue();
                if (value != null) {
                    switch (value.toString()) {
                        case "true": {
                            value = 1;
                            break;
                        }
                        case "false": {
                            value = 0;
                        }
                    }
                }
                vals.add(value == null || value.toString().isEmpty() || value.toString().equalsIgnoreCase("null") ? "null" : "'" + String.valueOf(value) + "'");
                continue;
            }
            id = entry.getValue();
        }
        Object col = "";
        for (int i = 0; i < cols.size(); ++i) {
            col = (String)col + (String)cols.get(i) + (i + 1 == cols.size() ? "" : ", ");
        }
        Object val = "";
        for (int i = 0; i < vals.size(); ++i) {
            val = (String)val + String.valueOf(vals.get(i)) + (i + 1 == cols.size() ? "" : ", ");
        }
        if (sequenceName != null && Database.getURL().contains("firebird")) {
            col = (String)col + ", " + columnId;
            val = (String)val + (id == null ? ", GEN_ID(" + sequenceName.toLowerCase().trim() + ", 1)" : ", " + String.valueOf(id));
        } else if (sequenceName == null && id != null) {
            col = (String)col + ", " + columnId;
            val = (String)val + ", " + String.valueOf(id);
        }
        String sql = "INSERT INTO " + table + "(" + (String)col + ") VALUES (" + (String)val + ")";
        return sql;
    }

    public static String updateScript(String table, Map<String, Object> params) throws SQLException {
        String columnId = null;
        try (Connection conn = Database.openConnection();
             ResultSet rs = conn.getMetaData().getPrimaryKeys(null, null, table);){
            if (rs.next()) {
                columnId = rs.getString(4).toLowerCase();
            }
        }
        return Database.updateScript(table, columnId, params);
    }

    public static String updateScript(String table, String columnId, Map<String, Object> params) throws SQLException {
        if (columnId == null) {
            throw new SQLException("Tabela n\u00e3o possui chave prim\u00e1ria.");
        }
        Object idValue = null;
        ArrayList<CallSite> cols = new ArrayList<CallSite>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object value = entry.getValue();
            if (entry.getKey().equalsIgnoreCase(columnId)) {
                idValue = value;
                continue;
            }
            if (value != null) {
                switch (value.toString()) {
                    case "true": {
                        value = 1;
                        break;
                    }
                    case "false": {
                        value = 0;
                    }
                }
            }
            cols.add((CallSite)((Object)(entry.getKey() + " = " + (String)(value == null || value.toString().isEmpty() || value.toString().equalsIgnoreCase("null") ? "null" : "'" + String.valueOf(value) + "'"))));
        }
        if (idValue == null) {
            throw new SQLException("Falta o par\u00e2metro identificador do regsitro.");
        }
        Object col = "";
        for (int i = 0; i < cols.size(); ++i) {
            col = (String)col + (String)cols.get(i) + (i + 1 == cols.size() ? "" : ", ");
        }
        String sql = "UPDATE " + table + " SET " + (String)col + " WHERE " + columnId + " = '" + String.valueOf(idValue) + "'";
        return sql;
    }

    public static <T> T toValue(ResultSet rs, String column) throws SQLException {
        Object value = null;
        if (column != null && rs.getObject(column) != null) {
            int type = rs.getMetaData().getColumnType(rs.findColumn(column));
            switch (type) {
                case -5: {
                    value = rs.getLong(column);
                    break;
                }
                case -2: {
                    value = rs.getObject(column);
                    break;
                }
                case -7: {
                    value = rs.getBoolean(column);
                    break;
                }
                case 2004: {
                    value = rs.getBlob(column);
                    break;
                }
                case 16: {
                    value = rs.getBoolean(column);
                    break;
                }
                case 1: {
                    value = rs.getString(column);
                    break;
                }
                case 91: {
                    value = rs.getDate(column);
                    break;
                }
                case 3: {
                    value = rs.getBigDecimal(column);
                    break;
                }
                case 8: {
                    value = rs.getDouble(column);
                    break;
                }
                case 6: {
                    value = Float.valueOf(rs.getFloat(column));
                    break;
                }
                case 4: {
                    value = rs.getInt(column);
                    break;
                }
                case -16: {
                    value = rs.getString(column);
                    break;
                }
                case -1: {
                    value = rs.getString(column);
                    break;
                }
                case -15: {
                    value = rs.getString(column);
                    break;
                }
                case -9: {
                    value = rs.getString(column);
                    break;
                }
                case 5: {
                    value = rs.getBoolean(column);
                    break;
                }
                case 92: {
                    value = rs.getTime(column);
                    break;
                }
                case 93: {
                    value = rs.getTimestamp(column);
                    break;
                }
                case -6: {
                    value = rs.getBoolean(column);
                    break;
                }
                case 12: {
                    value = rs.getString(column);
                    break;
                }
                default: {
                    value = rs.getObject(column);
                }
            }
        }
        return (T)(value == null ? null : value);
    }

    public static Class type2Class(int type) {
        switch (type) {
            case -5: {
                return Long.class;
            }
            case -2: {
                return Object.class;
            }
            case -7: {
                return Boolean.class;
            }
            case 2004: {
                return Blob.class;
            }
            case 16: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 91: {
                return Date.class;
            }
            case 3: {
                return BigDecimal.class;
            }
            case 8: {
                return Double.class;
            }
            case 6: {
                return Float.class;
            }
            case 4: {
                return Integer.class;
            }
            case -16: {
                return String.class;
            }
            case -1: {
                return String.class;
            }
            case -15: {
                return String.class;
            }
            case -9: {
                return String.class;
            }
            case 5: {
                return Boolean.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case -6: {
                return Boolean.class;
            }
            case 12: {
                return String.class;
            }
        }
        return Object.class;
    }

    public static String type2String(String literal, int type, int length) throws SQLException {
        if (literal.equalsIgnoreCase("text") || literal.equalsIgnoreCase("boolean") || literal.equalsIgnoreCase("tinyint")) {
            return literal.toUpperCase();
        }
        switch (type) {
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB" + (Database.getURL().toLowerCase().contains("firebird") ? " SUB_TYPE 1" : "");
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR(" + length + ")";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL(" + length + ", 2)";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INT";
            }
            case -16: {
                return "VARCHAR(" + length + ")";
            }
            case -1: {
                return "TEXT";
            }
            case -15: {
                return "VARCHAR(" + length + ")";
            }
            case -9: {
                return "VARCHAR(" + length + ")";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case 12: {
                return "VARCHAR(" + length + ")";
            }
        }
        return literal;
    }

    public static int class2Type(Class cls) {
        if (cls.isAssignableFrom(Long.class) || cls.isAssignableFrom(Long.TYPE)) {
            return -5;
        }
        if (cls.isAssignableFrom(Blob.class)) {
            return 2004;
        }
        if (cls.isAssignableFrom(Boolean.class) || cls.isAssignableFrom(Boolean.TYPE)) {
            return 16;
        }
        if (cls.isAssignableFrom(java.util.Date.class) || cls.isAssignableFrom(Date.class)) {
            return 91;
        }
        if (cls.isAssignableFrom(BigDecimal.class)) {
            return 3;
        }
        if (cls.isAssignableFrom(Double.class) || cls.isAssignableFrom(Double.TYPE)) {
            return 8;
        }
        if (cls.isAssignableFrom(Float.class) || cls.isAssignableFrom(Float.TYPE)) {
            return 6;
        }
        if (cls.isAssignableFrom(Integer.class) || cls.isAssignableFrom(Integer.TYPE)) {
            return 4;
        }
        if (cls.isAssignableFrom(Time.class)) {
            return 92;
        }
        if (cls.isAssignableFrom(Timestamp.class)) {
            return 93;
        }
        return 12;
    }

    public static String java2Database(String name) {
        Object str = "";
        for (char c : name.toCharArray()) {
            str = Character.isUpperCase(c) && !((String)str).isEmpty() ? (String)str + "_" + String.valueOf(c).toLowerCase() : (String)str + String.valueOf(c).toLowerCase();
        }
        return str;
    }

    public static String database2Java(String name) {
        return Database.database2Java(name, false);
    }

    public static String database2Java(String name, boolean upper) {
        Object str = "";
        for (char c : name.toCharArray()) {
            if (c == '_') {
                upper = true;
                continue;
            }
            if (upper) {
                str = (String)str + String.valueOf(c).toUpperCase();
                upper = false;
                continue;
            }
            str = (String)str + String.valueOf(c);
        }
        return str;
    }

    public static boolean restore(String path) throws Exception {
        return Database.restore(new File(path));
    }

    public static boolean restore(File file) throws Exception {
        String sql = Utils.readFile(file);
        try (Connection conn = Database.openConnection();
             Statement st = conn.createStatement();){
            ArrayList<String> alters = new ArrayList<String>();
            for (String line : sql.replace("\n", "").split(";")) {
                if (line.startsWith("INSERT")) {
                    st.addBatch(line.replace("\r", "\n"));
                    continue;
                }
                if (line.startsWith("ALTER")) {
                    alters.add(line);
                    continue;
                }
                st.execute(line.replace("\r", "\n"));
            }
            st.executeBatch();
            for (String alter : alters) {
                st.execute(alter);
            }
        }
        return true;
    }

    public static File backupANSI(String path) throws Exception {
        return Database.backupANSI(new File(path.replace(".sql", "") + ".sql"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static File backupANSI(File file) throws Exception {
        if (!file.getAbsolutePath().endsWith("sql")) {
            file = new File(file.getAbsolutePath().replace(".sql", "") + ".sql");
        }
        sql = new StringBuilder();
        if (Database.getURL().contains("firebird")) {
            sql.append("CREATE DOMAIN TINYINT AS SMALLINT;\n");
            sql.append("CREATE DOMAIN \"BOOLEAN\" AS SMALLINT CHECK(VALUE BETWEEN 0 AND 1);\n");
            sql.append("CREATE DOMAIN TEXT AS BLOB SUB_TYPE 1;\n\n");
        }
        try {
            conn = Database.openConnection();
            try {
                st = conn.createStatement();
                try {
                    rsTab = conn.getMetaData().getTables(null, null, "%", new String[]{"TABLE"});
lbl17:
                    // 2 sources

                    try {
                        while (rsTab.next()) {
                            table = rsTab.getString(3).toLowerCase().trim();
                            sql.append("CREATE TABLE ");
                            sql.append(table);
                            sql.append(" (\n");
                            primaryKey = "";
                            rs = conn.getMetaData().getPrimaryKeys(null, null, table);
                            try {
                                if (rs.next()) {
                                    primaryKey = rs.getString(4).toLowerCase().trim();
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            columns = new ArrayList<CallSite>();
                            rs = conn.getMetaData().getColumns(null, null, table, "%");
                            try {
                                while (rs.next()) {
                                    column = rs.getString(4).toLowerCase().trim();
                                    type = Database.type2String(rs.getString(6).trim(), rs.getInt(5), rs.getInt(7)) + (rs.getString(18).equalsIgnoreCase("yes") == false ? " NOT NULL" : "") + (column.equalsIgnoreCase(primaryKey) != false ? " PRIMARY KEY" : "") + (rs.getString(19) != null && rs.getString(19).equalsIgnoreCase("yes") != false ? " AUTO_INCREMENT" : "");
                                    columns.add((CallSite)("  " + column + " " + type));
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            sql.append(Utils.implode(",\n", columns));
                            sql.append("\n);\n\n");
                            maxId = 0;
                            rs = st.executeQuery("SELECT * FROM " + table);
                            try {
                                prefix = "INSERT INTO " + table + "(";
                                for (i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                                    prefix = prefix + rs.getMetaData().getColumnLabel(i + 1).toLowerCase().trim() + (i + 1 == rs.getMetaData().getColumnCount() ? "" : ", ");
                                }
                                prefix = prefix + ") VALUES (";
                                while (rs.next()) {
                                    maxId = Math.max(maxId, rs.getInt(primaryKey));
                                    sql.append(prefix);
                                    for (i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                                        value = rs.getObject(rs.getMetaData().getColumnLabel(i + 1));
                                        value = value != null ? "'" + value.toString().replace(";", "").replace("\n", "\r").replace("'", "`") + "'" : "NULL";
                                        sql.append(value);
                                        sql.append(i + 1 == rs.getMetaData().getColumnCount() ? "" : ", ");
                                    }
                                    sql.append(");\n");
                                }
                                sql.append("\n\n");
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            if (Database.getURL().contains("firebird")) {
                                rs = st.executeQuery("SELECT RDB$GENERATOR_NAME FROM RDB$GENERATORS");
                                try {
                                    while (rs.next()) {
                                        if (!rs.getString(1).toLowerCase().contains(table.toLowerCase())) continue;
                                        sql.append("CREATE SEQUENCE ");
                                        sql.append(rs.getString(1).toLowerCase().trim());
                                        sql.append(";\n");
                                        sql.append("ALTER SEQUENCE ");
                                        sql.append(rs.getString(1).toLowerCase().trim());
                                        sql.append(" RESTART WITH ");
                                        sql.append(maxId);
                                        sql.append(";\n\n");
                                        break;
                                    }
                                }
                                finally {
                                    if (rs != null) {
                                        rs.close();
                                    }
                                }
                            }
                            rs = conn.getMetaData().getImportedKeys(null, null, table);
                            try {
                                while (rs.next()) {
                                    sql.append("ALTER TABLE ");
                                    sql.append(table);
                                    sql.append(" ADD FOREIGN KEY (");
                                    sql.append(rs.getString(8).toLowerCase().trim());
                                    sql.append(") REFERENCES ");
                                    sql.append(rs.getString(3).toLowerCase().trim());
                                    sql.append("(");
                                    sql.append(rs.getString(4).toLowerCase().trim());
                                    sql.append(");\n");
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            sql.append("\n");
                            rs = conn.getMetaData().getIndexInfo(null, null, table, true, true);
                            try {
                                uniques = new ArrayList<String>();
                                while (rs.next()) {
                                    column = rs.getString(9).toLowerCase().trim();
                                    if (column.equals(primaryKey)) continue;
                                    uniques.add(column);
                                }
                                if (uniques.isEmpty()) continue;
                                sql.append("ALTER TABLE ");
                                sql.append(table);
                                sql.append(" ADD UNIQUE (");
                                sql.append(Utils.implode(", ", uniques));
                                sql.append(");\n\n");
                            }
                            finally {
                                if (rs == null) ** GOTO lbl17
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (rsTab != null) {
                            rsTab.close();
                        }
                    }
                }
                finally {
                    if (st != null) {
                        st.close();
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        finally {
            Utils.writeFile(file, sql.toString(), false);
        }
        return file;
    }

    private static Map<String, Object> newMap(ResultSet rs, String[] cols) throws SQLException {
        final StringBuilder toString = new StringBuilder();
        for (String col : cols) {
            Object obj = Database.toValue(rs, col.trim().toLowerCase());
            if (obj == null) continue;
            Class<Serializable> cls = obj.getClass();
            if (cls.isAssignableFrom(Long.class) || cls.isAssignableFrom(Long.TYPE) || cls.isAssignableFrom(Integer.class) || cls.isAssignableFrom(Integer.TYPE)) {
                obj = NumberFormatter.format(0).format(obj);
            } else if (cls.isAssignableFrom(BigDecimal.class) || cls.isAssignableFrom(Double.class) || cls.isAssignableFrom(Double.TYPE) || cls.isAssignableFrom(Float.class) || cls.isAssignableFrom(Float.TYPE)) {
                obj = NumberFormatter.format(2).format(obj);
            } else if (cls.isAssignableFrom(Boolean.class) || cls.isAssignableFrom(Boolean.TYPE)) {
                obj = (Boolean)obj != false ? "Sim" : "N\u00e3o";
            } else if (cls.isAssignableFrom(java.util.Date.class) || cls.isAssignableFrom(Date.class)) {
                obj = DateFormatter.format().format(obj);
            } else if (cls.isAssignableFrom(Time.class)) {
                obj = TimeFormatter.format().format(obj);
            } else if (cls.isAssignableFrom(Timestamp.class)) {
                obj = TimestampFormatter.format().format(obj);
            }
            if (toString.length() == 0) {
                toString.append(obj.toString());
                continue;
            }
            toString.append(" - ").append(obj.toString());
        }
        return new TreeMap(){

            @Override
            public String toString() {
                return toString.toString();
            }
        };
    }

    private static void buildAutoCompleteModel(AutoCompleteModel<Map<String, Object>> model, String columnToString, String query) {
        try (Connection conn = Database.openConnection();
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery(query);){
            String[] cols = columnToString.split(",");
            while (rs.next()) {
                Map<String, Object> map = Database.newMap(rs, cols);
                for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                    map.put(rs.getMetaData().getColumnName(i + 1).toLowerCase(), Database.toValue(rs, rs.getMetaData().getColumnLabel(i + 1)));
                }
                model.add(map);
            }
            model.endLoad();
        }
        catch (Exception ex) {
            OptionPane.error(ex);
        }
    }

    private static void buildTableModel(TableModel model, String query) {
        try (Connection conn = Database.openConnection();
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery(query);){
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                model.addColumn(rs.getMetaData().getColumnLabel(i + 1), Database.type2Class(rs.getMetaData().getColumnType(i + 1)));
            }
            while (rs.next()) {
                Object[] row = new Object[rs.getMetaData().getColumnCount()];
                for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                    row[i] = Database.toValue(rs, rs.getMetaData().getColumnLabel(i + 1));
                }
                model.addRow(row);
            }
        }
        catch (Exception ex) {
            OptionPane.error(ex);
        }
    }
}

