/*
 * Decompiled with CFR 0.152.
 */
package br.com.ctecinf;

import br.com.ctecinf.Empresa;
import br.com.ctecinf.Utils;
import br.com.ctecinf.model.Crediario;
import br.com.ctecinf.model.Parcela;
import br.com.ctecinf.model.Receita;
import br.com.ctecinf.swing.OptionPane;
import br.com.ctecinf.text.DateFormatter;
import br.com.ctecinf.text.MaskFormatter;
import br.com.ctecinf.text.NumberFormatter;
import br.com.ctecinf.text.TimestampFormatter;
import br.com.ctecinf.text.UpperCaseFormatter;
import br.inf.portalfiscal.nfe.v310.autorizacao.TNFe;
import br.inf.portalfiscal.nfe.v310.autorizacao.TNfeProc;
import br.inf.portalfiscal.nfe.v400.autorizacao.TNFe;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;

public class Daruma {
    public static String PORT;
    public static int COLUMNS;
    public static final int FONT_SIZE_DEFAULT = 1;
    public static final int FONT_SIZE_MEDIUM = 2;
    public static final int FONT_SIZE_LARGER = 3;
    public static final int FONT_SIZE_EXTRA = 4;
    private static final char[] TAB;
    private static final char[] ALIGN_LEFT;
    private static final char[] ALIGN_CENTER;
    private static final char[] ALIGN_RIGHT;
    private static final char[] CHAR_SIZE_0;
    private static final char[] CHAR_SIZE_1;
    private static final char[] CHAR_SIZE_2;
    private static final char[] CHAR_SIZE_3;
    private static final char[] START_ITALIC;
    private static final char[] END_ITALIC;
    private static final char[] START_BOLD;
    private static final char[] END_BOLD;
    private static final char[] START_TEXT_COND;
    private static final char[] END_TEXT_COND;
    private static final char[] TEXT_EXPAND;
    private static final char[] TEXT_NORMAL;
    private static final char[] GUILHOTINA;
    private final FileOutputStream outputStream = new FileOutputStream(PORT);

    private static byte[] byteArray(int ... value) {
        byte[] arr = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            arr[i] = (byte)value[i];
        }
        return arr;
    }

    public void qrCode(String str) throws IOException {
        int tamF;
        int tamI;
        int tamanho = str.length() + 3;
        if (tamanho > 255) {
            tamI = tamanho % 255;
            tamF = tamanho / 255;
        } else {
            tamI = tamanho;
            tamF = 0;
        }
        this.outputStream.write(Daruma.byteArray(27, 129));
        this.outputStream.write(Daruma.byteArray(tamI - 1, tamF, 4, 4));
        this.outputStream.write(str.getBytes());
        this.outputStream.write(Daruma.byteArray(0));
    }

    public void ean13Bar(String code, int size, boolean showText) throws IOException {
        this.outputStream.write(Daruma.byteArray(27, 98));
        this.outputStream.write(Daruma.byteArray(1));
        this.outputStream.write(Daruma.byteArray(2));
        this.outputStream.write(Daruma.byteArray(size));
        this.outputStream.write(showText ? Daruma.byteArray(1) : Daruma.byteArray(0));
        this.outputStream.write(code.getBytes());
        this.outputStream.write(Daruma.byteArray(0));
    }

    public void ean8Bar(String code, int size, boolean showText) throws IOException {
        this.outputStream.write(Daruma.byteArray(27, 98));
        this.outputStream.write(Daruma.byteArray(2));
        this.outputStream.write(Daruma.byteArray(2));
        this.outputStream.write(Daruma.byteArray(size));
        this.outputStream.write(showText ? Daruma.byteArray(1) : Daruma.byteArray(0));
        this.outputStream.write(code.getBytes());
        this.outputStream.write(Daruma.byteArray(0));
    }

    public void s2of5Bar(String code, int size, boolean showText) throws IOException {
        this.outputStream.write(Daruma.byteArray(27, 98));
        this.outputStream.write(Daruma.byteArray(3));
        this.outputStream.write(Daruma.byteArray(2));
        this.outputStream.write(Daruma.byteArray(size));
        this.outputStream.write(showText ? Daruma.byteArray(1) : Daruma.byteArray(0));
        this.outputStream.write(code.getBytes());
        this.outputStream.write(Daruma.byteArray(0));
    }

    public void i2of5Bar(String code, int size, boolean showText) throws IOException {
        this.outputStream.write(Daruma.byteArray(27, 98));
        this.outputStream.write(Daruma.byteArray(4));
        this.outputStream.write(Daruma.byteArray(2));
        this.outputStream.write(Daruma.byteArray(size));
        this.outputStream.write(showText ? Daruma.byteArray(1) : Daruma.byteArray(0));
        this.outputStream.write(code.getBytes());
        this.outputStream.write(Daruma.byteArray(0));
    }

    public void code128Bar(String code, int size, boolean showText) throws IOException {
        this.outputStream.write(Daruma.byteArray(27, 98));
        this.outputStream.write(Daruma.byteArray(5));
        this.outputStream.write(Daruma.byteArray(2));
        this.outputStream.write(Daruma.byteArray(size));
        this.outputStream.write(showText ? Daruma.byteArray(1) : Daruma.byteArray(0));
        this.outputStream.write(code.getBytes());
        this.outputStream.write(Daruma.byteArray(0));
    }

    public void code39Bar(String code, int size, boolean showText) throws IOException {
        this.outputStream.write(Daruma.byteArray(27, 98));
        this.outputStream.write(Daruma.byteArray(6));
        this.outputStream.write(Daruma.byteArray(2));
        this.outputStream.write(Daruma.byteArray(size));
        this.outputStream.write(showText ? Daruma.byteArray(1) : Daruma.byteArray(0));
        this.outputStream.write(code.getBytes());
        this.outputStream.write(Daruma.byteArray(0));
    }

    public void code93Bar(String code, int size, boolean showText) throws IOException {
        this.outputStream.write(Daruma.byteArray(27, 98));
        this.outputStream.write(Daruma.byteArray(7));
        this.outputStream.write(Daruma.byteArray(2));
        this.outputStream.write(Daruma.byteArray(size));
        this.outputStream.write(showText ? Daruma.byteArray(1) : Daruma.byteArray(0));
        this.outputStream.write(code.getBytes());
        this.outputStream.write(Daruma.byteArray(0));
    }

    public void upcABar(String code, int size, boolean showText) throws IOException {
        this.outputStream.write(Daruma.byteArray(27, 98));
        this.outputStream.write(Daruma.byteArray(8));
        this.outputStream.write(Daruma.byteArray(2));
        this.outputStream.write(Daruma.byteArray(size));
        this.outputStream.write(showText ? Daruma.byteArray(1) : Daruma.byteArray(0));
        this.outputStream.write(code.getBytes());
        this.outputStream.write(Daruma.byteArray(0));
    }

    public void codaBar(String code, int size, boolean showText) throws IOException {
        this.outputStream.write(Daruma.byteArray(27, 98));
        this.outputStream.write(Daruma.byteArray(9));
        this.outputStream.write(Daruma.byteArray(2));
        this.outputStream.write(Daruma.byteArray(size));
        this.outputStream.write(showText ? Daruma.byteArray(1) : Daruma.byteArray(0));
        this.outputStream.write(code.getBytes());
        this.outputStream.write(Daruma.byteArray(0));
    }

    public void msiBar(String code, int size, boolean showText) throws IOException {
        this.outputStream.write(Daruma.byteArray(27, 98));
        this.outputStream.write(Daruma.byteArray(10));
        this.outputStream.write(Daruma.byteArray(2));
        this.outputStream.write(Daruma.byteArray(size));
        this.outputStream.write(showText ? Daruma.byteArray(1) : Daruma.byteArray(0));
        this.outputStream.write(code.getBytes());
        this.outputStream.write(Daruma.byteArray(0));
    }

    public void code11Bar(String code, int size, boolean showText) throws IOException {
        this.outputStream.write(Daruma.byteArray(27, 98));
        this.outputStream.write(Daruma.byteArray(11));
        this.outputStream.write(Daruma.byteArray(2));
        this.outputStream.write(Daruma.byteArray(size));
        this.outputStream.write(showText ? Daruma.byteArray(1) : Daruma.byteArray(0));
        this.outputStream.write(code.getBytes());
        this.outputStream.write(Daruma.byteArray(0));
    }

    public void tamanhoFonte(int size) throws IOException {
        switch (size) {
            case 2: {
                this.outputStream.write(new String(CHAR_SIZE_1).getBytes());
                break;
            }
            case 3: {
                this.outputStream.write(new String(CHAR_SIZE_2).getBytes());
                break;
            }
            case 4: {
                this.outputStream.write(new String(CHAR_SIZE_3).getBytes());
                break;
            }
            default: {
                this.outputStream.write(new String(CHAR_SIZE_0).getBytes());
            }
        }
    }

    public void saltarLinhas(int numRows) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            this.outputStream.write("\n".getBytes());
        }
    }

    public void alinharEsquerda() throws IOException {
        this.outputStream.write(new String(ALIGN_LEFT).getBytes());
    }

    public void alinharCentro() throws IOException {
        this.outputStream.write(new String(ALIGN_CENTER).getBytes());
    }

    public void alinharDireita() throws IOException {
        this.outputStream.write(new String(ALIGN_RIGHT).getBytes());
    }

    public void tab() throws IOException {
        this.outputStream.write(new String(TAB).getBytes());
    }

    public void novaLinha() throws IOException {
        this.saltarLinhas(1);
    }

    public void linhaCorte() throws IOException {
        this.novaLinha();
        this.alinharCentro();
        this.iniciarCond();
        for (int i = 0; i < COLUMNS; ++i) {
            this.texto("-");
        }
        this.encerrarCond();
        this.novaLinha();
    }

    public void iniciarCond() throws IOException {
        this.outputStream.write(new String(START_TEXT_COND).getBytes());
    }

    public void encerrarCond() throws IOException {
        this.outputStream.write(new String(END_TEXT_COND).getBytes());
    }

    public void texto(String str) throws IOException {
        this.outputStream.write(str.getBytes());
    }

    public void textoNormal(String str) throws IOException {
        this.outputStream.write(new String(TEXT_NORMAL).getBytes());
        this.outputStream.write(str.getBytes());
    }

    public void textoExpand(String str) throws IOException {
        this.outputStream.write(new String(TEXT_EXPAND).getBytes());
        this.outputStream.write(str.getBytes());
        this.outputStream.write(new String(TEXT_NORMAL).getBytes());
    }

    public void negrito(String str) throws IOException {
        this.outputStream.write(new String(START_BOLD).getBytes());
        this.outputStream.write(str.getBytes());
        this.outputStream.write(new String(END_BOLD).getBytes());
    }

    public void italico(String str) throws IOException {
        this.outputStream.write(new String(START_ITALIC).getBytes());
        this.outputStream.write(str.getBytes());
        this.outputStream.write(new String(END_ITALIC).getBytes());
    }

    public void beep() throws IOException {
        this.outputStream.write(Daruma.byteArray(7));
    }

    public void end() throws IOException {
        this.outputStream.write(Daruma.byteArray(0));
        this.outputStream.write(new String(CHAR_SIZE_1).getBytes());
        this.outputStream.write(Daruma.byteArray(7));
        this.outputStream.write(new String(GUILHOTINA).getBytes());
        this.outputStream.flush();
        this.outputStream.close();
    }

    public void leftLine(String str) throws IOException {
        this.leftLine(str, 1);
    }

    public void leftLine(String str, int font) throws IOException {
        this.iniciarCond();
        this.tamanhoFonte(font);
        this.alinharEsquerda();
        boolean bold = false;
        if (str == null) {
            this.texto("");
        } else {
            str = str.replace("null ", " ").replace(" null", "");
            for (String s : str.split(" ")) {
                if (s.startsWith("<b>")) {
                    bold = true;
                }
                if (bold) {
                    if (s.endsWith("</b>")) {
                        bold = false;
                    }
                    this.negrito(s.replace("<b>", "").replace("</b>", "") + " ");
                    continue;
                }
                if (s.endsWith("</b>")) {
                    bold = false;
                }
                this.texto(s.replace("<b>", "").replace("</b>", "") + " ");
            }
        }
        this.encerrarCond();
        this.novaLinha();
    }

    public void centerLine(String str) throws IOException {
        this.centerLine(str, 1);
    }

    public void centerLine(String str, int font) throws IOException {
        this.iniciarCond();
        this.tamanhoFonte(font);
        this.alinharCentro();
        boolean bold = false;
        if (str == null) {
            this.texto("");
        } else {
            str = str.replace("null ", " ");
            for (String s : str.split(" ")) {
                if (s.startsWith("<b>")) {
                    bold = true;
                }
                if (bold) {
                    if (s.endsWith("</b>")) {
                        bold = false;
                    }
                    this.negrito(s.replace("<b>", "").replace("</b>", "") + " ");
                    continue;
                }
                if (s.endsWith("</b>")) {
                    bold = false;
                }
                this.texto(s.replace("<b>", "").replace("</b>", "") + " ");
            }
        }
        this.encerrarCond();
        this.novaLinha();
    }

    public void rightLine(String str) throws IOException {
        this.rightLine(str, 1);
    }

    public void rightLine(String str, int font) throws IOException {
        this.iniciarCond();
        this.tamanhoFonte(font);
        this.alinharDireita();
        boolean bold = false;
        if (str == null) {
            this.texto("");
        } else {
            str = str.replace("null ", " ");
            for (String s : str.split(" ")) {
                if (s.startsWith("<b>")) {
                    bold = true;
                }
                if (bold) {
                    if (s.endsWith("</b>")) {
                        bold = false;
                    }
                    this.negrito(s.replace("<b>", "").replace("</b>", "") + " ");
                    continue;
                }
                if (s.endsWith("</b>")) {
                    bold = false;
                }
                this.texto(s.replace("<b>", "").replace("</b>", "") + " ");
            }
        }
        this.encerrarCond();
        this.novaLinha();
    }

    public static String bold(String str) {
        return "<b>" + str + "</b>";
    }

    public static void recibo() throws IOException {
        int num = (int)(Math.random() * 9.9999999E7);
        String cliente = OptionPane.input("Nome do cliente", null, new UpperCaseFormatter());
        if (cliente == null) {
            return;
        }
        String referente = OptionPane.input("Referente", null, new UpperCaseFormatter());
        if (referente == null) {
            return;
        }
        Number valor = OptionPane.input("Valor", null, new NumberFormatter(2));
        if (valor == null) {
            return;
        }
        Daruma.printRecibo(num, cliente, valor.doubleValue(), referente, true);
        if (OptionPane.confirm("Deseja imprimir via do estabelecimento?")) {
            Daruma.printRecibo(num, cliente, valor.doubleValue(), referente, false);
        }
    }

    public static void printRecibo(int numero, String nomeCliente, double valorRecibo, String referente, boolean viaConsumidor) throws IOException {
        Daruma p = new Daruma();
        p.head();
        p.alinharCentro();
        p.tamanhoFonte(4);
        p.negrito("RECIBO");
        p.novaLinha();
        p.novaLinha();
        p.tamanhoFonte(1);
        p.alinharEsquerda();
        p.tab();
        p.texto("Recebemos de ");
        p.negrito(nomeCliente);
        p.texto(", a quantia de ");
        p.negrito(NumberFormatter.format(2).format(valorRecibo));
        p.texto(", correspondente a: ");
        p.negrito(referente);
        p.texto(" do que passamos o presente recibo.");
        p.novaLinha();
        p.novaLinha();
        p.alinharCentro();
        p.negrito("SEM VALOR FISCAL");
        p.novaLinha();
        p.alinharCentro();
        p.texto("Num.:" + Utils.leftPad2(numero, 6, '0') + " Emissao:" + DateFormatter.format().format(new Date()));
        p.novaLinha();
        p.alinharCentro();
        p.texto("Via");
        p.novaLinha();
        p.alinharCentro();
        p.texto(viaConsumidor ? "Consumidor" : "Estabelecimento");
        p.saltarLinhas(5);
        p.linhaCorte();
        p.alinharCentro();
        p.texto("Autenticacao");
        p.novaLinha();
        p.novaLinha();
        p.alinharCentro();
        p.negrito(Empresa.getSlogan());
        p.saltarLinhas(6);
        p.end();
    }

    public void head() throws IOException {
        this.tamanhoFonte(1);
        this.iniciarCond();
        this.alinharCentro();
        this.negrito(Empresa.getRazaoSocial());
        this.novaLinha();
        this.alinharCentro();
        this.texto("CNPJ " + MaskFormatter.format(Empresa.getCnpj(), "##.###.###/####-##") + "    IE " + Empresa.getInscEstadual());
        this.novaLinha();
        this.alinharCentro();
        this.texto(Empresa.getLogradouro() + ", " + Empresa.getNumero() + ", " + Empresa.getComplemento());
        this.novaLinha();
        this.alinharCentro();
        this.texto(Empresa.getBairro() + " - " + Empresa.getMunicipio() + " - " + Empresa.getUf());
        this.novaLinha();
        this.alinharCentro();
        this.texto("CEP " + Empresa.getCep() + "  Fone " + MaskFormatter.format(Empresa.getFone(), "(##) ####-####"));
        this.iniciarCond();
        this.novaLinha();
        this.novaLinha();
    }

    public static void receita(Receita receita) throws Exception {
        if (receita == null) {
            throw new Exception("Receita nula.");
        }
        if (receita.getCliente() == null) {
            throw new Exception("Receita n\u00e3o est\u00e1 vinculada a um cliente.");
        }
        Daruma p = new Daruma();
        p.head();
        p.linhaCorte();
        p.tamanhoFonte(2);
        p.negrito("COPIA RECEITA");
        p.novaLinha();
        p.novaLinha();
        p.leftLine("Cliente: " + receita.getCliente().getNome());
        p.leftLine("CPF: " + receita.getCliente().getCpf());
        p.leftLine("Endereco: " + receita.getCliente().getEndereco());
        p.leftLine("Fone: " + receita.getCliente().getFone() + " Celular: " + receita.getCliente().getCelular());
        p.linhaCorte();
        p.leftLine("Lente: <b>" + receita.getLente() + "</b>");
        p.leftLine("Armacao: " + receita.getArmacao());
        p.linhaCorte();
        p.centerLine("LONGE");
        p.leftLine("          Dir.: " + Utils.leftPad2(receita.getLongeDireitoEsferico(), 6, ' ') + "   " + Utils.leftPad2(receita.getLongeDireitoCilindrico(), 6, ' ') + " X " + receita.getLongeDireitoEixo());
        p.leftLine("          Esq.: " + Utils.leftPad2(receita.getLongeEsquerdoEsferico(), 6, ' ') + "   " + Utils.leftPad2(receita.getLongeEsquerdoCilindrico(), 6, ' ') + " X " + receita.getLongeEsquerdoEixo());
        p.centerLine("PERTO");
        p.leftLine("          Dir.: " + Utils.leftPad2(receita.getPertoDireitoEsferico(), 6, ' ') + "   " + Utils.leftPad2(receita.getPertoDireitoCilindrico(), 6, ' ') + " X " + receita.getPertoDireitoEixo());
        p.leftLine("          Esq.: " + Utils.leftPad2(receita.getPertoEsquerdoEsferico(), 6, ' ') + "   " + Utils.leftPad2(receita.getPertoEsquerdoCilindrico(), 6, ' ') + " X " + receita.getPertoEsquerdoEixo());
        p.linhaCorte();
        p.leftLine("Adicao: <b>" + receita.getAdicao() + "</b>    DNP: <b>" + receita.getDnp() + "</b>   Altura: <b>" + receita.getAltura() + "</b>");
        p.leftLine("Data: " + DateFormatter.format().format(receita.getDataEncomenda()));
        p.leftLine("Medico: " + receita.getMedico());
        p.leftLine("Vendedor: " + receita.getVendedor());
        p.leftLine("<b>OBSERVACAO<b>");
        p.leftLine(receita.getObservacao());
        p.saltarLinhas(5);
    }

    public static void carnet(Crediario crediario) throws Exception {
        if (crediario == null) {
            throw new Exception("Credi\u00e1rio nulo.");
        }
        if (crediario.getCliente() == null) {
            throw new Exception("Credi\u00e1rio n\u00e3o est\u00e1 vinculado a um cliente.");
        }
        List<Parcela> parcelas = crediario.listOf(Parcela.class);
        if (parcelas.isEmpty()) {
            throw new Exception("Lista de parcelas vazia.");
        }
        Daruma p = new Daruma();
        p.head();
        p.linhaCorte();
        p.tamanhoFonte(2);
        p.negrito("CARNET");
        p.novaLinha();
        p.novaLinha();
        p.leftLine("Cliente: " + String.valueOf(crediario.getCliente()));
        p.leftLine("Data da compra: " + DateFormatter.format().format(crediario.getDataVenda()));
        p.leftLine("Valor total: R$ " + Daruma.bold(NumberFormatter.format(2).format(crediario.getValorTotal())));
        p.leftLine("Numero de Parcelas: " + parcelas.size());
        p.linhaCorte();
        for (Parcela parcela : parcelas) {
            p.leftLine("Parcela: " + parcela.getNumeroParcela());
            p.leftLine("Valor: " + NumberFormatter.format(2).format(parcela.getValor()));
            p.leftLine("Data Venc.: " + DateFormatter.format().format(parcela.getDataVencimento()));
            p.leftLine("Data Pgto.: " + (parcela.getDataPagamento() != null ? DateFormatter.format().format(parcela.getDataPagamento()) : "    /    /"));
            p.alinharCentro();
            p.ean13Bar(Utils.leftPad2(parcela.getId(), 12, '0'), 80, false);
            p.centerLine(Utils.leftPad2(parcela.getId(), 12, '0'));
            p.linhaCorte();
        }
        p.saltarLinhas(5);
    }

    public static void danfeNFCe(TNfeProc nfeProc, String cscToken) throws Exception {
        if (nfeProc.getNFe().getInfNFeSupl() == null || nfeProc.getNFe().getInfNFeSupl().getQrCode() == null) {
            TNFe.InfNFe inf = nfeProc.getNFe().getInfNFe();
            Iterator<TNFe.InfNFe.Pag> cpf = inf.getDest() != null ? inf.getDest().getCPF() : null;
            String dhEmi = inf.getIde().getDhEmi();
            String vTotal = inf.getTotal().getICMSTot().getVNF();
            String chaveAcesso = inf.getId();
            String tpAmb = inf.getIde().getTpAmb();
            String digestValue = new String(nfeProc.getNFe().getSignature().getSignedInfo().getReference().getDigestValue());
            StringBuilder params = new StringBuilder();
            params.append("chNFe=").append(chaveAcesso.replace("NFe", "")).append("&");
            params.append("nVersao=100&");
            params.append("tpAmb=").append(tpAmb).append("&");
            if (cpf != null) {
                params.append("cDest=").append((String)((Object)cpf)).append("&");
            }
            params.append("dhEmi=").append(Utils.hexa(dhEmi)).append("&");
            params.append("vNF=").append(vTotal).append("&");
            params.append("vICMS=0.00&");
            params.append("digVal=").append(Utils.hexa(digestValue)).append("&");
            params.append("cIdToken=000001");
            params.append(cscToken);
            String url = "https://www.sefaz.rs.gov.br/NFCE/NFCE-COM.aspx?" + params.toString().replace(cscToken, "") + "&cHashQRCode=" + Utils.sha1(params.toString()).toLowerCase();
            TNFe.InfNFeSupl infNFeSupl = new TNFe.InfNFeSupl();
            infNFeSupl.setQrCode(url);
            nfeProc.getNFe().setInfNFeSupl(infNFeSupl);
        }
        Daruma p = new Daruma();
        p.tamanhoFonte(1);
        p.iniciarCond();
        p.alinharCentro();
        p.texto("CNPJ " + MaskFormatter.format(nfeProc.getNFe().getInfNFe().getEmit().getCNPJ(), "##.###.###/####-##") + "  ");
        p.negrito(nfeProc.getNFe().getInfNFe().getEmit().getXNome());
        p.novaLinha();
        p.alinharCentro();
        p.texto(nfeProc.getNFe().getInfNFe().getEmit().getEnderEmit().getXLgr() + "," + nfeProc.getNFe().getInfNFe().getEmit().getEnderEmit().getNro() + "," + nfeProc.getNFe().getInfNFe().getEmit().getEnderEmit().getXCpl() + "," + nfeProc.getNFe().getInfNFe().getEmit().getEnderEmit().getXBairro() + "," + nfeProc.getNFe().getInfNFe().getEmit().getEnderEmit().getXMun() + "-" + String.valueOf((Object)nfeProc.getNFe().getInfNFe().getEmit().getEnderEmit().getUF()));
        p.novaLinha();
        p.alinharCentro();
        p.texto("Documento Auxiliar Nota Fiscal de Consumidor Eletronica");
        p.novaLinha();
        p.novaLinha();
        p.alinharEsquerda();
        p.negrito(Utils.rightPad2("Codigo", 7, ' ') + Utils.rightPad2("Descricao", 23, ' ') + Utils.rightPad2("Qtde", 5, ' ') + Utils.rightPad2("UN", 6, ' ') + Utils.rightPad2("Vl Unit", 8, ' ') + Utils.leftPad2("Vl Total", 8, ' '));
        for (TNFe.InfNFe.Det det : nfeProc.getNFe().getInfNFe().getDet()) {
            p.novaLinha();
            p.alinharEsquerda();
            p.texto(Utils.rightPad2(Utils.leftPad2(det.getProd().getCProd(), 6, '0'), 7, ' ') + Utils.rightPad2(Utils.leftPad2(Utils.limitWords(det.getProd().getXProd(), 3), 22, ' '), 23, ' ') + Utils.rightPad2(Utils.leftPad2(det.getProd().getQCom(), 4, ' '), 5, ' ') + Utils.rightPad2(det.getProd().getUCom(), 4, ' ') + Utils.leftPad2(NumberFormatter.format().format(Double.valueOf(det.getProd().getVUnCom())), 9, ' ') + Utils.leftPad2(NumberFormatter.format().format(Double.valueOf(det.getProd().getVProd())), 9, ' '));
        }
        p.novaLinha();
        p.novaLinha();
        p.alinharEsquerda();
        p.texto("Qtde total de itens" + Utils.leftPad2(nfeProc.getNFe().getInfNFe().getDet().size(), 38, ' '));
        p.novaLinha();
        p.alinharEsquerda();
        p.texto("Valor total R$" + Utils.leftPad2(NumberFormatter.format().format(Double.valueOf(nfeProc.getNFe().getInfNFe().getTotal().getICMSTot().getVProd())), 43, ' '));
        if (Double.parseDouble(nfeProc.getNFe().getInfNFe().getTotal().getICMSTot().getVDesc()) > 0.0) {
            p.novaLinha();
            p.alinharEsquerda();
            p.texto("Desconto R$" + Utils.leftPad2(NumberFormatter.format().format(Double.valueOf(nfeProc.getNFe().getInfNFe().getTotal().getICMSTot().getVDesc())), 46, ' '));
            p.novaLinha();
            p.alinharEsquerda();
            p.negrito("Valor a Pagar R$" + Utils.leftPad2(NumberFormatter.format().format(Double.valueOf(nfeProc.getNFe().getInfNFe().getTotal().getICMSTot().getVNF())), 41, ' '));
        }
        p.novaLinha();
        p.novaLinha();
        p.alinharEsquerda();
        p.texto("FORMA PAGAMENTO" + Utils.leftPad2("VALOR PAGO R$", 42, ' '));
        for (TNFe.InfNFe.Pag pag : nfeProc.getNFe().getInfNFe().getPag()) {
            String tPag = switch (pag.getTPag()) {
                case "01" -> "Dinheiro";
                case "02" -> "Cheque";
                case "03" -> "Cartao de Credito";
                case "04" -> "Cartao de Debito";
                case "05" -> "Credito Loja";
                case "10" -> "Vale Alimentacao";
                case "11" -> "Vale Refeicao";
                case "12" -> "Vale Presente";
                case "13" -> "Vale Combustivel";
                case "15" -> "Boleto Bancario";
                case "16" -> "Deposito Bancario";
                case "17" -> "Pagamento Instantaneo (PIX)";
                case "18" -> "Transferencia bancaria, Carteira Digita";
                case "19" -> "Programa de fidelidade, Cashback, Cr\u00e9dito Virtual";
                case "90" -> "Sem Pagamento";
                default -> "Outros";
            };
            p.novaLinha();
            p.alinharEsquerda();
            p.texto(tPag + Utils.leftPad2(NumberFormatter.format().format(Double.valueOf(pag.getVPag())), 57 - tPag.length(), ' '));
        }
        p.novaLinha();
        p.novaLinha();
        p.alinharCentro();
        p.negrito("Consulte pela Chave de Acesso em");
        p.novaLinha();
        p.alinharCentro();
        p.texto("https://www.sefaz.rs.gov.br/NFCE/NFCE-COM.aspx");
        p.novaLinha();
        p.alinharCentro();
        p.texto(MaskFormatter.format(nfeProc.getNFe().getInfNFe().getId().replace("NFe", ""), "#### #### #### #### #### #### #### #### #### #### ####"));
        p.novaLinha();
        if (nfeProc.getNFe().getInfNFe().getDest() != null) {
            String nome = nfeProc.getNFe().getInfNFe().getDest().getXNome();
            if (nfeProc.getNFe().getInfNFe().getDest().getCPF() != null) {
                String cpf = nfeProc.getNFe().getInfNFe().getDest().getCPF();
                p.novaLinha();
                p.alinharCentro();
                p.negrito("CONSUMIDOR - CPF " + MaskFormatter.format(cpf, "###.###.###-##"));
            } else if (nfeProc.getNFe().getInfNFe().getDest().getIdEstrangeiro() != null) {
                String idEstrangeiro = nfeProc.getNFe().getInfNFe().getDest().getCPF();
                p.novaLinha();
                p.alinharCentro();
                p.negrito("CONSUMIDOR - ID ESTRANGEIRO " + idEstrangeiro);
            }
            if (!nome.isEmpty()) {
                p.novaLinha();
                p.alinharCentro();
                p.texto(nome);
            }
        } else {
            p.novaLinha();
            p.alinharCentro();
            p.negrito("CONSUMIDOR NAO IDENTIFICADO");
        }
        p.novaLinha();
        p.novaLinha();
        p.alinharCentro();
        p.negrito("NFC-e " + Utils.leftPad2(nfeProc.getNFe().getInfNFe().getIde().getNNF(), 9, '0') + " Serie " + Utils.leftPad2(nfeProc.getNFe().getInfNFe().getIde().getSerie(), 3, '0') + " " + TimestampFormatter.format().format(Utils.dateNFe2Date(nfeProc.getNFe().getInfNFe().getIde().getDhEmi()).getTime()));
        if (nfeProc.getProtNFe().getInfProt().getNProt() != null && nfeProc.getProtNFe().getInfProt().getDhRecbto() != null && nfeProc.getNFe().getInfNFeSupl().getQrCode() != null) {
            p.novaLinha();
            p.alinharCentro();
            p.negrito("Protocolo de autorizacao: ");
            p.texto(MaskFormatter.format(nfeProc.getProtNFe().getInfProt().getNProt(), "### ########## ##"));
            p.novaLinha();
            p.alinharCentro();
            p.negrito("Data de autorizacao ");
            p.texto(TimestampFormatter.format().format(Utils.dateNFe2Date(nfeProc.getProtNFe().getInfProt().getDhRecbto()).getTime()));
            p.novaLinha();
            p.novaLinha();
            p.alinharCentro();
            p.qrCode(nfeProc.getNFe().getInfNFeSupl().getQrCode());
            p.novaLinha();
            p.alinharCentro();
            p.texto(nfeProc.getNFe().getInfNFe().getInfAdic().getInfCpl());
            p.saltarLinhas(7);
        }
        p.end();
    }

    public static void danfeNFCe4(br.inf.portalfiscal.nfe.v400.autorizacao.TNfeProc nfeProc) throws IOException {
        Daruma p = new Daruma();
        double troco = Double.parseDouble(nfeProc.getNFe().getInfNFe().getPag().getVTroco());
        p.tamanhoFonte(1);
        p.iniciarCond();
        p.alinharCentro();
        p.negrito(nfeProc.getNFe().getInfNFe().getEmit().getXNome());
        p.novaLinha();
        p.alinharCentro();
        p.texto("CNPJ " + MaskFormatter.format(nfeProc.getNFe().getInfNFe().getEmit().getCNPJ(), "##.###.###/####-##") + "    IE " + nfeProc.getNFe().getInfNFe().getEmit().getIE());
        p.novaLinha();
        p.alinharCentro();
        p.texto(nfeProc.getNFe().getInfNFe().getEmit().getEnderEmit().getXLgr() + ", " + nfeProc.getNFe().getInfNFe().getEmit().getEnderEmit().getNro() + ", " + nfeProc.getNFe().getInfNFe().getEmit().getEnderEmit().getXCpl());
        p.novaLinha();
        p.alinharCentro();
        p.texto(nfeProc.getNFe().getInfNFe().getEmit().getEnderEmit().getXBairro() + " - " + nfeProc.getNFe().getInfNFe().getEmit().getEnderEmit().getXMun() + " - " + String.valueOf((Object)nfeProc.getNFe().getInfNFe().getEmit().getEnderEmit().getUF()));
        p.novaLinha();
        p.alinharCentro();
        p.texto("CEP " + nfeProc.getNFe().getInfNFe().getEmit().getEnderEmit().getCEP() + "  Fone " + MaskFormatter.format(nfeProc.getNFe().getInfNFe().getEmit().getEnderEmit().getFone(), "(##) ####-####"));
        p.iniciarCond();
        p.novaLinha();
        p.iniciarCond();
        p.novaLinha();
        p.alinharCentro();
        p.negrito("DANFE NFC-e - Documento Auxiliar");
        p.novaLinha();
        p.alinharCentro();
        p.negrito("da Nota Fiscal de Consumidor Eletronica");
        p.novaLinha();
        p.novaLinha();
        p.alinharEsquerda();
        p.negrito(Utils.rightPad2("Codigo", 7, ' ') + Utils.rightPad2("Descricao", 51, ' '));
        p.alinharDireita();
        p.negrito(Utils.rightPad2("Qtde", 10, ' ') + Utils.rightPad2("UN", 10, ' ') + " x " + Utils.leftPad2("Vl Unit", 17, ' ') + Utils.leftPad2("Vl Total", 16, ' '));
        for (TNFe.InfNFe.Det det : nfeProc.getNFe().getInfNFe().getDet()) {
            p.novaLinha();
            p.alinharEsquerda();
            p.texto(Utils.rightPad2(Utils.leftPad2(det.getProd().getCProd(), 6, '0'), 7, ' ') + Utils.rightPad2(Utils.leftPad2(det.getProd().getXProd(), 50, ' '), 51, ' '));
            p.alinharDireita();
            p.texto(Utils.rightPad2(Utils.leftPad2(det.getProd().getQCom(), 6, ' '), 10, ' ') + Utils.rightPad2(det.getProd().getUCom(), 10, ' ') + " x " + Utils.leftPad2(NumberFormatter.format().format(Double.valueOf(det.getProd().getVUnCom())), 17, ' ') + Utils.leftPad2(NumberFormatter.format().format(Double.valueOf(det.getProd().getVProd())), 16, ' '));
            if (det.getProd().getVDesc() == null || !(Double.parseDouble(det.getProd().getVDesc()) > 0.0)) continue;
            p.novaLinha();
            p.alinharDireita();
            p.texto("Desconto " + NumberFormatter.format(2).format(Double.parseDouble(det.getProd().getVDesc())));
        }
        p.novaLinha();
        p.novaLinha();
        p.alinharEsquerda();
        p.texto("Qtde total de itens" + Utils.leftPad2(nfeProc.getNFe().getInfNFe().getDet().size(), 38, ' '));
        p.novaLinha();
        p.alinharEsquerda();
        p.texto("Valor total R$" + Utils.leftPad2(NumberFormatter.format().format(Double.valueOf(nfeProc.getNFe().getInfNFe().getTotal().getICMSTot().getVProd())), 43, ' '));
        if (Double.parseDouble(nfeProc.getNFe().getInfNFe().getTotal().getICMSTot().getVDesc()) > 0.0) {
            p.novaLinha();
            p.alinharEsquerda();
            p.texto("Desconto R$" + Utils.leftPad2(NumberFormatter.format().format(Double.valueOf(nfeProc.getNFe().getInfNFe().getTotal().getICMSTot().getVDesc())), 46, ' '));
            p.novaLinha();
            p.alinharEsquerda();
            p.negrito("Valor a Pagar R$" + Utils.leftPad2(NumberFormatter.format().format(Double.valueOf(nfeProc.getNFe().getInfNFe().getTotal().getICMSTot().getVNF())), 41, ' '));
        }
        p.novaLinha();
        p.novaLinha();
        p.alinharEsquerda();
        p.texto("FORMA PAGAMENTO" + Utils.leftPad2("VALOR PAGO R$", 42, ' '));
        for (TNFe.InfNFe.Pag.DetPag detPag : nfeProc.getNFe().getInfNFe().getPag().getDetPag()) {
            String tPag = switch (detPag.getTPag()) {
                case "01" -> "Dinheiro";
                case "02" -> "Cheque";
                case "03" -> "Cartao de Credito";
                case "04" -> "Cartao de Debito";
                case "05" -> "Credito Loja";
                case "10" -> "Vale Alimentacao";
                case "11" -> "Vale Refeicao";
                case "12" -> "Vale Presente";
                case "13" -> "Vale Combustivel";
                case "15" -> "Boleto Bancario";
                case "16" -> "Deposito Bancario";
                case "17" -> "Pagamento Instantaneo (PIX)";
                case "18" -> "Transferencia bancaria, Carteira Digita";
                case "19" -> "Programa de fidelidade, Cashback, Cr\u00e9dito Virtual";
                case "90" -> "Sem Pagamento";
                default -> "Outros";
            };
            p.novaLinha();
            p.alinharEsquerda();
            p.texto(tPag + Utils.leftPad2(NumberFormatter.format().format(Double.valueOf(detPag.getVPag())), 57 - tPag.length(), ' '));
        }
        p.novaLinha();
        p.alinharEsquerda();
        p.texto("Troco R$" + Utils.leftPad2(NumberFormatter.format().format(troco), 49, ' '));
        p.novaLinha();
        p.novaLinha();
        p.alinharCentro();
        p.negrito("Consulte pela Chave de Acesso em");
        p.novaLinha();
        p.alinharCentro();
        p.texto(nfeProc.getNFe().getInfNFeSupl().getUrlChave());
        p.novaLinha();
        p.novaLinha();
        p.alinharCentro();
        p.texto("CHAVE DE ACESSO");
        p.novaLinha();
        p.alinharCentro();
        p.texto(MaskFormatter.format(nfeProc.getNFe().getInfNFe().getId().replace("NFe", ""), "#### #### #### #### #### #### #### #### #### #### ####"));
        p.novaLinha();
        if (nfeProc.getNFe().getInfNFe().getDest() != null) {
            if (nfeProc.getNFe().getInfNFe().getDest().getCPF() != null) {
                String cpf = nfeProc.getNFe().getInfNFe().getDest().getCPF();
                p.novaLinha();
                p.alinharCentro();
                p.negrito("CONSUMIDOR - CPF " + MaskFormatter.format(cpf, "###.###.###-##"));
            } else if (nfeProc.getNFe().getInfNFe().getDest().getIdEstrangeiro() != null) {
                String idEstrangeiro = nfeProc.getNFe().getInfNFe().getDest().getCPF();
                p.novaLinha();
                p.alinharCentro();
                p.negrito("CONSUMIDOR - ID ESTRANGEIRO " + idEstrangeiro);
            }
            if (nfeProc.getNFe().getInfNFe().getDest().getXNome() != null) {
                String nome = nfeProc.getNFe().getInfNFe().getDest().getXNome();
                p.novaLinha();
                p.alinharCentro();
                p.texto(nome);
            }
        } else {
            p.novaLinha();
            p.alinharCentro();
            p.negrito("CONSUMIDOR NAO IDENTIFICADO");
        }
        p.novaLinha();
        p.novaLinha();
        p.alinharCentro();
        p.negrito("NFC-e " + Utils.leftPad2(nfeProc.getNFe().getInfNFe().getIde().getNNF(), 9, '0') + " Serie " + Utils.leftPad2(nfeProc.getNFe().getInfNFe().getIde().getSerie(), 3, '0') + " " + TimestampFormatter.format().format(Utils.dateNFe2Date(nfeProc.getNFe().getInfNFe().getIde().getDhEmi()).getTime()));
        if (nfeProc.getProtNFe().getInfProt().getNProt() != null && nfeProc.getProtNFe().getInfProt().getDhRecbto() != null && nfeProc.getNFe().getInfNFeSupl().getQrCode() != null) {
            p.novaLinha();
            p.alinharCentro();
            p.negrito("Protocolo de autorizacao: ");
            p.texto(MaskFormatter.format(nfeProc.getProtNFe().getInfProt().getNProt(), "### ########## ##"));
            p.novaLinha();
            p.alinharCentro();
            p.negrito("Data de autorizacao ");
            p.texto(TimestampFormatter.format().format(Utils.dateNFe2Date(nfeProc.getProtNFe().getInfProt().getDhRecbto()).getTime()));
            p.novaLinha();
            p.novaLinha();
            p.alinharCentro();
            p.qrCode(nfeProc.getNFe().getInfNFeSupl().getQrCode());
            p.novaLinha();
            p.alinharCentro();
            p.texto("Documento emitido por ME ou EPP optante pelo");
            p.novaLinha();
            p.alinharCentro();
            p.texto("Simples Nacional.");
            p.novaLinha();
            p.alinharCentro();
            p.texto(nfeProc.getNFe().getInfNFe().getInfAdic().getInfCpl().replace("Documento emitido por ME ou EPP optante pelo Simples Nacional.", ""));
            p.novaLinha();
            p.novaLinha();
            p.alinharCentro();
            p.negrito(Empresa.getSlogan());
            p.saltarLinhas(7);
        }
        p.end();
    }

    static {
        Properties prop = new Properties();
        try {
            File file = new File("config", "impressora.properties");
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                prop.setProperty("porta", "/dev/ttyUSB0");
                prop.setProperty("colunas", "57");
                prop.store(new FileOutputStream(file), "Configura\u00e7\u00f5es do sistema");
            } else {
                prop.load(new FileInputStream(file));
            }
            PORT = prop.getProperty("porta");
            COLUMNS = Integer.parseInt(prop.getProperty("colunas"));
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex, "Exception", 0);
        }
        TAB = new char[]{'\t'};
        ALIGN_LEFT = new char[]{'\u001b', 'j', '\u0000'};
        ALIGN_CENTER = new char[]{'\u001b', 'j', '\u0001'};
        ALIGN_RIGHT = new char[]{'\u001b', 'j', '\u0002'};
        CHAR_SIZE_0 = new char[]{'\u001b', '!', '\u0000'};
        CHAR_SIZE_1 = new char[]{'\u001b', '!', '\u0001'};
        CHAR_SIZE_2 = new char[]{'\u001b', '!', '0'};
        CHAR_SIZE_3 = new char[]{'\u001b', '!', '1'};
        START_ITALIC = new char[]{'\u001b', '4', '\u0001'};
        END_ITALIC = new char[]{'\u001b', '4', '\u0000'};
        START_BOLD = new char[]{'\u001b', 'E'};
        END_BOLD = new char[]{'\u001b', 'F'};
        START_TEXT_COND = new char[]{'\u000f'};
        END_TEXT_COND = new char[]{'\u0012'};
        TEXT_EXPAND = new char[]{'\u000e'};
        TEXT_NORMAL = new char[]{'\u0014'};
        GUILHOTINA = new char[]{'m'};
    }
}

